/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core.resource;

import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.UnsynchronizedByteArrayInputStream;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.tika.exception.TikaMemoryLimitException;
import org.apache.tika.extractor.DefaultEmbeddedStreamTranslator;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedStreamTranslator;
import org.apache.tika.io.BoundedInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.parser.DigestingParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.RichTextContentHandler;
import org.apache.tika.server.core.resource.TikaResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Path(value="/unpack")
public class UnpackerResource {
    public static final String TEXT_FILENAME = "__TEXT__";
    public static final String META_FILENAME = "__METADATA__";
    public static final String UNPACK_MAX_BYTES_KEY = "unpackMaxBytes";
    private static final long DEFAULT_MAX_ATTACHMENT_BYTES = 0x6400000L;
    private static final Logger LOG = LoggerFactory.getLogger(UnpackerResource.class);

    public static void metadataToCsv(Metadata metadata, OutputStream outputStream) throws IOException {
        CSVPrinter writer = new CSVPrinter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8), CSVFormat.EXCEL);
        for (String name : metadata.names()) {
            String[] values = metadata.getValues(name);
            ArrayList<String> list = new ArrayList<String>(values.length + 1);
            list.add(name);
            list.addAll(Arrays.asList(values));
            writer.printRecord(list);
        }
        writer.close();
    }

    @Path(value="/{id:(/.*)?}")
    @PUT
    @Produces(value={"application/zip", "application/x-tar"})
    public Map<String, byte[]> unpack(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info) throws Exception {
        return this.process(TikaResource.getInputStream(is, new Metadata(), httpHeaders, info), httpHeaders, info, false);
    }

    @Path(value="/all{id:(/.*)?}")
    @PUT
    @Produces(value={"application/zip", "application/x-tar"})
    public Map<String, byte[]> unpackAll(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info) throws Exception {
        return this.process(TikaResource.getInputStream(is, new Metadata(), httpHeaders, info), httpHeaders, info, true);
    }

    private Map<String, byte[]> process(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info, boolean saveAll) throws Exception {
        Parser parser;
        Metadata metadata = new Metadata();
        ParseContext pc = new ParseContext();
        long unpackMaxBytes = 0x6400000L;
        String unpackMaxBytesString = httpHeaders.getRequestHeaders().getFirst(UNPACK_MAX_BYTES_KEY);
        if (!StringUtils.isBlank(unpackMaxBytesString)) {
            unpackMaxBytes = Long.parseLong(unpackMaxBytesString);
            if (unpackMaxBytes > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Can't request value > than Integer.MAX_VALUE : " + unpackMaxBytes);
            }
            if (unpackMaxBytes < 0L) {
                throw new IllegalArgumentException("Can't request value < 0: " + unpackMaxBytes);
            }
        }
        if ((parser = TikaResource.createParser()) instanceof DigestingParser) {
            parser = ((DigestingParser)parser).getWrappedParser();
        }
        TikaResource.fillMetadata(parser, metadata, httpHeaders.getRequestHeaders());
        TikaResource.fillParseContext(httpHeaders.getRequestHeaders(), metadata, pc);
        TikaResource.logRequest(LOG, "/unpack", metadata);
        pc.set(Parser.class, parser);
        UnsynchronizedByteArrayOutputStream text = UnsynchronizedByteArrayOutputStream.builder().get();
        DefaultHandler ch = saveAll ? new BodyContentHandler(new RichTextContentHandler(new OutputStreamWriter((OutputStream)text, StandardCharsets.UTF_8))) : new DefaultHandler();
        HashMap<String, byte[]> files = new HashMap<String, byte[]>();
        MutableInt count = new MutableInt();
        pc.set(EmbeddedDocumentExtractor.class, new MyEmbeddedDocumentExtractor(count, files, unpackMaxBytes));
        TikaResource.parse(parser, LOG, info.getPath(), is, ch, metadata, pc);
        if (count.intValue() == 0 && !saveAll) {
            throw new WebApplicationException(Response.Status.NO_CONTENT);
        }
        if (saveAll) {
            files.put(TEXT_FILENAME, text.toByteArray());
            UnsynchronizedByteArrayOutputStream metaStream = UnsynchronizedByteArrayOutputStream.builder().get();
            UnpackerResource.metadataToCsv(metadata, metaStream);
            files.put(META_FILENAME, metaStream.toByteArray());
        }
        return files;
    }

    private static class MyEmbeddedDocumentExtractor
    implements EmbeddedDocumentExtractor {
        private final MutableInt count;
        private final Map<String, byte[]> zout;
        private final long unpackMaxBytes;
        private final EmbeddedStreamTranslator embeddedStreamTranslator = new DefaultEmbeddedStreamTranslator();

        MyEmbeddedDocumentExtractor(MutableInt count, Map<String, byte[]> zout, long unpackMaxBytes) {
            this.count = count;
            this.zout = zout;
            this.unpackMaxBytes = unpackMaxBytes;
        }

        @Override
        public boolean shouldParseEmbedded(Metadata metadata) {
            return true;
        }

        @Override
        public void parseEmbedded(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, boolean b) throws SAXException, IOException {
            UnsynchronizedByteArrayOutputStream bos = UnsynchronizedByteArrayOutputStream.builder().get();
            BoundedInputStream bis = new BoundedInputStream(this.unpackMaxBytes, inputStream);
            IOUtils.copy((InputStream)bis, (OutputStream)bos);
            if (bis.hasHitBound()) {
                throw new IOException(new TikaMemoryLimitException("An attachment is longer than 'unpackMaxBytes' (default=100MB, actual=" + this.unpackMaxBytes + "). If you need to increase this limit, add a header to your request, such as: unpackMaxBytes: 1073741824.  There is a hard limit of 2GB."));
            }
            byte[] data = bos.toByteArray();
            Object name = metadata.get("resourceName");
            String contentType = metadata.get("Content-Type");
            if (name == null) {
                name = Integer.toString(this.count.intValue());
            }
            if (!((String)name).contains(".") && contentType != null) {
                try {
                    String ext = TikaResource.getConfig().getMimeRepository().forName(contentType).getExtension();
                    if (ext != null) {
                        name = (String)name + ext;
                    }
                }
                catch (MimeTypeException e) {
                    LOG.warn("Unexpected MimeTypeException", e);
                }
            }
            try (UnsynchronizedByteArrayInputStream is = UnsynchronizedByteArrayInputStream.builder().setByteArray(data).get();){
                if (this.embeddedStreamTranslator.shouldTranslate(is, metadata)) {
                    InputStream translated = this.embeddedStreamTranslator.translate(UnsynchronizedByteArrayInputStream.builder().setByteArray(data).get(), metadata);
                    UnsynchronizedByteArrayOutputStream bos2 = UnsynchronizedByteArrayOutputStream.builder().get();
                    IOUtils.copy(translated, (OutputStream)bos2);
                    data = bos2.toByteArray();
                }
            }
            String finalName = this.getFinalName((String)name, this.zout);
            if (data.length > 0) {
                this.zout.put(finalName, data);
                this.count.increment();
            }
        }

        private String getFinalName(String name, Map<String, byte[]> zout) {
            int prefixLength;
            String normalizedName = FilenameUtils.normalize(name = name.replaceAll("\u0000", " "));
            if (normalizedName == null) {
                normalizedName = FilenameUtils.getName(name);
            }
            if (normalizedName == null) {
                normalizedName = this.count.toString();
            }
            if ((prefixLength = FilenameUtils.getPrefixLength(normalizedName)) > -1) {
                normalizedName = normalizedName.substring(prefixLength);
            }
            if (zout.containsKey(normalizedName)) {
                return UUID.randomUUID().toString() + "-" + normalizedName;
            }
            return normalizedName;
        }
    }
}

