/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core.resource;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.tika.config.LoadErrorHandler;
import org.apache.tika.config.ServiceLoader;
import org.apache.tika.exception.TikaException;
import org.apache.tika.langdetect.optimaize.OptimaizeLangDetector;
import org.apache.tika.language.detect.LanguageResult;
import org.apache.tika.language.translate.Translator;
import org.apache.tika.server.core.ServerStatus;
import org.apache.tika.server.core.resource.TikaResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/translate")
public class TranslateResource {
    private static final Logger LOG = LoggerFactory.getLogger(TranslateResource.class);
    private final ServerStatus serverStatus;
    private final long timeoutMillis;
    private Translator defaultTranslator;
    private ServiceLoader loader = new ServiceLoader(ServiceLoader.class.getClassLoader(), LoadErrorHandler.WARN);

    public TranslateResource(ServerStatus serverStatus, long timeoutMillis) {
        this.defaultTranslator = TikaResource.getConfig().getTranslator();
        this.serverStatus = serverStatus;
        this.timeoutMillis = timeoutMillis;
    }

    @PUT
    @POST
    @Path(value="/all/{translator}/{src}/{dest}")
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    public String translate(InputStream is, @PathParam(value="translator") String translator, @PathParam(value="src") String sLang, @PathParam(value="dest") String dLang) throws TikaException, IOException {
        return this.doTranslate(IOUtils.toString(is, StandardCharsets.UTF_8), translator, sLang, dLang);
    }

    @PUT
    @POST
    @Path(value="/all/{translator}/{dest}")
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    public String autoTranslate(InputStream is, @PathParam(value="translator") String translator, @PathParam(value="dest") String dLang) throws TikaException, IOException {
        String content = IOUtils.toString(is, StandardCharsets.UTF_8);
        LanguageResult language = new OptimaizeLangDetector().loadModels().detect(content);
        if (language.isUnknown()) {
            throw new TikaException("Unable to detect language to use for translation of text");
        }
        String sLang = language.getLanguage();
        LOG.info("LanguageIdentifier: detected source lang: [{}]", (Object)sLang);
        return this.doTranslate(content, translator, sLang, dLang);
    }

    private String doTranslate(String content, String translator, String sLang, String dLang) throws TikaException, IOException {
        LOG.info("Using translator: [{}]: src: [{}]: dest: [{}]", translator, sLang, dLang);
        Translator translate = this.byClassName(translator);
        if (translate == null) {
            translate = this.defaultTranslator;
            LOG.info("Using default translator");
        }
        TikaResource.checkIsOperating();
        long taskId = this.serverStatus.start(ServerStatus.TASK.TRANSLATE, null, this.timeoutMillis);
        try {
            String string = translate.translate(content, sLang, dLang);
            return string;
        }
        catch (OutOfMemoryError e) {
            this.serverStatus.setStatus(ServerStatus.STATUS.ERROR);
            throw e;
        }
        finally {
            this.serverStatus.complete(taskId);
        }
    }

    private Translator byClassName(String className) {
        List<Translator> translators = this.loader.loadStaticServiceProviders(Translator.class);
        for (Translator t : translators) {
            if (!t.getClass().getName().equals(className)) continue;
            return t;
        }
        return null;
    }
}

