/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core.resource;

import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.tika.Tika;
import org.apache.tika.server.core.HTMLHelper;
import org.apache.tika.server.core.resource.TikaResource;

@Path(value="/")
public class TikaWelcome {
    private static final String DOCS_URL = "https://wiki.apache.org/tika/TikaJAXRS";
    private static final Map<Class<? extends Annotation>, String> HTTP_METHODS = new HashMap<Class<? extends Annotation>, String>();
    private Tika tika;
    private HTMLHelper html;
    private List<Class<?>> endpoints = new LinkedList();

    public TikaWelcome(List<ResourceProvider> rCoreProviders) {
        this.tika = new Tika(TikaResource.getConfig());
        this.html = new HTMLHelper();
        for (ResourceProvider rp : rCoreProviders) {
            this.endpoints.add(rp.getResourceClass());
        }
    }

    protected List<Endpoint> identifyEndpoints() {
        ArrayList<Endpoint> found = new ArrayList<Endpoint>();
        for (Class<?> endpoint : this.endpoints) {
            Path p = endpoint.getAnnotation(Path.class);
            String basePath = null;
            if (p != null) {
                basePath = p.value().endsWith("/") ? p.value().substring(0, p.value().length() - 2) : p.value();
            }
            for (Method m : endpoint.getMethods()) {
                String httpMethod = null;
                String methodPath = null;
                String[] produces = null;
                for (Annotation a : m.getAnnotations()) {
                    for (Class<? extends Annotation> httpMethAnn : HTTP_METHODS.keySet()) {
                        if (!httpMethAnn.isInstance(a)) continue;
                        httpMethod = HTTP_METHODS.get(httpMethAnn);
                    }
                    if (a instanceof Path) {
                        methodPath = ((Path)a).value();
                    }
                    if (!(a instanceof Produces)) continue;
                    produces = ((Produces)a).value();
                }
                if (httpMethod == null) continue;
                Object mPath = basePath;
                if (mPath == null) {
                    mPath = "";
                }
                if (methodPath != null) {
                    mPath = methodPath.startsWith("/") ? (String)mPath + methodPath : (String)mPath + "/" + methodPath;
                }
                if (produces == null) {
                    produces = new String[]{};
                }
                found.add(new Endpoint(endpoint, m, (String)mPath, httpMethod, produces));
            }
        }
        found.sort(Comparator.comparing(e -> e.path).thenComparing(e -> e.methodName));
        return found;
    }

    @GET
    @Produces(value={"text/html"})
    public String getWelcomeHTML() {
        TikaResource.checkIsOperating();
        StringBuffer h = new StringBuffer();
        String tikaVersion = this.tika.toString();
        this.html.generateHeader(h, "Welcome to the " + tikaVersion + " Server");
        h.append("<p>For endpoints, please see <a href=\"");
        h.append(DOCS_URL);
        h.append("\">");
        h.append(DOCS_URL);
        h.append("</a>");
        Pattern p = Pattern.compile("\\d+\\.\\d+");
        Matcher m = p.matcher(tikaVersion);
        if (m.find()) {
            String versionNumber = m.group();
            String miredot = "https://tika.apache.org/" + versionNumber + "/miredot/index.html";
            h.append(" and <a href=\"").append(miredot).append("\">").append(miredot).append("</a>");
        }
        h.append("</p>\n");
        h.append("<ul>\n");
        for (Endpoint e : this.identifyEndpoints()) {
            h.append("<li><b>");
            h.append(e.httpMethod);
            h.append("</b> <i><a href=\"");
            h.append(e.path);
            h.append("\">");
            h.append(e.path);
            h.append("</a></i><br />");
            h.append("Class: ");
            h.append(e.className);
            h.append("<br />Method: ");
            h.append(e.methodName);
            for (String produces : e.produces) {
                h.append("<br />Produces: ");
                h.append(produces);
            }
            h.append("</li>\n");
        }
        h.append("</ul>\n");
        this.html.generateFooter(h);
        return h.toString();
    }

    @GET
    @Produces(value={"text/plain"})
    public String getWelcomePlain() {
        TikaResource.checkIsOperating();
        StringBuilder text = new StringBuilder();
        text.append(this.tika.toString());
        text.append("\n");
        text.append("For endpoints, please see ");
        text.append(DOCS_URL);
        text.append("\n\n");
        for (Endpoint e : this.identifyEndpoints()) {
            text.append(e.httpMethod);
            text.append(" ");
            text.append(e.path);
            text.append("\n");
            for (String produces : e.produces) {
                text.append(" => ");
                text.append(produces);
                text.append("\n");
            }
        }
        return text.toString();
    }

    static {
        HTTP_METHODS.put(DELETE.class, "DELETE");
        HTTP_METHODS.put(GET.class, "GET");
        HTTP_METHODS.put(HEAD.class, "HEAD");
        HTTP_METHODS.put(OPTIONS.class, "OPTIONS");
        HTTP_METHODS.put(POST.class, "POST");
        HTTP_METHODS.put(PUT.class, "PUT");
    }

    protected static class Endpoint {
        public final String className;
        public final String methodName;
        public final String path;
        public final String httpMethod;
        public final List<String> produces;

        protected Endpoint(Class<?> endpoint, Method method, String path, String httpMethod, String[] produces) {
            this.className = endpoint.getCanonicalName();
            this.methodName = method.getName();
            this.path = path;
            this.httpMethod = httpMethod;
            this.produces = Collections.unmodifiableList(Arrays.asList(produces));
        }
    }
}

