/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core.resource;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.tika.server.core.ServerStatus;

@Path(value="/status")
public class TikaServerStatus {
    private final ServerStatus serverStatus;

    public TikaServerStatus(ServerStatus serverStatus) {
        this.serverStatus = serverStatus;
    }

    @GET
    @Produces(value={"application/json"})
    public Map<String, Object> getStatus() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("server_id", this.serverStatus.getServerId());
        map.put("status", (Object)this.serverStatus.getStatus());
        map.put("millis_since_last_parse_started", this.serverStatus.getMillisSinceLastParseStarted());
        map.put("files_processed", this.serverStatus.getFilesProcessed());
        map.put("num_restarts", this.serverStatus.getNumRestarts());
        return map;
    }
}

