/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core.resource;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.cxf.attachment.ContentDisposition;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.tika.Tika;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.config.TikaTaskTimeout;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.WriteLimitReachedException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.DigestingParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.pipes.HandlerConfig;
import org.apache.tika.sax.BasicContentHandlerFactory;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.ExpandedTitleContentHandler;
import org.apache.tika.sax.RichTextContentHandler;
import org.apache.tika.sax.boilerpipe.BoilerpipeContentHandler;
import org.apache.tika.server.core.CompositeParseContextConfig;
import org.apache.tika.server.core.InputStreamFactory;
import org.apache.tika.server.core.ParseContextConfig;
import org.apache.tika.server.core.ServerStatus;
import org.apache.tika.server.core.TikaServerConfig;
import org.apache.tika.server.core.TikaServerParseException;
import org.apache.tika.server.core.resource.RecursiveMetadataResource;
import org.apache.tika.utils.ExceptionUtils;
import org.apache.tika.utils.XMLReaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

@Path(value="/tika")
public class TikaResource {
    public static final String GREETING = "This is Tika Server (" + Tika.getString() + "). Please PUT\n";
    private static final String META_PREFIX = "meta_";
    private static final Logger LOG = LoggerFactory.getLogger(TikaResource.class);
    private static Pattern ALLOWABLE_HEADER_CHARS = Pattern.compile("(?i)^[-/_+\\.A-Z0-9 ]+$");
    private static TikaConfig TIKA_CONFIG;
    private static TikaServerConfig TIKA_SERVER_CONFIG;
    private static DigestingParser.Digester DIGESTER;
    private static InputStreamFactory INPUTSTREAM_FACTORY;
    private static ServerStatus SERVER_STATUS;
    private static ParseContextConfig PARSE_CONTEXT_CONFIG;

    public static void init(TikaConfig config, TikaServerConfig tikaServerConfg, DigestingParser.Digester digester, InputStreamFactory inputStreamFactory, ServerStatus serverStatus) {
        TIKA_CONFIG = config;
        TIKA_SERVER_CONFIG = tikaServerConfg;
        DIGESTER = digester;
        INPUTSTREAM_FACTORY = inputStreamFactory;
        SERVER_STATUS = serverStatus;
    }

    public static Parser createParser() {
        AutoDetectParser parser = new AutoDetectParser(TIKA_CONFIG);
        if (DIGESTER != null) {
            boolean skipContainer = false;
            if (TIKA_CONFIG.getAutoDetectParserConfig().getDigesterFactory() != null && TIKA_CONFIG.getAutoDetectParserConfig().getDigesterFactory().isSkipContainerDocument()) {
                skipContainer = true;
            }
            return new DigestingParser(parser, DIGESTER, skipContainer);
        }
        return parser;
    }

    public static TikaConfig getConfig() {
        return TIKA_CONFIG;
    }

    public static String detectFilename(MultivaluedMap<String, String> httpHeaders) {
        String fn;
        ContentDisposition c;
        String disposition = httpHeaders.getFirst("Content-Disposition");
        if (disposition != null && "attachment".equals((c = new ContentDisposition(disposition)).getType()) && (fn = c.getParameter("filename")) != null) {
            return fn;
        }
        return httpHeaders.getFirst("File-Name");
    }

    public static void fillParseContext(MultivaluedMap<String, String> httpHeaders, Metadata metadata, ParseContext parseContext) {
        PARSE_CONTEXT_CONFIG.configure(httpHeaders, metadata, parseContext);
    }

    public static InputStream getInputStream(InputStream is, Metadata metadata, HttpHeaders headers, UriInfo uriInfo) {
        try {
            return INPUTSTREAM_FACTORY.getInputStream(is, metadata, headers, uriInfo);
        }
        catch (IOException e) {
            throw new TikaServerParseException(e);
        }
    }

    public static void processHeaderConfig(Object object, String key, String val, String prefix) {
        block31: {
            try {
                Method m;
                String property = Strings.CI.removeStart(key, prefix);
                Field field = null;
                try {
                    field = object.getClass().getDeclaredField(StringUtils.uncapitalize(property));
                }
                catch (NoSuchFieldException e) {
                    for (Field aField : object.getClass().getDeclaredFields()) {
                        if (!aField.getName().equalsIgnoreCase(property)) continue;
                        field = aField;
                        break;
                    }
                }
                Object setter = field != null ? field.getName() : property;
                setter = "set" + ((String)setter).substring(0, 1).toUpperCase(Locale.US) + ((String)setter).substring(1);
                Class clazz = String.class;
                if (field != null) {
                    if (field.getType() == Integer.TYPE || field.getType() == Integer.class) {
                        clazz = Integer.TYPE;
                    } else if (field.getType() == Double.TYPE) {
                        clazz = Double.TYPE;
                    } else if (field.getType() == Double.class) {
                        clazz = Double.class;
                    } else if (field.getType() == Float.TYPE) {
                        clazz = Float.TYPE;
                    } else if (field.getType() == Float.class) {
                        clazz = Float.class;
                    } else if (field.getType() == Boolean.TYPE) {
                        clazz = Boolean.TYPE;
                    } else if (field.getType() == Boolean.class) {
                        clazz = Boolean.class;
                    } else if (field.getType() == Long.TYPE) {
                        clazz = Long.TYPE;
                    } else if (field.getType() == Long.class) {
                        clazz = Long.class;
                    }
                }
                if ((m = TikaResource.tryToGetMethod(object, (String)setter, clazz)) == null && clazz != String.class) {
                    m = TikaResource.tryToGetMethod(object, (String)setter, String.class);
                }
                if (m != null) {
                    if (clazz == String.class) {
                        TikaResource.checkTrustWorthy((String)setter, val);
                        m.invoke(object, val);
                        break block31;
                    }
                    if (clazz == Integer.TYPE || clazz == Integer.class) {
                        m.invoke(object, Integer.parseInt(val));
                        break block31;
                    }
                    if (clazz == Double.TYPE || clazz == Double.class) {
                        m.invoke(object, Double.parseDouble(val));
                        break block31;
                    }
                    if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                        m.invoke(object, Boolean.parseBoolean(val));
                        break block31;
                    }
                    if (clazz == Float.TYPE || clazz == Float.class) {
                        m.invoke(object, Float.valueOf(Float.parseFloat(val)));
                        break block31;
                    }
                    if (clazz == Long.TYPE || clazz == Long.class) {
                        m.invoke(object, Long.parseLong(val));
                        break block31;
                    }
                    throw new IllegalArgumentException("setter must be String, int, float, double or boolean...for now");
                }
                throw new NoSuchMethodException("Couldn't find: " + (String)setter);
            }
            catch (Throwable ex) {
                String error = !(ex.getCause() instanceof IllegalArgumentException) ? String.format(Locale.ROOT, "%s is an invalid %s header", key, prefix) : String.format(Locale.ROOT, "%s is an invalid %s header value", val, key);
                throw new WebApplicationException(error, Response.Status.BAD_REQUEST);
            }
        }
    }

    private static void checkTrustWorthy(String setter, String val) {
        if (setter == null || val == null) {
            throw new IllegalArgumentException("setter and val must not be null");
        }
        if (setter.toLowerCase(Locale.US).contains("trusted")) {
            throw new IllegalArgumentException("Can't call a trusted method via tika-server headers");
        }
        Matcher m = ALLOWABLE_HEADER_CHARS.matcher(val);
        if (!m.find()) {
            throw new IllegalArgumentException("Header val: " + val + " contains illegal characters. Must contain: TikaResource.ALLOWABLE_HEADER_CHARS");
        }
    }

    private static Method tryToGetMethod(Object object, String method, Class clazz) {
        try {
            return object.getClass().getMethod(method, clazz);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static void fillMetadata(Parser parser, Metadata metadata, MultivaluedMap<String, String> httpHeaders) {
        String contentTypeHeader;
        MediaType mediaType;
        String fileName = TikaResource.detectFilename(httpHeaders);
        if (fileName != null) {
            metadata.set("resourceName", fileName);
        }
        MediaType mediaType2 = mediaType = (contentTypeHeader = httpHeaders.getFirst("Content-Type")) == null || "*/*".equals(contentTypeHeader) ? null : MediaType.valueOf(contentTypeHeader);
        if (mediaType != null && "xml".equals(mediaType.getSubtype())) {
            mediaType = null;
        }
        if (mediaType != null && mediaType.equals(MediaType.APPLICATION_OCTET_STREAM_TYPE)) {
            mediaType = null;
        }
        if (mediaType != null) {
            metadata.add("Content-Type", mediaType.toString());
            metadata.add(TikaCoreProperties.CONTENT_TYPE_USER_OVERRIDE, mediaType.toString());
        }
        if (httpHeaders.containsKey("Content-Length")) {
            metadata.set("Content-Length", httpHeaders.getFirst("Content-Length"));
        }
        for (Map.Entry e : httpHeaders.entrySet()) {
            if (!((String)e.getKey()).startsWith(META_PREFIX)) continue;
            String tikaKey = ((String)e.getKey()).substring(META_PREFIX.length());
            for (String value : (List)e.getValue()) {
                metadata.add(tikaKey, value);
            }
        }
    }

    public static void parse(Parser parser, Logger logger, String path, InputStream inputStream, ContentHandler handler, Metadata metadata, ParseContext parseContext) throws IOException {
        TikaResource.checkIsOperating();
        String fileName = metadata.get("resourceName");
        long timeoutMillis = TikaResource.getTaskTimeout(parseContext);
        long taskId = SERVER_STATUS.start(ServerStatus.TASK.PARSE, fileName, timeoutMillis);
        try {
            parser.parse(inputStream, handler, metadata, parseContext);
        }
        catch (SAXException e) {
            throw new TikaServerParseException(e);
        }
        catch (EncryptedDocumentException e) {
            logger.warn("{}: Encrypted document ({})", path, fileName, e);
            throw new TikaServerParseException(e);
        }
        catch (Exception e) {
            if (!WriteLimitReachedException.isWriteLimitReached(e)) {
                logger.warn("{}: Text extraction failed ({})", path, fileName, e);
            }
            throw new TikaServerParseException(e);
        }
        catch (OutOfMemoryError e) {
            logger.warn("{}: OOM ({})", path, fileName, e);
            SERVER_STATUS.setStatus(ServerStatus.STATUS.ERROR);
            throw e;
        }
        finally {
            SERVER_STATUS.complete(taskId);
            inputStream.close();
        }
    }

    protected static long getTaskTimeout(ParseContext parseContext) {
        TikaTaskTimeout tikaTaskTimeout = parseContext.get(TikaTaskTimeout.class);
        long timeoutMillis = TIKA_SERVER_CONFIG.getTaskTimeoutMillis();
        if (tikaTaskTimeout != null) {
            if (tikaTaskTimeout.getTimeoutMillis() > TIKA_SERVER_CONFIG.getTaskTimeoutMillis()) {
                throw new IllegalArgumentException("Can't request a timeout ( " + tikaTaskTimeout.getTimeoutMillis() + "ms) greater than the taskTimeoutMillis set in the server config (" + TIKA_SERVER_CONFIG.getTaskTimeoutMillis() + "ms)");
            }
            timeoutMillis = tikaTaskTimeout.getTimeoutMillis();
            if (timeoutMillis < TIKA_SERVER_CONFIG.getMinimumTimeoutMillis()) {
                throw new WebApplicationException((Throwable)new IllegalArgumentException("taskTimeoutMillis must be > minimumTimeoutMillis, currently set to (" + TIKA_SERVER_CONFIG.getMinimumTimeoutMillis() + "ms)"), Response.Status.BAD_REQUEST);
            }
        }
        return timeoutMillis;
    }

    public static void checkIsOperating() {
        if (!SERVER_STATUS.isOperating()) {
            throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    public static void logRequest(Logger logger, String endpoint, Metadata metadata) {
        if (metadata.get("Content-Type") == null) {
            logger.info("{} (autodetecting type)", (Object)endpoint);
        } else {
            logger.info("{} ({})", (Object)endpoint, (Object)metadata.get("Content-Type"));
        }
    }

    public static boolean getThrowOnWriteLimitReached(MultivaluedMap<String, String> httpHeaders) {
        if (httpHeaders.containsKey("throwOnWriteLimitReached")) {
            String val = httpHeaders.getFirst("throwOnWriteLimitReached");
            if ("true".equalsIgnoreCase(val)) {
                return true;
            }
            if ("false".equalsIgnoreCase(val)) {
                return false;
            }
            throw new IllegalArgumentException("'throwOnWriteLimitReached' must be either 'true' or 'false'");
        }
        return HandlerConfig.DEFAULT_HANDLER_CONFIG.isThrowOnWriteLimitReached();
    }

    @GET
    @Produces(value={"text/plain"})
    public String getMessage() {
        TikaResource.checkIsOperating();
        return GREETING;
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    @Path(value="form")
    public StreamingOutput getTextFromMultipart(Attachment att, @Context HttpHeaders httpHeaders, @Context UriInfo info) {
        return this.produceText(att.getObject(InputStream.class), new Metadata(), this.preparePostHeaderMap(att, httpHeaders), info);
    }

    @PUT
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    @Path(value="main")
    public StreamingOutput getTextMain(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info) {
        return this.produceTextMain(is, httpHeaders.getRequestHeaders(), info);
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    @Path(value="form/main")
    public StreamingOutput getTextMainFromMultipart(Attachment att, @Context HttpHeaders httpHeaders, @Context UriInfo info) {
        return this.produceTextMain(att.getObject(InputStream.class), this.preparePostHeaderMap(att, httpHeaders), info);
    }

    public StreamingOutput produceTextMain(InputStream is, MultivaluedMap<String, String> httpHeaders, UriInfo info) {
        Parser parser = TikaResource.createParser();
        Metadata metadata = new Metadata();
        ParseContext context = new ParseContext();
        TikaResource.fillMetadata(parser, metadata, httpHeaders);
        TikaResource.fillParseContext(httpHeaders, metadata, context);
        TikaResource.logRequest(LOG, "/tika", metadata);
        return outputStream -> {
            OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
            BoilerpipeContentHandler handler = new BoilerpipeContentHandler(writer);
            TikaResource.parse(parser, LOG, info.getPath(), is, handler, metadata, context);
        };
    }

    @PUT
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    public StreamingOutput getText(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info) {
        Metadata metadata = new Metadata();
        return this.produceText(TikaResource.getInputStream(is, metadata, httpHeaders, info), metadata, httpHeaders.getRequestHeaders(), info);
    }

    public StreamingOutput produceText(InputStream is, Metadata metadata, MultivaluedMap<String, String> httpHeaders, UriInfo info) {
        Parser parser = TikaResource.createParser();
        ParseContext context = new ParseContext();
        TikaResource.fillMetadata(parser, metadata, httpHeaders);
        TikaResource.fillParseContext(httpHeaders, metadata, context);
        TikaResource.logRequest(LOG, "/tika", metadata);
        return outputStream -> {
            OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
            BodyContentHandler body = new BodyContentHandler(new RichTextContentHandler(writer));
            TikaResource.parse(parser, LOG, info.getPath(), is, body, metadata, context);
        };
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/html"})
    @Path(value="form")
    public StreamingOutput getHTMLFromMultipart(Attachment att, @Context HttpHeaders httpHeaders, @Context UriInfo info) {
        return this.produceOutput(att.getObject(InputStream.class), new Metadata(), this.preparePostHeaderMap(att, httpHeaders), info, "html");
    }

    @PUT
    @Consumes(value={"*/*"})
    @Produces(value={"text/html"})
    public StreamingOutput getHTML(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info) {
        Metadata metadata = new Metadata();
        return this.produceOutput(TikaResource.getInputStream(is, metadata, httpHeaders, info), metadata, httpHeaders.getRequestHeaders(), info, "html");
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/xml"})
    @Path(value="form")
    public StreamingOutput getXMLFromMultipart(Attachment att, @Context HttpHeaders httpHeaders, @Context UriInfo info) {
        return this.produceOutput(att.getObject(InputStream.class), new Metadata(), this.preparePostHeaderMap(att, httpHeaders), info, "xml");
    }

    @PUT
    @Consumes(value={"*/*"})
    @Produces(value={"text/xml"})
    public StreamingOutput getXML(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info) {
        Metadata metadata = new Metadata();
        return this.produceOutput(TikaResource.getInputStream(is, metadata, httpHeaders, info), metadata, httpHeaders.getRequestHeaders(), info, "xml");
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @Path(value="form{handler : (\\w+)?}")
    public Metadata getJsonFromMultipart(Attachment att, @Context HttpHeaders httpHeaders, @Context UriInfo info, @PathParam(value="handler") String handlerTypeName) throws IOException, TikaException {
        Metadata metadata = new Metadata();
        this.parseToMetadata(TikaResource.getInputStream(att.getObject(InputStream.class), metadata, httpHeaders, info), metadata, this.preparePostHeaderMap(att, httpHeaders), info, handlerTypeName);
        TikaResource.getConfig().getMetadataFilter().filter(metadata);
        return metadata;
    }

    @PUT
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{handler : (\\w+)?}")
    public Metadata getJson(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info, @PathParam(value="handler") String handlerTypeName) throws IOException, TikaException {
        Metadata metadata = new Metadata();
        this.parseToMetadata(TikaResource.getInputStream(is, metadata, httpHeaders, info), metadata, httpHeaders.getRequestHeaders(), info, handlerTypeName);
        TikaResource.getConfig().getMetadataFilter().filter(metadata);
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseToMetadata(InputStream inputStream, Metadata metadata, MultivaluedMap<String, String> httpHeaders, UriInfo info, String handlerTypeName) throws IOException {
        block15: {
            Parser parser = TikaResource.createParser();
            ParseContext context = new ParseContext();
            TikaResource.fillMetadata(parser, metadata, httpHeaders);
            TikaResource.fillParseContext(httpHeaders, metadata, context);
            TikaResource.logRequest(LOG, "/tika", metadata);
            int writeLimit = -1;
            boolean throwOnWriteLimitReached = TikaResource.getThrowOnWriteLimitReached(httpHeaders);
            if (httpHeaders.containsKey("writeLimit")) {
                writeLimit = Integer.parseInt(httpHeaders.getFirst("writeLimit"));
            }
            BasicContentHandlerFactory.HANDLER_TYPE type = BasicContentHandlerFactory.parseHandlerType(handlerTypeName, RecursiveMetadataResource.DEFAULT_HANDLER_TYPE);
            BasicContentHandlerFactory fact = new BasicContentHandlerFactory(type, writeLimit, throwOnWriteLimitReached, context);
            ContentHandler contentHandler = fact.getNewContentHandler();
            try {
                TikaResource.parse(parser, LOG, info.getPath(), inputStream, contentHandler, metadata, context);
            }
            catch (TikaServerParseException e) {
                Throwable cause = e.getCause();
                boolean writeLimitReached = false;
                if (WriteLimitReachedException.isWriteLimitReached(cause)) {
                    metadata.set(TikaCoreProperties.WRITE_LIMIT_REACHED, "true");
                    writeLimitReached = true;
                }
                if (TIKA_SERVER_CONFIG.isReturnStackTrace()) {
                    if (cause != null) {
                        metadata.add(TikaCoreProperties.CONTAINER_EXCEPTION, ExceptionUtils.getStackTrace(cause));
                    } else {
                        metadata.add(TikaCoreProperties.CONTAINER_EXCEPTION, ExceptionUtils.getStackTrace(e));
                    }
                } else if (!writeLimitReached) {
                    throw e;
                }
            }
            catch (OutOfMemoryError e) {
                if (TIKA_SERVER_CONFIG.isReturnStackTrace()) {
                    metadata.add(TikaCoreProperties.CONTAINER_EXCEPTION, ExceptionUtils.getStackTrace(e));
                    break block15;
                }
                throw e;
            }
            finally {
                metadata.add(TikaCoreProperties.TIKA_CONTENT, contentHandler.toString());
            }
        }
    }

    private StreamingOutput produceOutput(InputStream is, Metadata metadata, MultivaluedMap<String, String> httpHeaders, UriInfo info, String format) {
        Parser parser = TikaResource.createParser();
        ParseContext context = new ParseContext();
        TikaResource.fillMetadata(parser, metadata, httpHeaders);
        TikaResource.fillParseContext(httpHeaders, metadata, context);
        TikaResource.logRequest(LOG, "/tika", metadata);
        return outputStream -> {
            ExpandedTitleContentHandler content;
            OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
            try {
                SAXTransformerFactory factory = XMLReaderUtils.getSAXTransformerFactory();
                TransformerHandler handler = factory.newTransformerHandler();
                handler.getTransformer().setOutputProperty("method", format);
                handler.getTransformer().setOutputProperty("indent", "yes");
                handler.getTransformer().setOutputProperty("encoding", StandardCharsets.UTF_8.name());
                handler.getTransformer().setOutputProperty("version", "1.1");
                handler.setResult(new StreamResult(writer));
                content = new ExpandedTitleContentHandler(handler);
            }
            catch (TransformerConfigurationException | TikaException e) {
                throw new WebApplicationException(e);
            }
            TikaResource.parse(parser, LOG, info.getPath(), is, content, metadata, context);
        };
    }

    private MetadataMap<String, String> preparePostHeaderMap(Attachment att, HttpHeaders httpHeaders) {
        if (att == null && httpHeaders == null) {
            return null;
        }
        MetadataMap<String, String> finalHeaders = new MetadataMap<String, String>(false, true);
        if (httpHeaders != null && httpHeaders.getRequestHeaders() != null) {
            finalHeaders.putAll((Map<String, List<String>>)httpHeaders.getRequestHeaders());
        }
        if (att != null && att.getHeaders() != null) {
            finalHeaders.putAll((Map<String, List<String>>)att.getHeaders());
        }
        return finalHeaders;
    }

    static {
        DIGESTER = null;
        INPUTSTREAM_FACTORY = null;
        SERVER_STATUS = null;
        PARSE_CONTEXT_CONFIG = new CompositeParseContextConfig();
    }
}

