/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core.resource;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MediaTypeRegistry;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.parser.CompositeParser;
import org.apache.tika.parser.Parser;
import org.apache.tika.server.core.HTMLHelper;
import org.apache.tika.server.core.resource.TikaResource;

@Path(value="/mime-types")
public class TikaMimeTypes {
    private HTMLHelper html = new HTMLHelper();

    private static String[] copyToStringArray(MediaType[] aliases) {
        String[] strings = new String[aliases.length];
        for (int i = 0; i < aliases.length; ++i) {
            strings[i] = aliases[i].toString();
        }
        return strings;
    }

    @GET
    @Produces(value={"text/html"})
    public String getMimeTypesHTML() {
        StringBuffer h = new StringBuffer();
        this.html.generateHeader(h, "Apache Tika Supported Mime Types");
        List<MediaTypeDetails> types = this.getMediaTypes();
        TreeMap<String, String> firstType = new TreeMap<String, String>();
        for (MediaTypeDetails type : types) {
            if (firstType.containsKey(type.type.getType())) continue;
            firstType.put(type.type.getType(), type.type.toString());
        }
        h.append("<ul>");
        for (String section : firstType.keySet()) {
            h.append("<li><a href=\"#").append((String)firstType.get(section)).append("\">").append(section).append("</a></li>\n");
        }
        h.append("</ul>");
        for (MediaTypeDetails type : types) {
            h.append("<a name=\"").append(type.type).append("\"></a>\n");
            h.append("<h2><a href=\"mime-types/").append(type.type).append("\">").append(type.type).append("</a></h2>\n");
            for (MediaType alias : type.aliases) {
                h.append("<div>Alias: ").append(alias).append("</div>\n");
            }
            if (type.supertype != null) {
                h.append("<div>Super Type: <a href=\"#").append(type.supertype).append("\">").append(type.supertype).append("</a></div>\n");
            }
            if (type.mime != null) {
                if (!type.mime.getDescription().isEmpty()) {
                    h.append("<div>Description: ").append(type.mime.getDescription()).append("</div>\n");
                }
                if (!type.mime.getAcronym().isEmpty()) {
                    h.append("<div>Acronym: ").append(type.mime.getAcronym()).append("</div>\n");
                }
                if (!type.mime.getExtension().isEmpty()) {
                    h.append("<div>Default Extension: ").append(type.mime.getExtension()).append("</div>\n");
                }
            }
            if (type.parser == null) continue;
            h.append("<div>Parser: ").append(type.parser).append("</div>\n");
        }
        this.html.generateFooter(h);
        return h.toString();
    }

    @GET
    @Path(value="/{type}/{subtype}")
    @Produces(value={"text/html"})
    public String getMimeTypeDetailsHTML(@PathParam(value="type") String typePart, @PathParam(value="subtype") String subtype) {
        MediaTypeDetails type = this.getMediaType(typePart, subtype);
        StringBuffer h = new StringBuffer();
        this.html.generateHeader(h, "Apache Tika Details on Mime Type " + String.valueOf(type.type));
        h.append("<h2>").append(type.type).append("</h2>\n");
        for (MediaType alias : type.aliases) {
            h.append("<div>Alias: ").append(alias).append("</div>\n");
        }
        if (type.supertype != null) {
            h.append("<div>Super Type: <a href=\"#").append(type.supertype).append("\">").append(type.supertype).append("</a></div>\n");
        }
        if (type.mime != null) {
            if (!type.mime.getDescription().isEmpty()) {
                h.append("<div>Description: ").append(type.mime.getDescription()).append("</div>\n");
            }
            if (!type.mime.getAcronym().isEmpty()) {
                h.append("<div>Acronym: ").append(type.mime.getAcronym()).append("</div>\n");
            }
            if (!type.mime.getUniformTypeIdentifier().isEmpty()) {
                h.append("<div>Uniform Type Identifier: ").append(type.mime.getUniformTypeIdentifier()).append("</div>\n");
            }
            for (URI uri : type.mime.getLinks()) {
                h.append("<div>Link: ").append(uri).append("</div>\n");
            }
            if (!type.mime.getExtension().isEmpty()) {
                h.append("<div>Default Extension: ").append(type.mime.getExtension()).append("</div>\n");
            }
            for (String ext : type.mime.getExtensions()) {
                h.append("<div>Extension: ").append(ext).append("</div>\n");
            }
        }
        if (type.parser != null) {
            h.append("<div>Parser: ").append(type.parser).append("</div>\n");
        }
        this.html.generateFooter(h);
        return h.toString();
    }

    @GET
    @Produces(value={"application/json"})
    public String getMimeTypesJSON() throws IOException {
        HashMap details = new HashMap();
        for (MediaTypeDetails type : this.getMediaTypes()) {
            HashMap<String, Object> typeDets = new HashMap<String, Object>();
            typeDets.put("alias", TikaMimeTypes.copyToStringArray(type.aliases));
            if (type.supertype != null) {
                typeDets.put("supertype", type.supertype.toString());
            }
            if (type.parser != null) {
                typeDets.put("parser", type.parser);
            }
            details.put(type.type.toString(), typeDets);
        }
        return new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(details);
    }

    @GET
    @Path(value="/{type}/{subtype}")
    @Produces(value={"application/json"})
    public String getMimeTypeDetailsJSON(@PathParam(value="type") String typePart, @PathParam(value="subtype") String subtype) throws IOException {
        MediaTypeDetails type = this.getMediaType(typePart, subtype);
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("type", type.type.toString());
        details.put("alias", TikaMimeTypes.copyToStringArray(type.aliases));
        if (type.supertype != null) {
            details.put("supertype", type.supertype.toString());
        }
        if (type.parser != null) {
            details.put("parser", type.parser);
        }
        if (type.mime != null) {
            if (!type.mime.getDescription().isEmpty()) {
                details.put("description", type.mime.getDescription());
            }
            if (!type.mime.getAcronym().isEmpty()) {
                details.put("acronym", type.mime.getAcronym());
            }
            if (!type.mime.getUniformTypeIdentifier().isEmpty()) {
                details.put("uniformTypeIdentifier", type.mime.getUniformTypeIdentifier());
            }
            if (!type.mime.getLinks().isEmpty()) {
                details.put("links", type.mime.getLinks());
            }
            if (!type.mime.getExtension().isEmpty()) {
                details.put("defaultExtension", type.mime.getExtension());
            }
            if (!type.mime.getExtensions().isEmpty()) {
                details.put("extensions", type.mime.getExtensions());
            }
        }
        return new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(details);
    }

    @GET
    @Produces(value={"text/plain"})
    public String getMimeTypesPlain() {
        StringBuilder text = new StringBuilder();
        for (MediaTypeDetails type : this.getMediaTypes()) {
            text.append(type.type.toString());
            text.append("\n");
            for (MediaType alias : type.aliases) {
                text.append("  alias:     ").append(alias).append("\n");
            }
            if (type.supertype != null) {
                text.append("  supertype: ").append(type.supertype.toString()).append("\n");
            }
            if (type.parser == null) continue;
            text.append("  parser:    ").append(type.parser).append("\n");
        }
        return text.toString();
    }

    protected MediaTypeDetails getMediaType(String type, String subtype) throws NotFoundException {
        MediaType mt = MediaType.parse(type + "/" + subtype);
        for (MediaTypeDetails mtd : this.getMediaTypes()) {
            if (!mtd.type.equals(mt)) continue;
            return mtd;
        }
        throw new NotFoundException("No Media Type registered in Tika for " + String.valueOf(mt));
    }

    protected List<MediaTypeDetails> getMediaTypes() {
        TikaConfig config = TikaResource.getConfig();
        MimeTypes mimeTypes = config.getMimeRepository();
        MediaTypeRegistry registry = config.getMediaTypeRegistry();
        Map<MediaType, Parser> parsers = ((CompositeParser)config.getParser()).getParsers();
        ArrayList<MediaTypeDetails> types = new ArrayList<MediaTypeDetails>(registry.getTypes().size());
        for (MediaType type : registry.getTypes()) {
            Parser p;
            MediaTypeDetails details = new MediaTypeDetails();
            details.type = type;
            details.aliases = registry.getAliases(type).toArray(new MediaType[0]);
            try {
                details.mime = mimeTypes.getRegisteredMimeType(type.toString());
            }
            catch (MimeTypeException mimeTypeException) {
                // empty catch block
            }
            MediaType supertype = registry.getSupertype(type);
            if (supertype != null && !MediaType.OCTET_STREAM.equals(supertype)) {
                details.supertype = supertype;
            }
            if ((p = parsers.get(type)) != null) {
                if (p instanceof CompositeParser) {
                    p = ((CompositeParser)p).getParsers().get(type);
                }
                details.parser = p.getClass().getName();
            }
            types.add(details);
        }
        return types;
    }

    private static class MediaTypeDetails {
        private MediaType type;
        private MediaType[] aliases;
        private MediaType supertype;
        private MimeType mime;
        private String parser;

        private MediaTypeDetails() {
        }
    }
}

