/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core.resource;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.InputStream;
import java.util.List;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.listfilter.MetadataListFilter;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.RecursiveParserWrapper;
import org.apache.tika.pipes.HandlerConfig;
import org.apache.tika.sax.BasicContentHandlerFactory;
import org.apache.tika.sax.RecursiveParserWrapperHandler;
import org.apache.tika.server.core.MetadataList;
import org.apache.tika.server.core.TikaServerParseException;
import org.apache.tika.server.core.resource.TikaResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/rmeta")
public class RecursiveMetadataResource {
    protected static final String HANDLER_TYPE_PARAM = "handler";
    protected static final BasicContentHandlerFactory.HANDLER_TYPE DEFAULT_HANDLER_TYPE = BasicContentHandlerFactory.HANDLER_TYPE.XML;
    private static final Logger LOG = LoggerFactory.getLogger(RecursiveMetadataResource.class);

    public static List<Metadata> parseMetadata(InputStream is, Metadata metadata, MultivaluedMap<String, String> httpHeaders, UriInfo info, HandlerConfig handlerConfig) throws Exception {
        ParseContext context = new ParseContext();
        Parser parser = TikaResource.createParser();
        RecursiveParserWrapper wrapper = new RecursiveParserWrapper(parser);
        TikaResource.fillMetadata(parser, metadata, httpHeaders);
        TikaResource.fillParseContext(httpHeaders, metadata, context);
        TikaResource.logRequest(LOG, "/rmeta", metadata);
        BasicContentHandlerFactory.HANDLER_TYPE type = handlerConfig.getType();
        RecursiveParserWrapperHandler handler = new RecursiveParserWrapperHandler(new BasicContentHandlerFactory(type, handlerConfig.getWriteLimit(), handlerConfig.isThrowOnWriteLimitReached(), context), handlerConfig.getMaxEmbeddedResources(), TikaResource.getConfig().getMetadataFilter());
        try {
            TikaResource.parse(wrapper, LOG, "/rmeta", is, handler, metadata, context);
        }
        catch (TikaServerParseException e) {
            LOG.debug("server parse exception", e);
        }
        catch (WebApplicationException | SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("something went seriously wrong", e);
        }
        MetadataListFilter metadataListFilter = context.get(MetadataListFilter.class, TikaResource.getConfig().getMetadataListFilter());
        return metadataListFilter.filter(handler.getMetadataList());
    }

    static HandlerConfig buildHandlerConfig(MultivaluedMap<String, String> httpHeaders, String handlerTypeName, HandlerConfig.PARSE_MODE parseMode) {
        int writeLimit = -1;
        if (httpHeaders.containsKey("writeLimit")) {
            writeLimit = Integer.parseInt(httpHeaders.getFirst("writeLimit"));
        }
        int maxEmbeddedResources = -1;
        if (httpHeaders.containsKey("maxEmbeddedResources")) {
            maxEmbeddedResources = Integer.parseInt(httpHeaders.getFirst("maxEmbeddedResources"));
        }
        return new HandlerConfig(BasicContentHandlerFactory.parseHandlerType(handlerTypeName, DEFAULT_HANDLER_TYPE), parseMode, writeLimit, maxEmbeddedResources, TikaResource.getThrowOnWriteLimitReached(httpHeaders));
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @Path(value="form{handler : (\\w+)?}")
    public Response getMetadataFromMultipart(Attachment att, @Context UriInfo info, @PathParam(value="handler") String handlerTypeName) throws Exception {
        return Response.ok(this.parseMetadataToMetadataList(att.getObject(InputStream.class), new Metadata(), att.getHeaders(), info, RecursiveMetadataResource.buildHandlerConfig(att.getHeaders(), handlerTypeName, HandlerConfig.PARSE_MODE.RMETA))).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="{handler : (\\w+)?}")
    public Response getMetadata(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info, @PathParam(value="handler") String handlerTypeName) throws Exception {
        Metadata metadata = new Metadata();
        return Response.ok(this.parseMetadataToMetadataList(TikaResource.getInputStream(is, metadata, httpHeaders, info), metadata, httpHeaders.getRequestHeaders(), info, RecursiveMetadataResource.buildHandlerConfig(httpHeaders.getRequestHeaders(), handlerTypeName, HandlerConfig.PARSE_MODE.RMETA))).build();
    }

    private MetadataList parseMetadataToMetadataList(InputStream is, Metadata metadata, MultivaluedMap<String, String> httpHeaders, UriInfo info, HandlerConfig handlerConfig) throws Exception {
        return new MetadataList(RecursiveMetadataResource.parseMetadata(is, metadata, httpHeaders, info, handlerConfig));
    }
}

