/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core.resource;

import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.pipes.FetchEmitTuple;
import org.apache.tika.pipes.PipesConfig;
import org.apache.tika.pipes.PipesException;
import org.apache.tika.pipes.PipesParser;
import org.apache.tika.pipes.PipesResult;
import org.apache.tika.serialization.pipes.JsonFetchEmitTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/pipes")
public class PipesResource {
    private static final Logger LOG = LoggerFactory.getLogger(PipesResource.class);
    private final PipesParser pipesParser;

    public PipesResource(java.nio.file.Path tikaConfig) throws TikaConfigException, IOException {
        PipesConfig pipesConfig = PipesConfig.load(tikaConfig);
        long maxEmit = pipesConfig.getMaxForEmitBatchBytes();
        if (maxEmit != 0L) {
            pipesConfig.setMaxForEmitBatchBytes(0L);
            if (maxEmit != 100000L) {
                LOG.warn("resetting max for emit batch to 0");
            }
        }
        this.pipesParser = new PipesParser(pipesConfig);
    }

    @POST
    @Produces(value={"application/json"})
    public Map<String, String> postRmeta(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info) throws Exception {
        FetchEmitTuple t = null;
        try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
            t = JsonFetchEmitTuple.fromJson(reader);
        }
        return this.processTuple(t);
    }

    private Map<String, String> processTuple(FetchEmitTuple fetchEmitTuple) throws InterruptedException, PipesException, IOException {
        PipesResult pipesResult = this.pipesParser.parse(fetchEmitTuple);
        switch (pipesResult.getStatus()) {
            case CLIENT_UNAVAILABLE_WITHIN_MS: {
                throw new IllegalStateException("client not available within allotted amount of time");
            }
            case EMIT_EXCEPTION: {
                return this.returnEmitException(pipesResult.getMessage());
            }
            case PARSE_SUCCESS: 
            case PARSE_SUCCESS_WITH_EXCEPTION: {
                throw new IllegalArgumentException("Should have emitted in forked process?!");
            }
            case EMIT_SUCCESS: {
                return this.returnSuccess();
            }
            case EMIT_SUCCESS_PARSE_EXCEPTION: {
                return this.parseException(pipesResult.getMessage(), true);
            }
            case PARSE_EXCEPTION_EMIT: {
                throw new IllegalArgumentException("Should have tried to emit in forked process?!");
            }
            case PARSE_EXCEPTION_NO_EMIT: {
                return this.parseException(pipesResult.getMessage(), false);
            }
            case TIMEOUT: {
                return this.returnError("timeout");
            }
            case OOM: {
                return this.returnError("oom");
            }
            case UNSPECIFIED_CRASH: {
                return this.returnError("unknown_crash");
            }
            case NO_EMITTER_FOUND: {
                throw new IllegalArgumentException("Couldn't find emitter that matched: " + fetchEmitTuple.getEmitKey().getEmitterName());
            }
        }
        throw new IllegalArgumentException("I'm sorry, I don't yet handle a status of this type: " + String.valueOf((Object)pipesResult.getStatus()));
    }

    private Map<String, String> parseException(String msg, boolean emitted) {
        HashMap<String, String> statusMap = new HashMap<String, String>();
        statusMap.put("status", "ok");
        statusMap.put("parse_exception", msg);
        statusMap.put("emitted", Boolean.toString(emitted));
        return statusMap;
    }

    private Map<String, String> returnEmitException(String msg) {
        HashMap<String, String> statusMap = new HashMap<String, String>();
        statusMap.put("status", "emit_exception");
        statusMap.put("message", msg);
        return statusMap;
    }

    private Map<String, String> returnSuccess() {
        HashMap<String, String> statusMap = new HashMap<String, String>();
        statusMap.put("status", "ok");
        return statusMap;
    }

    private Map<String, String> returnError(String type) {
        HashMap<String, String> statusMap = new HashMap<String, String>();
        statusMap.put("status", "parse_error");
        statusMap.put("parse_error", type);
        return statusMap;
    }

    public void close() throws IOException {
        this.pipesParser.close();
    }
}

