/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core.resource;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.io.InputStream;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.tika.extractor.DocumentSelector;
import org.apache.tika.language.detect.LanguageHandler;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.server.core.resource.TikaResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/meta")
public class MetadataResource {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataResource.class);

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/csv", "application/json"})
    @Path(value="form")
    public Response getMetadataFromMultipart(Attachment att, @Context UriInfo info) throws Exception {
        return Response.ok(this.parseMetadata(att.getObject(InputStream.class), new Metadata(), att.getHeaders(), info)).build();
    }

    @PUT
    @Produces(value={"text/csv", "application/json"})
    public Response getMetadata(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info) throws Exception {
        Metadata metadata = new Metadata();
        return Response.ok(this.parseMetadata(TikaResource.getInputStream(is, metadata, httpHeaders, info), metadata, httpHeaders.getRequestHeaders(), info)).build();
    }

    @PUT
    @Path(value="{field}")
    @Produces(value={"text/csv", "application/json", "text/plain"})
    public Response getMetadataField(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info, @PathParam(value="field") String field) throws Exception {
        Response.Status defaultErrorResponse = Response.Status.BAD_REQUEST;
        Metadata metadata = new Metadata();
        boolean success = false;
        try {
            this.parseMetadata(TikaResource.getInputStream(is, metadata, httpHeaders, info), metadata, httpHeaders.getRequestHeaders(), info);
            defaultErrorResponse = Response.Status.NOT_FOUND;
            success = true;
        }
        catch (Exception e) {
            LOG.info("Failed to process field {}", (Object)field, (Object)e);
        }
        if (!success || metadata.get(field) == null) {
            return Response.status(defaultErrorResponse).entity("Failed to get metadata field " + field).build();
        }
        for (String name : metadata.names()) {
            if (field.equals(name)) continue;
            metadata.remove(name);
        }
        return Response.ok(metadata).build();
    }

    protected Metadata parseMetadata(InputStream is, final Metadata metadata, MultivaluedMap<String, String> httpHeaders, UriInfo info) throws IOException {
        ParseContext context = new ParseContext();
        Parser parser = TikaResource.createParser();
        TikaResource.fillMetadata(parser, metadata, httpHeaders);
        TikaResource.fillParseContext(httpHeaders, metadata, context);
        context.set(DocumentSelector.class, metadata1 -> false);
        TikaResource.logRequest(LOG, "/meta", metadata);
        TikaResource.parse(parser, LOG, info.getPath(), is, new LanguageHandler(){

            @Override
            public void endDocument() {
                metadata.set("language", this.getLanguage().getLanguage());
            }
        }, metadata, context);
        return metadata;
    }
}

