/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core.resource;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.server.core.ServerStatus;
import org.apache.tika.server.core.resource.TikaResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/detect")
public class DetectorResource {
    private static final Logger LOG = LoggerFactory.getLogger(DetectorResource.class);
    private final ServerStatus serverStatus;

    public DetectorResource(ServerStatus serverStatus) {
        this.serverStatus = serverStatus;
    }

    @PUT
    @Path(value="stream")
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    public String detect(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info) {
        Metadata met = new Metadata();
        String filename = TikaResource.detectFilename(httpHeaders.getRequestHeaders());
        LOG.info("Detecting media type for Filename: {}", (Object)filename);
        met.add("resourceName", filename);
        ParseContext parseContext = new ParseContext();
        TikaResource.fillParseContext(httpHeaders.getRequestHeaders(), met, parseContext);
        long timeoutMillis = TikaResource.getTaskTimeout(parseContext);
        long taskId = this.serverStatus.start(ServerStatus.TASK.DETECT, filename, timeoutMillis);
        try {
            String string;
            block14: {
                TikaInputStream tis = TikaInputStream.get(TikaResource.getInputStream(is, met, httpHeaders, info));
                try {
                    string = TikaResource.getConfig().getDetector().detect(tis, met).toString();
                    if (tis == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (tis != null) {
                            try {
                                tis.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        LOG.warn("Unable to detect MIME type for file. Reason: {} ({})", e.getMessage(), filename, e);
                        String string2 = MediaType.OCTET_STREAM.toString();
                        return string2;
                    }
                    catch (OutOfMemoryError e) {
                        LOG.error("OOM while detecting: ({})", (Object)filename, (Object)e);
                        this.serverStatus.setStatus(ServerStatus.STATUS.ERROR);
                        throw e;
                    }
                    catch (Throwable e) {
                        LOG.error("Exception while detecting: ({})", (Object)filename, (Object)e);
                        throw e;
                    }
                }
                tis.close();
            }
            return string;
        }
        finally {
            this.serverStatus.complete(taskId);
        }
    }
}

