/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core.config;

import jakarta.ws.rs.core.MultivaluedMap;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.PasswordProvider;
import org.apache.tika.server.core.ParseContextConfig;

public class PasswordProviderConfig
implements ParseContextConfig {
    public static final String PASSWORD = "Password";
    public static final String PASSWORD_BASE64_UTF8 = "Password_Base64_UTF-8";
    private static final Base64 BASE_64 = new Base64();

    private static String decodeBase64UTF8(String s) {
        byte[] bytes = BASE_64.decode(s);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    @Override
    public void configure(MultivaluedMap<String, String> httpHeaders, Metadata metadata, ParseContext context) {
        String tmpPassword = httpHeaders.getFirst(PASSWORD_BASE64_UTF8);
        tmpPassword = tmpPassword != null ? PasswordProviderConfig.decodeBase64UTF8(tmpPassword) : httpHeaders.getFirst(PASSWORD);
        if (tmpPassword != null) {
            String password = tmpPassword;
            context.set(PasswordProvider.class, metadata1 -> password);
        }
    }
}

