/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core.config;

import jakarta.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang3.Strings;
import org.apache.tika.extractor.DocumentSelector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.server.core.ParseContextConfig;

public class DocumentSelectorConfig
implements ParseContextConfig {
    public static final String X_TIKA_SKIP_EMBEDDED_HEADER = "X-Tika-Skip-Embedded";

    @Override
    public void configure(MultivaluedMap<String, String> httpHeaders, Metadata mtadata, ParseContext context) {
        DocumentSelector documentSelector = null;
        for (String key : httpHeaders.keySet()) {
            String skipEmbedded;
            if (!Strings.CS.endsWith(key, X_TIKA_SKIP_EMBEDDED_HEADER) || !Boolean.parseBoolean(skipEmbedded = httpHeaders.getFirst(key))) continue;
            documentSelector = metadata -> false;
        }
        if (documentSelector != null) {
            context.set(DocumentSelector.class, documentSelector);
        }
    }
}

