/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core;

import java.util.Map;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.utils.StringUtils;

public class TlsConfig
implements Initializable {
    private final boolean passwordsAESEncrypted = false;
    private boolean active = false;
    private String keyStoreType = null;
    private String keyStorePassword = null;
    private String keyStoreFile = null;
    private String trustStoreType = null;
    private String trustStorePassword = null;
    private String trustStoreFile = null;
    private boolean clientAuthenticationWanted = false;
    private boolean clientAuthenticationRequired = false;

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isPasswordsAESEncrypted() {
        return false;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public String getTrustStoreFile() {
        return this.trustStoreFile;
    }

    public void setTrustStoreFile(String trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
    }

    @Override
    public void initialize(Map<String, Param> params) throws TikaConfigException {
    }

    @Override
    public void checkInitialization(InitializableProblemHandler problemHandler) throws TikaConfigException {
        if (this.active) {
            if (StringUtils.isBlank(this.keyStoreType)) {
                throw new TikaConfigException("must initialize keyStoreType");
            }
            if (StringUtils.isBlank(this.keyStoreFile)) {
                throw new TikaConfigException("must initialize keyStoreFile");
            }
            if (StringUtils.isBlank(this.keyStorePassword)) {
                throw new TikaConfigException("must initialize keyStorePassword");
            }
            if (this.hasTrustStore()) {
                if (StringUtils.isBlank(this.trustStoreType)) {
                    throw new TikaConfigException("must initialize trustStoreType if there's any trustStore info");
                }
                if (StringUtils.isBlank(this.trustStoreFile)) {
                    throw new TikaConfigException("must initialize trustStoreFile if there's any trustStore info");
                }
                if (StringUtils.isBlank(this.trustStorePassword)) {
                    throw new TikaConfigException("must initialize trustStorePassword if there's any trustStore info");
                }
            }
            if (!this.hasTrustStore() && this.isClientAuthenticationRequired()) {
                throw new TikaConfigException("requiring client authentication, but no trust store has been specified?!");
            }
        }
    }

    public boolean isClientAuthenticationWanted() {
        return this.clientAuthenticationWanted;
    }

    public void setClientAuthenticationWanted(boolean clientAuthenticationWanted) {
        this.clientAuthenticationWanted = clientAuthenticationWanted;
    }

    public boolean isClientAuthenticationRequired() {
        return this.clientAuthenticationRequired;
    }

    public void setClientAuthenticationRequired(boolean clientAuthenticationRequired) {
        this.clientAuthenticationRequired = clientAuthenticationRequired;
    }

    public String toString() {
        return "TlsConfig{active=" + this.active + ", passwordsAESEncrypted=false, keyStoreType='" + this.keyStoreType + "', keyStorePassword='" + this.keyStorePassword + "', keyStoreFile='" + this.keyStoreFile + "', trustStoreType='" + this.trustStoreType + "', trustStorePassword='" + this.trustStorePassword + "', trustStoreFile='" + this.trustStoreFile + "', clientAuthenticationWanted=" + this.clientAuthenticationWanted + ", isClientAuthenticationRequired=" + this.clientAuthenticationRequired + "}";
    }

    public boolean hasTrustStore() {
        return !StringUtils.isBlank(this.trustStoreType) && !StringUtils.isBlank(this.trustStorePassword) && !StringUtils.isBlank(this.trustStoreFile);
    }
}

