/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.BindException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.tika.exception.TikaException;
import org.apache.tika.server.core.TikaServerCli;
import org.apache.tika.server.core.TikaServerConfig;
import org.apache.tika.server.core.TikaServerProcess;
import org.apache.tika.server.core.WatchDogResult;
import org.apache.tika.utils.ProcessUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TikaServerWatchDog
implements Callable<WatchDogResult> {
    private static final Logger LOG = LoggerFactory.getLogger(TikaServerWatchDog.class);
    private static Set<Process> PROCESSES = ConcurrentHashMap.newKeySet();
    private static Set<ForkedProcess> FORKED_PROCESSES = ConcurrentHashMap.newKeySet();
    private final int port;
    private final String id;
    private final TikaServerConfig tikaServerConfig;
    private final Object[] forkedStatusLock = new Object[0];
    private volatile FORKED_STATUS forkedStatus = FORKED_STATUS.INITIALIZING;
    private volatile Instant lastPing = null;
    private ForkedProcess forkedProcess = null;
    private int restarts = 0;
    private volatile boolean shutDown = false;

    TikaServerWatchDog(int port, String id, TikaServerConfig tikaServerConfig) {
        this.port = port;
        this.id = id;
        this.tikaServerConfig = tikaServerConfig;
    }

    private static void redirectIO(InputStream src, PrintStream targ) {
        Thread gobbler = new Thread(() -> {
            BufferedReader reader = new BufferedReader(new InputStreamReader(src, StandardCharsets.UTF_8));
            try {
                String line = reader.readLine();
                while (line != null) {
                    targ.println(line);
                    line = reader.readLine();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        gobbler.setDaemon(true);
        gobbler.start();
    }

    private static synchronized void destroyForkedForcibly(Process process) throws InterruptedException {
        process = process.destroyForcibly();
        try {
            boolean destroyed = process.waitFor(60L, TimeUnit.SECONDS);
            if (!destroyed) {
                LOG.error("Forked process still alive after 60 seconds. Shutting down the forking process.");
                System.exit(1);
            }
        }
        finally {
            PROCESSES.remove(process);
        }
    }

    private static void closeForkedProcess(ForkedProcess forkedProcess) throws DoNotRestartException, InterruptedException {
        try {
            forkedProcess.close();
        }
        finally {
            FORKED_PROCESSES.remove(forkedProcess);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public WatchDogResult call() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized void close() throws DoNotRestartException, InterruptedException {
        this.setForkedStatus(FORKED_STATUS.SHUTTING_DOWN);
        LOG.debug("received 'close()'; about to shutdown");
        this.shutDown();
        TikaServerWatchDog.closeForkedProcess(this.forkedProcess);
    }

    private synchronized ForkedProcess startForkedProcess(int restarts) throws Exception {
        LOG.debug("attempting to start forked process on {} restarts", (Object)restarts);
        int consecutiveRestarts = 0;
        int maxBind = 30;
        while (consecutiveRestarts < maxBind && !this.shutDown) {
            try {
                ForkedProcess forkedProcess = new ForkedProcess(restarts);
                FORKED_PROCESSES.add(forkedProcess);
                return forkedProcess;
            }
            catch (BindException e) {
                LOG.warn("WatchDog observes bind exception on retry {}. Will retry {} times.", (Object)consecutiveRestarts, (Object)maxBind);
                Thread.sleep(1000L);
                if (++consecutiveRestarts < maxBind) continue;
                throw e;
            }
        }
        if (this.shutDown) {
            return null;
        }
        throw new RuntimeException("Couldn't start forked process");
    }

    public void shutDown() {
        this.shutDown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setForkedStatus(FORKED_STATUS status) {
        Object[] objectArray = this.forkedStatusLock;
        synchronized (this.forkedStatusLock) {
            this.forkedStatus = status;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static {
        Thread shutdownHook = new Thread(() -> {
            for (Process process : PROCESSES) {
                process.destroyForcibly();
            }
            for (ForkedProcess forkedProcess : FORKED_PROCESSES) {
                try {
                    forkedProcess.close();
                }
                catch (InterruptedException | DoNotRestartException exception) {}
            }
        });
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    private class ForkedProcess {
        private final Process process;
        private final Path forkedStatusFile;
        private final ByteBuffer statusBuffer = ByteBuffer.allocate(16);

        private ForkedProcess(int numRestarts) throws Exception {
            String prefix = TikaServerWatchDog.this.tikaServerConfig.getTempFilePrefix();
            this.forkedStatusFile = Files.createTempFile(prefix, "", new FileAttribute[0]);
            this.process = this.startProcess(numRestarts, this.forkedStatusFile);
            Instant start = Instant.now();
            long elapsed = Duration.between(start, Instant.now()).toMillis();
            try {
                while (this.process.isAlive() && Files.size(this.forkedStatusFile) < 12L && elapsed < TikaServerWatchDog.this.tikaServerConfig.getMaxForkedStartupMillis()) {
                    Thread.sleep(50L);
                    elapsed = Duration.between(start, Instant.now()).toMillis();
                }
            }
            catch (IOException e) {
                LOG.warn("failed to start forked process", e);
            }
            if (elapsed > TikaServerWatchDog.this.tikaServerConfig.getMaxForkedStartupMillis()) {
                this.close();
                throw new RuntimeException("Forked process failed to start after " + elapsed + " (ms)");
            }
            if (!this.process.isAlive()) {
                this.close();
                if (this.process.exitValue() == 42) {
                    throw new BindException("couldn't bind");
                }
                throw new RuntimeException("Failed to start forked process -- forked is not alive");
            }
            if (!Files.exists(this.forkedStatusFile, new LinkOption[0])) {
                this.close();
                throw new RuntimeException("Failed to start forked process -- forked status file does not exist");
            }
            TikaServerWatchDog.this.lastPing = Instant.now();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private ForkedStatus readStatus() throws Exception {
            Instant started = Instant.now();
            long elapsed = Duration.between(started, Instant.now()).toMillis();
            try (FileChannel fc = FileChannel.open(this.forkedStatusFile, StandardOpenOption.READ, StandardOpenOption.WRITE);){
                while (elapsed < TikaServerWatchDog.this.tikaServerConfig.getTaskTimeoutMillis()) {
                    try {
                        FileLock lock;
                        block16: {
                            ForkedStatus forkedStatus;
                            lock = fc.tryLock(0L, 16L, true);
                            try {
                                if (lock == null) break block16;
                                ((Buffer)this.statusBuffer).position(0);
                                fc.read(this.statusBuffer);
                                long timestamp = this.statusBuffer.getLong(0);
                                int status = this.statusBuffer.getInt(8);
                                int numTasks = this.statusBuffer.getInt(12);
                                forkedStatus = new ForkedStatus(timestamp, status, numTasks);
                                if (lock == null) return forkedStatus;
                            }
                            catch (Throwable throwable) {
                                if (lock == null) throw throwable;
                                try {
                                    lock.close();
                                    throw throwable;
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            lock.close();
                            return forkedStatus;
                        }
                        if (lock != null) {
                            lock.close();
                        }
                    }
                    catch (OverlappingFileLockException overlappingFileLockException) {
                        // empty catch block
                    }
                    Thread.sleep(100L);
                    elapsed = Duration.between(started, Instant.now()).toMillis();
                }
                return new ForkedStatus(-1L, FORKED_STATUS.FAILED_COMMUNICATION.ordinal(), -1);
            }
        }

        private void close() throws DoNotRestartException, InterruptedException {
            try {
                if (!this.process.isAlive()) {
                    try {
                        int exit = this.process.exitValue();
                        if (exit == TikaServerProcess.DO_NOT_RESTART_EXIT_VALUE) {
                            throw new DoNotRestartException("Forked exited with: " + exit);
                        }
                    }
                    catch (IllegalThreadStateException exit) {
                        // empty catch block
                    }
                }
                TikaServerWatchDog.destroyForkedForcibly(this.process);
            }
            finally {
                if (this.forkedStatusFile != null) {
                    try {
                        if (Files.isRegularFile(this.forkedStatusFile, new LinkOption[0])) {
                            Files.delete(this.forkedStatusFile);
                        }
                        LOG.debug("deleted " + String.valueOf(this.forkedStatusFile));
                    }
                    catch (IOException e) {
                        LOG.warn("problem deleting forked process status file", e);
                    }
                }
            }
        }

        private Process startProcess(int numRestarts, Path forkedStatusFile) throws IOException {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.redirectError(ProcessBuilder.Redirect.INHERIT);
            ArrayList<String> argList = new ArrayList<String>();
            String javaPath = TikaServerWatchDog.this.tikaServerConfig.getJavaPath();
            List<String> jvmArgs = TikaServerWatchDog.this.tikaServerConfig.getForkedJvmArgs();
            List<String> forkedArgs = TikaServerWatchDog.this.tikaServerConfig.getForkedProcessArgs(TikaServerWatchDog.this.port, TikaServerWatchDog.this.id);
            forkedArgs.add("-forkedStatusFile");
            forkedArgs.add(ProcessUtils.escapeCommandLine(forkedStatusFile.toAbsolutePath().toString()));
            argList.add(javaPath);
            if (!jvmArgs.contains("-cp") && !jvmArgs.contains("--classpath")) {
                String cp = System.getProperty("java.class.path");
                jvmArgs.add("-cp");
                jvmArgs.add(cp);
            }
            jvmArgs.add("-Dtika.server.id=" + TikaServerWatchDog.this.tikaServerConfig.getId());
            argList.addAll(jvmArgs);
            argList.add("org.apache.tika.server.core.TikaServerProcess");
            argList.addAll(forkedArgs);
            argList.add("-numRestarts");
            argList.add(Integer.toString(numRestarts));
            LOG.debug("forked process commandline: " + ((Object)argList).toString());
            builder.command(argList);
            builder.environment().put(TikaServerCli.TIKA_SERVER_ID_ENV, TikaServerWatchDog.this.id);
            Process process = builder.start();
            PROCESSES.add(process);
            TikaServerWatchDog.redirectIO(process.getInputStream(), System.err);
            TikaServerWatchDog.redirectIO(process.getErrorStream(), System.err);
            return process;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ForkedProcess that = (ForkedProcess)o;
            if (!this.process.equals(that.process)) {
                return false;
            }
            if (!this.forkedStatusFile.equals(that.forkedStatusFile)) {
                return false;
            }
            return this.statusBuffer.equals(that.statusBuffer);
        }

        public int hashCode() {
            int result = this.process.hashCode();
            result = 31 * result + this.forkedStatusFile.hashCode();
            result = 31 * result + this.statusBuffer.hashCode();
            return result;
        }
    }

    private static class DoNotRestartException
    extends TikaException {
        public DoNotRestartException(String msg) {
            super(msg);
        }

        public DoNotRestartException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    private static class ForkedStatus {
        private final long timestamp;
        private final int status;
        private final int numTasks;

        public ForkedStatus(long timestamp, int status, int numTasks) {
            this.timestamp = timestamp;
            this.status = status;
            this.numTasks = numTasks;
        }

        public String toString() {
            return "ForkedStatus{timestamp=" + this.timestamp + ", status=" + this.status + ", numTasks=" + this.numTasks + "}";
        }
    }

    private static enum FORKED_STATUS {
        INITIALIZING,
        RUNNING,
        SHUTTING_DOWN,
        FAILED_COMMUNICATION;

    }
}

