/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.configuration.jsse.TLSParameterJaxBUtils;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.configuration.security.ClientAuthentication;
import org.apache.cxf.configuration.security.KeyManagersType;
import org.apache.cxf.configuration.security.KeyStoreType;
import org.apache.cxf.configuration.security.TrustManagersType;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSBindingFactory;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.utils.JAXRSServerFactoryCustomizationUtils;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharingFilter;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.transport.common.gzip.GZIPInInterceptor;
import org.apache.cxf.transport.common.gzip.GZIPOutInterceptor;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.apache.tika.Tika;
import org.apache.tika.config.ServiceLoader;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.digest.CompositeDigester;
import org.apache.tika.parser.digestutils.BouncyCastleDigester;
import org.apache.tika.parser.digestutils.CommonsDigester;
import org.apache.tika.pipes.emitter.EmitterManager;
import org.apache.tika.pipes.fetcher.FetcherManager;
import org.apache.tika.server.core.DefaultInputStreamFactory;
import org.apache.tika.server.core.FetcherStreamFactory;
import org.apache.tika.server.core.InputStreamFactory;
import org.apache.tika.server.core.ProduceTypeResourceComparator;
import org.apache.tika.server.core.ServerStatus;
import org.apache.tika.server.core.ServerStatusResource;
import org.apache.tika.server.core.ServerStatusWatcher;
import org.apache.tika.server.core.TikaLoggingFilter;
import org.apache.tika.server.core.TikaServerConfig;
import org.apache.tika.server.core.TikaServerParseExceptionMapper;
import org.apache.tika.server.core.TlsConfig;
import org.apache.tika.server.core.resource.AsyncResource;
import org.apache.tika.server.core.resource.DetectorResource;
import org.apache.tika.server.core.resource.LanguageResource;
import org.apache.tika.server.core.resource.MetadataResource;
import org.apache.tika.server.core.resource.PipesResource;
import org.apache.tika.server.core.resource.RecursiveMetadataResource;
import org.apache.tika.server.core.resource.TikaDetectors;
import org.apache.tika.server.core.resource.TikaMimeTypes;
import org.apache.tika.server.core.resource.TikaParsers;
import org.apache.tika.server.core.resource.TikaResource;
import org.apache.tika.server.core.resource.TikaServerResource;
import org.apache.tika.server.core.resource.TikaServerStatus;
import org.apache.tika.server.core.resource.TikaVersion;
import org.apache.tika.server.core.resource.TikaWelcome;
import org.apache.tika.server.core.resource.TranslateResource;
import org.apache.tika.server.core.resource.UnpackerResource;
import org.apache.tika.server.core.writer.CSVMessageBodyWriter;
import org.apache.tika.server.core.writer.JSONMessageBodyWriter;
import org.apache.tika.server.core.writer.JSONObjWriter;
import org.apache.tika.server.core.writer.MetadataListMessageBodyWriter;
import org.apache.tika.server.core.writer.TarWriter;
import org.apache.tika.server.core.writer.TextMessageBodyWriter;
import org.apache.tika.server.core.writer.TikaServerWriter;
import org.apache.tika.server.core.writer.ZipWriter;
import org.apache.tika.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class TikaServerProcess {
    public static final Set<String> LOG_LEVELS = new HashSet<String>(Arrays.asList("debug", "info"));
    public static final int BIND_EXCEPTION = 42;
    private static final Logger LOG = LoggerFactory.getLogger(TikaServerProcess.class);
    public static int DO_NOT_RESTART_EXIT_VALUE = -100;

    private static Options getOptions() {
        Options options = new Options();
        options.addOption("h", "host", true, "host name, use * for all)");
        options.addOption("p", "port", true, "listen port");
        options.addOption("c", "config", true, "Tika Configuration file to override default config with.");
        options.addOption("i", "id", true, "id to use for server in server status endpoint");
        options.addOption("?", "help", false, "this help message");
        options.addOption("noFork", "noFork", false, "if launched in no fork mode");
        options.addOption("forkedStatusFile", true, "Not allowed in -noFork: temporary file used to communicate with forking process -- do not use this! Should only be invoked by forking process.");
        options.addOption("tmpFilePrefix", true, "Not allowed in -noFork: prefix for temp file - for debugging only");
        options.addOption("numRestarts", true, "Not allowed in -noFork: number of times that the forked server has had to be restarted.");
        return options;
    }

    public static void main(String[] args) throws Exception {
        LOG.info("Starting {} server", (Object)Tika.getString());
        try {
            Options options = TikaServerProcess.getOptions();
            DefaultParser cliParser = new DefaultParser();
            CommandLine line = cliParser.parse(options, args);
            TikaServerConfig tikaServerConfig = TikaServerConfig.load(line);
            LOG.debug("forked config: {}", (Object)tikaServerConfig);
            ServerDetails serverDetails = TikaServerProcess.initServer(tikaServerConfig);
            TikaServerProcess.startServer(serverDetails, tikaServerConfig);
        }
        catch (Exception e) {
            LOG.error("Can't start: ", e);
            System.exit(-1);
        }
    }

    private static boolean isBindException(Throwable e) {
        if (e == null) {
            return false;
        }
        if (e instanceof BindException) {
            return true;
        }
        return TikaServerProcess.isBindException(e.getCause());
    }

    private static void startServer(ServerDetails serverDetails, TikaServerConfig tikaServerConfig) throws Exception {
        try {
            Server server = serverDetails.sf.create();
        }
        catch (ServiceConstructionException e) {
            LOG.warn("exception starting server", e);
            if (TikaServerProcess.isBindException(e)) {
                System.exit(42);
            }
            System.exit(DO_NOT_RESTART_EXIT_VALUE);
        }
        if (!tikaServerConfig.isNoFork()) {
            InputStream in = System.in;
            System.setIn(new ByteArrayInputStream(new byte[0]));
            String forkedStatusFile = tikaServerConfig.getForkedStatusFile();
            Thread serverThread = new Thread(new ServerStatusWatcher(serverDetails.serverStatus, in, Paths.get(forkedStatusFile, new String[0]), tikaServerConfig));
            serverThread.start();
        }
        LOG.info("Started Apache Tika server {} at {}", (Object)serverDetails.serverId, (Object)serverDetails.url);
    }

    private static ServerDetails initServer(TikaServerConfig tikaServerConfig) throws Exception {
        ServerStatus serverStatus;
        TikaConfig tika;
        String host = tikaServerConfig.getHost();
        int[] ports = tikaServerConfig.getPorts();
        if (ports.length > 1) {
            throw new IllegalArgumentException("there must be only one port here! I see: " + tikaServerConfig.getPort());
        }
        int port = ports[0];
        if (tikaServerConfig.hasConfigFile()) {
            LOG.info("Using custom config: {}", (Object)tikaServerConfig.getConfigPath());
            tika = new TikaConfig(tikaServerConfig.getConfigPath());
        } else {
            tika = TikaConfig.getDefaultConfig();
        }
        CompositeDigester digester = null;
        if (!StringUtils.isBlank(tikaServerConfig.getDigest())) {
            try {
                digester = new CommonsDigester(tikaServerConfig.getDigestMarkLimit(), tikaServerConfig.getDigest());
            }
            catch (IllegalArgumentException commonsException) {
                try {
                    digester = new BouncyCastleDigester(tikaServerConfig.getDigestMarkLimit(), tikaServerConfig.getDigest());
                }
                catch (IllegalArgumentException bcException) {
                    throw new IllegalArgumentException("Tried both CommonsDigester (" + commonsException.getMessage() + ") and BouncyCastleDigester (" + bcException.getMessage() + ")", bcException);
                }
            }
        }
        FetcherManager fetcherManager = null;
        InputStreamFactory inputStreamFactory = null;
        if (tikaServerConfig.isEnableUnsecureFeatures()) {
            fetcherManager = FetcherManager.load(tikaServerConfig.getConfigPath());
            inputStreamFactory = new FetcherStreamFactory(fetcherManager);
        } else {
            inputStreamFactory = new DefaultInputStreamFactory();
        }
        String serverId = tikaServerConfig.getId();
        LOG.debug("SERVER ID:" + serverId);
        if (tikaServerConfig.isNoFork()) {
            serverStatus = new ServerStatus(serverId, 0, true);
        } else {
            serverStatus = new ServerStatus(serverId, tikaServerConfig.getNumRestarts(), false);
            System.setOut(System.err);
        }
        TikaResource.init(tika, tikaServerConfig, digester, inputStreamFactory, serverStatus);
        JAXRSServerFactoryBean sf = new JAXRSServerFactoryBean();
        ArrayList<ResourceProvider> resourceProviders = new ArrayList<ResourceProvider>();
        ArrayList<Object> providers = new ArrayList<Object>();
        TikaServerProcess.loadAllProviders(tikaServerConfig, serverStatus, resourceProviders, providers);
        sf.setResourceProviders(resourceProviders);
        sf.setProviders(providers);
        sf.setOutInterceptors(Collections.singletonList(new GZIPOutInterceptor()));
        sf.setInInterceptors(Collections.singletonList(new GZIPInInterceptor()));
        String protocol = tikaServerConfig.getTlsConfig().isActive() ? "https" : "http";
        String url = protocol + "://" + host + ":" + port + "/";
        sf.setAddress(url);
        sf.setResourceComparator(new ProduceTypeResourceComparator());
        BindingFactoryManager manager = sf.getBus().getExtension(BindingFactoryManager.class);
        if (tikaServerConfig.getTlsConfig().isActive()) {
            LOG.warn("The TLS configuration is in BETA and might change dramatically in future releases.");
            TLSServerParameters tlsParams = TikaServerProcess.getTlsParams(tikaServerConfig.getTlsConfig());
            JettyHTTPServerEngineFactory factory = new JettyHTTPServerEngineFactory();
            factory.setBus(sf.getBus());
            factory.setTLSServerParametersForPort(host, port, tlsParams);
            JAXRSServerFactoryCustomizationUtils.customize(sf);
        } else {
            JAXRSBindingFactory factory = new JAXRSBindingFactory();
            factory.setBus(sf.getBus());
            manager.registerBindingFactory("http://apache.org/cxf/binding/jaxrs", factory);
        }
        ServerDetails details = new ServerDetails();
        details.sf = sf;
        details.url = url;
        details.serverId = serverId;
        details.serverStatus = serverStatus;
        return details;
    }

    private static TLSServerParameters getTlsParams(TlsConfig tlsConfig) throws GeneralSecurityException, IOException {
        KeyStoreType keyStore = new KeyStoreType();
        keyStore.setType(tlsConfig.getKeyStoreType());
        keyStore.setPassword(tlsConfig.getKeyStorePassword());
        keyStore.setFile(tlsConfig.getKeyStoreFile());
        KeyManagersType kmt = new KeyManagersType();
        kmt.setKeyStore(keyStore);
        kmt.setKeyPassword(tlsConfig.getKeyStorePassword());
        TLSServerParameters parameters = new TLSServerParameters();
        parameters.setKeyManagers(TLSParameterJaxBUtils.getKeyManagers(kmt));
        if (tlsConfig.hasTrustStore()) {
            KeyStoreType trustKeyStore = new KeyStoreType();
            trustKeyStore.setType(tlsConfig.getTrustStoreType());
            trustKeyStore.setPassword(tlsConfig.getTrustStorePassword());
            trustKeyStore.setFile(tlsConfig.getTrustStoreFile());
            TrustManagersType tmt = new TrustManagersType();
            tmt.setKeyStore(trustKeyStore);
            parameters.setTrustManagers(TLSParameterJaxBUtils.getTrustManagers(tmt, true));
        }
        ClientAuthentication clientAuthentication = new ClientAuthentication();
        clientAuthentication.setRequired(tlsConfig.isClientAuthenticationRequired());
        clientAuthentication.setWant(tlsConfig.isClientAuthenticationWanted());
        parameters.setClientAuthentication(clientAuthentication);
        return parameters;
    }

    private static void loadAllProviders(TikaServerConfig tikaServerConfig, ServerStatus serverStatus, List<ResourceProvider> resourceProviders, List<Object> writers) throws TikaException, SAXException, IOException {
        List<ResourceProvider> tmpCoreProviders = TikaServerProcess.loadCoreProviders(tikaServerConfig, serverStatus);
        resourceProviders.addAll(tmpCoreProviders);
        resourceProviders.add(new SingletonResourceProvider(new TikaWelcome(tmpCoreProviders)));
        writers.add(new TarWriter());
        writers.add(new ZipWriter());
        writers.add(new CSVMessageBodyWriter());
        writers.add(new MetadataListMessageBodyWriter());
        writers.add(new JSONMessageBodyWriter());
        writers.add(new TextMessageBodyWriter());
        writers.addAll(TikaServerProcess.loadWriterServices());
        writers.add(new TikaServerParseExceptionMapper(tikaServerConfig.isReturnStackTrace()));
        writers.add(new JSONObjWriter());
        TikaLoggingFilter logFilter = null;
        if (!StringUtils.isBlank(tikaServerConfig.getLogLevel())) {
            String logLevel = tikaServerConfig.getLogLevel();
            if (LOG_LEVELS.contains(logLevel)) {
                boolean isInfoLevel = "info".equals(logLevel);
                logFilter = new TikaLoggingFilter(isInfoLevel);
                writers.add(logFilter);
            } else {
                LOG.warn("Unsupported request URI log level: {}", (Object)logLevel);
            }
        }
        CrossOriginResourceSharingFilter corsFilter = null;
        if (!StringUtils.isBlank(tikaServerConfig.getCors())) {
            corsFilter = new CrossOriginResourceSharingFilter();
            String url = tikaServerConfig.getCors();
            ArrayList<String> origins = new ArrayList<String>();
            if (!url.equals("*")) {
                origins.add(url);
            }
            corsFilter.setAllowOrigins(origins);
            writers.add(corsFilter);
        }
    }

    private static List<ResourceProvider> loadCoreProviders(TikaServerConfig tikaServerConfig, ServerStatus serverStatus) throws TikaException, IOException, SAXException {
        ArrayList<ResourceProvider> resourceProviders = new ArrayList<ResourceProvider>();
        boolean addAsyncResource = false;
        boolean addPipesResource = false;
        if (tikaServerConfig.getEndpoints().size() == 0) {
            resourceProviders.add(new SingletonResourceProvider(new MetadataResource()));
            resourceProviders.add(new SingletonResourceProvider(new RecursiveMetadataResource()));
            resourceProviders.add(new SingletonResourceProvider(new DetectorResource(serverStatus)));
            resourceProviders.add(new SingletonResourceProvider(new LanguageResource()));
            resourceProviders.add(new SingletonResourceProvider(new TranslateResource(serverStatus, tikaServerConfig.getTaskTimeoutMillis())));
            resourceProviders.add(new SingletonResourceProvider(new TikaResource()));
            resourceProviders.add(new SingletonResourceProvider(new UnpackerResource()));
            resourceProviders.add(new SingletonResourceProvider(new TikaMimeTypes()));
            resourceProviders.add(new SingletonResourceProvider(new TikaDetectors()));
            resourceProviders.add(new SingletonResourceProvider(new TikaParsers()));
            resourceProviders.add(new SingletonResourceProvider(new TikaVersion()));
            if (tikaServerConfig.isEnableUnsecureFeatures()) {
                if (tikaServerConfig.getSupportedFetchers().size() > 0 && tikaServerConfig.getSupportedEmitters().size() > 0) {
                    addAsyncResource = true;
                    addPipesResource = true;
                }
                resourceProviders.add(new SingletonResourceProvider(new TikaServerStatus(serverStatus)));
            }
        } else {
            for (String endPoint : tikaServerConfig.getEndpoints()) {
                if ("meta".equals(endPoint)) {
                    resourceProviders.add(new SingletonResourceProvider(new MetadataResource()));
                    continue;
                }
                if ("rmeta".equals(endPoint)) {
                    resourceProviders.add(new SingletonResourceProvider(new RecursiveMetadataResource()));
                    continue;
                }
                if ("detect".equals(endPoint)) {
                    resourceProviders.add(new SingletonResourceProvider(new DetectorResource(serverStatus)));
                    continue;
                }
                if ("language".equals(endPoint)) {
                    resourceProviders.add(new SingletonResourceProvider(new LanguageResource()));
                    continue;
                }
                if ("translate".equals(endPoint)) {
                    resourceProviders.add(new SingletonResourceProvider(new TranslateResource(serverStatus, tikaServerConfig.getTaskTimeoutMillis())));
                    continue;
                }
                if ("tika".equals(endPoint)) {
                    resourceProviders.add(new SingletonResourceProvider(new TikaResource()));
                    continue;
                }
                if ("unpack".equals(endPoint)) {
                    resourceProviders.add(new SingletonResourceProvider(new UnpackerResource()));
                    continue;
                }
                if ("mime".equals(endPoint)) {
                    resourceProviders.add(new SingletonResourceProvider(new TikaMimeTypes()));
                    continue;
                }
                if ("detectors".equals(endPoint)) {
                    resourceProviders.add(new SingletonResourceProvider(new TikaDetectors()));
                    continue;
                }
                if ("parsers".equals(endPoint)) {
                    resourceProviders.add(new SingletonResourceProvider(new TikaParsers()));
                    continue;
                }
                if ("version".equals(endPoint)) {
                    resourceProviders.add(new SingletonResourceProvider(new TikaVersion()));
                    continue;
                }
                if ("pipes".equals(endPoint)) {
                    addPipesResource = true;
                    continue;
                }
                if ("async".equals(endPoint)) {
                    addAsyncResource = true;
                    continue;
                }
                if (!"status".equals(endPoint)) continue;
                resourceProviders.add(new SingletonResourceProvider(new TikaServerStatus(serverStatus)));
            }
        }
        if (addAsyncResource) {
            AsyncResource localAsyncResource = new AsyncResource(tikaServerConfig.getConfigPath(), tikaServerConfig.getSupportedFetchers());
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    localAsyncResource.shutdownNow();
                }
                catch (Exception e) {
                    LOG.warn("problem shutting down local async resource", e);
                }
            }));
            resourceProviders.add(new SingletonResourceProvider(localAsyncResource));
        }
        if (addPipesResource) {
            PipesResource localPipesResource = new PipesResource(tikaServerConfig.getConfigPath());
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    localPipesResource.close();
                }
                catch (Exception e) {
                    LOG.warn("exception closing local pipes resource", e);
                }
            }));
            resourceProviders.add(new SingletonResourceProvider(localPipesResource));
        }
        resourceProviders.addAll(TikaServerProcess.loadResourceServices(serverStatus));
        return resourceProviders;
    }

    private static void logFetchersAndEmitters(boolean enableUnsecureFeatures, FetcherManager fetcherManager, EmitterManager emitterManager) {
        if (enableUnsecureFeatures) {
            StringBuilder sb = new StringBuilder();
            Set<String> supportedFetchers = fetcherManager.getSupported();
            sb.append("enableSecureFeatures has been selected.\n");
            if (supportedFetchers.size() == 0) {
                sb.append("There are no fetchers specified in the TikaConfig");
            } else {
                sb.append("The following fetchers are available to whomever has access to this server:\n");
                for (String p : supportedFetchers) {
                    sb.append(p).append("\n");
                }
            }
            Set<String> emitters = emitterManager.getSupported();
            if (supportedFetchers.size() == 0) {
                sb.append("There are no emitters specified in the TikaConfig");
            } else {
                sb.append("The following emitters are available to whomever has access to this server:\n");
                for (String e : emitters) {
                    sb.append(e).append("\n");
                }
            }
            LOG.info(sb.toString());
        } else {
            String warn;
            if (emitterManager.getSupported().size() > 0) {
                warn = "enableUnsecureFeatures has not been set to 'true' in the server config file.\nThe " + emitterManager.getSupported().size() + " emitter(s) that you've\nspecified in TikaConfig will not be available on the /emit or /async endpoints.\nTo enable your emitters, start tika-server with <enableUnsecureFeatures>true</enableUnsecureFeatures> parameter in the TikaConfig\n\n";
                LOG.warn(warn);
            }
            if (emitterManager.getSupported().size() > 0) {
                warn = "enableUnsecureFeatures has not been set to 'true' in the server config file.\nThe " + emitterManager.getSupported().size() + " fetcher(s) that you've\nspecified in TikaConfig will not be available on the /emit or /async endpoints.\nTo enable your emitters, start tika-server with <enableUnsecureFeatures>true</enableUnsecureFeatures> parameter in the TikaConfig\n\n";
                LOG.warn(warn);
            }
        }
    }

    private static Collection<? extends ResourceProvider> loadResourceServices(ServerStatus serverStatus) {
        List<TikaServerResource> resources = new ServiceLoader(TikaServerProcess.class.getClassLoader()).loadServiceProviders(TikaServerResource.class);
        ArrayList<SingletonResourceProvider> providers = new ArrayList<SingletonResourceProvider>();
        for (TikaServerResource r : resources) {
            LOG.info("loading resource from SPI: " + String.valueOf(r.getClass()));
            if (r instanceof ServerStatusResource) {
                ((ServerStatusResource)r).setServerStatus(serverStatus);
            }
            providers.add(new SingletonResourceProvider(r));
        }
        return providers;
    }

    private static Collection<?> loadWriterServices() {
        return new ServiceLoader(TikaServerProcess.class.getClassLoader()).loadServiceProviders(TikaServerWriter.class);
    }

    private static class ServerDetails {
        JAXRSServerFactoryBean sf;
        String serverId;
        String url;
        ServerStatus serverStatus;

        private ServerDetails() {
        }
    }
}

