/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.UnsupportedFormatException;
import org.apache.tika.server.core.TikaServerParseException;

@Provider
public class TikaServerParseExceptionMapper
implements ExceptionMapper<TikaServerParseException> {
    private final boolean returnStack;

    public TikaServerParseExceptionMapper(boolean returnStack) {
        this.returnStack = returnStack;
    }

    @Override
    public Response toResponse(TikaServerParseException e) {
        if (e.getMessage() != null && e.getMessage().equals(Response.Status.UNSUPPORTED_MEDIA_TYPE.toString())) {
            return this.buildResponse(e, 415);
        }
        Throwable cause = e.getCause();
        if (cause == null) {
            return this.buildResponse(e, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        if (cause instanceof EncryptedDocumentException) {
            return this.buildResponse(cause, 422);
        }
        if (cause instanceof TikaException) {
            Throwable causeOfCause = cause.getCause();
            if (causeOfCause instanceof WebApplicationException) {
                return ((WebApplicationException)causeOfCause).getResponse();
            }
            return this.buildResponse(cause, 422);
        }
        if (cause instanceof IllegalStateException) {
            return this.buildResponse(cause, 422);
        }
        if (cause instanceof UnsupportedFormatException) {
            return this.buildResponse(cause, 422);
        }
        if (cause instanceof WebApplicationException) {
            return ((WebApplicationException)e.getCause()).getResponse();
        }
        return this.buildResponse(e, 500);
    }

    private Response buildResponse(Throwable cause, int i) {
        if (this.returnStack && cause != null) {
            StringWriter result = new StringWriter();
            PrintWriter writer = new PrintWriter(result);
            cause.printStackTrace(writer);
            writer.flush();
            try {
                ((Writer)result).flush();
            }
            catch (IOException e) {
                return Response.status(500).build();
            }
            return Response.status(i).entity(((Object)result).toString()).type("text/plain").build();
        }
        return Response.status(i).build();
    }
}

