/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.tika.config.ConfigBase;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.server.core.TlsConfig;
import org.apache.tika.utils.ProcessUtils;
import org.apache.tika.utils.StringUtils;
import org.apache.tika.utils.XMLReaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TikaServerConfig
extends ConfigBase {
    public static final int DEFAULT_PORT = 9998;
    public static final String DEFAULT_HOST = "localhost";
    public static final Set<String> LOG_LEVELS = new HashSet<String>(Arrays.asList("debug", "info"));
    public static final long DEFAULT_TASK_TIMEOUT_MILLIS = 300000L;
    public static final long DEFAULT_MINIMUM_TIMEOUT_MILLIS = 30000L;
    public static final long DEFAULT_TASK_PULSE_MILLIS = 10000L;
    public static final long DEFAULT_FORKED_STARTUP_MILLIS = 120000L;
    private static final Logger LOG = LoggerFactory.getLogger(TikaServerConfig.class);
    private static final long DEFAULT_MAX_FILES = 100000L;
    private static final int DEFAULT_DIGEST_MARK_LIMIT = 0x1400000;
    private static final String UNSECURE_WARNING = "WARNING: You have chosen to run tika-server with unsecure features enabled.\nWhoever has access to your service now has the same read permissions\nas you've given your fetchers and the same write permissions as your emitters.\nUsers could request and receive a sensitive file from your\ndrive or a webpage from your intranet and/or send malicious content to\n your emitter endpoints.  See CVE-2015-3271.\nPlease make sure you know what you are doing.";
    private static final List<String> ONLY_IN_FORK_MODE = Arrays.asList("taskTimeoutMillis", "taskPulseMillis", "maxFiles", "javaPath", "maxRestarts", "numRestarts", "forkedStatusFile", "maxForkedStartupMillis", "tmpFilePrefix");
    private static Pattern SYS_PROPS = Pattern.compile("\\$\\{sys:([-_0-9A-Za-z]+)\\}");
    private int maxRestarts = -1;
    private long maxFiles = 100000L;
    private long taskTimeoutMillis = 300000L;
    private long minimumTimeoutMillis = 30000L;
    private long taskPulseMillis = 10000L;
    private long maxforkedStartupMillis = 120000L;
    private boolean enableUnsecureFeatures = false;
    private String cors = "";
    private boolean returnStackTrace = false;
    private boolean noFork = false;
    private String tempFilePrefix = "apache-tika-server-forked-tmp-";
    private Set<String> supportedFetchers = new HashSet<String>();
    private Set<String> supportedEmitters = new HashSet<String>();
    private List<String> forkedJvmArgs = new ArrayList<String>();
    private String idBase = UUID.randomUUID().toString();
    private String port = Integer.toString(9998);
    private String host = "localhost";
    private int digestMarkLimit = 0x1400000;
    private String digest = "";
    private String javaPath = "java";
    private String logLevel = "";
    private Path configPath;
    private List<String> endpoints = new ArrayList<String>();
    private String forkedStatusFile;
    private int numRestarts = 0;
    private boolean preventStopMethod = false;
    private TlsConfig tlsConfig = new TlsConfig();

    public static TikaServerConfig load() {
        return new TikaServerConfig();
    }

    public static TikaServerConfig load(CommandLine commandLine) throws IOException, TikaException {
        TikaServerConfig config = null;
        HashSet<String> settings = new HashSet<String>();
        config = commandLine.hasOption("c") ? TikaServerConfig.load(Paths.get(commandLine.getOptionValue("c"), new String[0]), commandLine, settings) : new TikaServerConfig();
        if (commandLine.hasOption("p")) {
            config.setPort(commandLine.getOptionValue("p"));
            settings.add("port");
        }
        if (commandLine.hasOption("h")) {
            config.setHost(commandLine.getOptionValue("h"));
            settings.add("host");
        }
        if (commandLine.hasOption("noFork")) {
            config.setNoFork(true);
            settings.add("noFork");
        }
        if (commandLine.hasOption("i")) {
            config.setId(commandLine.getOptionValue("i"));
            settings.add("id");
        }
        if (commandLine.hasOption("numRestarts")) {
            config.setNumRestarts(Integer.parseInt(commandLine.getOptionValue("numRestarts")));
            settings.add("numRestarts");
        }
        if (commandLine.hasOption("forkedStatusFile")) {
            config.setForkedStatusFile(commandLine.getOptionValue("forkedStatusFile"));
            settings.add("forkedStatusFile");
        }
        config.validateConsistency(settings);
        return config;
    }

    static TikaServerConfig load(Path p, CommandLine commandLine, Set<String> settings) throws IOException, TikaException {
        try (InputStream is = Files.newInputStream(p, new OpenOption[0]);){
            TikaServerConfig config = TikaServerConfig.load(is, commandLine, settings);
            if (config.getConfigPath() == null) {
                config.setConfigPath(p.toAbsolutePath().toString());
            }
            TikaServerConfig.loadSupportedFetchersEmitters(config);
            TikaServerConfig tikaServerConfig = config;
            return tikaServerConfig;
        }
    }

    private static TikaServerConfig load(InputStream is, CommandLine commandLine, Set<String> settings) throws IOException, TikaException {
        TikaServerConfig tikaServerConfig = new TikaServerConfig();
        Set<String> configSettings = tikaServerConfig.configure("server", is);
        settings.addAll(configSettings);
        if (commandLine.hasOption("noFork")) {
            tikaServerConfig.setNoFork(true);
        }
        return tikaServerConfig;
    }

    private static void loadSupportedFetchersEmitters(TikaServerConfig tikaServerConfig) throws IOException, TikaConfigException {
        try (InputStream is = Files.newInputStream(tikaServerConfig.getConfigPath(), new OpenOption[0]);){
            Element properties = null;
            try {
                properties = XMLReaderUtils.buildDOM(is).getDocumentElement();
            }
            catch (SAXException e) {
                throw new IOException(e);
            }
            catch (TikaException e) {
                throw new TikaConfigException("problem loading xml to dom", e);
            }
            if (!properties.getLocalName().equals("properties")) {
                throw new TikaConfigException("expect properties as root node");
            }
            NodeList children = properties.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if ("fetchers".equals(child.getLocalName())) {
                    TikaServerConfig.loadSupported(child, "fetcher", tikaServerConfig.supportedFetchers);
                    continue;
                }
                if (!"emitters".equals(child.getLocalName())) continue;
                TikaServerConfig.loadSupported(child, "emitter", tikaServerConfig.supportedEmitters);
            }
        }
    }

    private static void loadSupported(Node compound, String itemName, Set<String> supported) {
        NodeList children = compound.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String name;
            Node child = children.item(i);
            if (!itemName.equals(child.getLocalName()) || (name = TikaServerConfig.getName(child)) == null) continue;
            supported.add(name);
        }
    }

    private static String getName(Node fetcherOrEmitter) {
        NodeList children = fetcherOrEmitter.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if ("params".equals(child.getLocalName())) {
                NodeList params = child.getChildNodes();
                for (int j = 0; j < params.getLength(); ++j) {
                    Node param = params.item(j);
                    if (!"name".equals(param.getLocalName())) continue;
                    return param.getTextContent();
                }
                continue;
            }
            if (!"name".equals(child.getLocalName())) continue;
            return child.getTextContent();
        }
        return null;
    }

    protected static List<String> interpolateSysProps(List<String> forkedJvmArgs) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String arg : forkedJvmArgs) {
            if (arg.startsWith("-D")) {
                String interpolated = TikaServerConfig.interpolate(arg);
                ret.add(interpolated);
                continue;
            }
            ret.add(arg);
        }
        return ret;
    }

    private static String interpolate(String arg) {
        StringBuilder sb = new StringBuilder();
        Matcher m = SYS_PROPS.matcher(arg);
        while (m.find()) {
            String prop = System.getProperty(m.group(1));
            LOG.debug("interpolating {} -> {}", (Object)m.group(1), (Object)prop);
            if (prop == null) {
                LOG.warn("no system property set for {}, falling back to {}", (Object)m.group(1), (Object)arg);
                return arg;
            }
            m.appendReplacement(sb, Matcher.quoteReplacement(prop));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public boolean isNoFork() {
        return this.noFork;
    }

    public void setNoFork(boolean noFork) {
        this.noFork = noFork;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public long getTaskTimeoutMillis() {
        return this.taskTimeoutMillis;
    }

    public void setTaskTimeoutMillis(long taskTimeoutMillis) {
        this.taskTimeoutMillis = taskTimeoutMillis;
    }

    public long getTaskPulseMillis() {
        return this.taskPulseMillis;
    }

    public void setTaskPulseMillis(long taskPulseMillis) {
        this.taskPulseMillis = taskPulseMillis;
    }

    public int getMaxRestarts() {
        return this.maxRestarts;
    }

    public void setMaxRestarts(int maxRestarts) {
        this.maxRestarts = maxRestarts;
    }

    public long getMaxForkedStartupMillis() {
        return this.maxforkedStartupMillis;
    }

    public void setMaxForkedStartupMillis(long maxForkedStartupMillis) {
        this.maxforkedStartupMillis = maxForkedStartupMillis;
    }

    public List<String> getForkedProcessArgs(String portString, String id) {
        int[] ports = this.getPorts(portString);
        if (ports.length > 1 || ports.length == 0) {
            throw new IllegalArgumentException("must specify one and only one port here:" + portString);
        }
        int port = ports[0];
        return this.getForkedProcessArgs(port, id);
    }

    public List<String> getForkedProcessArgs(int port, String id) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-h");
        args.add(this.getHost());
        args.add("-p");
        args.add(Integer.toString(port));
        args.add("-i");
        args.add(id);
        if (this.hasConfigFile()) {
            args.add("-c");
            args.add(ProcessUtils.escapeCommandLine(this.configPath.toAbsolutePath().toString()));
        }
        return args;
    }

    public long getMinimumTimeoutMillis() {
        return this.minimumTimeoutMillis;
    }

    public void setMinimumTimeoutMillis(long minimumTimeoutMillis) {
        this.minimumTimeoutMillis = minimumTimeoutMillis;
    }

    public String getIdBase() {
        return this.idBase;
    }

    public String getJavaPath() {
        return this.javaPath;
    }

    public void setJavaPath(String javaPath) {
        this.javaPath = javaPath;
    }

    public List<String> getForkedJvmArgs() {
        return new ArrayList<String>(this.forkedJvmArgs);
    }

    public void setForkedJvmArgs(List<String> forkedJvmArgs) {
        this.forkedJvmArgs = new ArrayList<String>(TikaServerConfig.interpolateSysProps(forkedJvmArgs));
    }

    public String getTempFilePrefix() {
        return this.tempFilePrefix;
    }

    public boolean isEnableUnsecureFeatures() {
        return this.enableUnsecureFeatures;
    }

    public void setEnableUnsecureFeatures(boolean enableUnsecureFeatures) {
        this.enableUnsecureFeatures = enableUnsecureFeatures;
    }

    private void validateConsistency(Set<String> settings) throws TikaConfigException {
        boolean foundHeadlessOption;
        if (this.host == null) {
            throw new TikaConfigException("Must specify 'host'");
        }
        if (!StringUtils.isBlank(this.port)) {
            this.setPort(this.port);
        }
        if (this.isNoFork()) {
            for (String onlyFork : ONLY_IN_FORK_MODE) {
                if (!settings.contains(onlyFork)) continue;
                throw new TikaConfigException("Can't set param=" + onlyFork + "if you've selected noFork");
            }
        }
        if (!(foundHeadlessOption = this.forkedJvmArgs.stream().anyMatch(arg -> arg.contains("java.awt.headless")))) {
            this.forkedJvmArgs.add("-Djava.awt.headless=true");
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        if ("*".equals(host)) {
            host = "0.0.0.0";
        }
        this.host = host;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String level) throws TikaConfigException {
        if (!level.equals("debug") && !level.equals("info")) {
            throw new TikaConfigException("log level must be one of: 'debug' or 'info'");
        }
        this.logLevel = level;
    }

    public String getCors() {
        return this.cors;
    }

    public void setCors(String cors) {
        this.cors = cors;
    }

    public boolean hasConfigFile() {
        return this.configPath != null;
    }

    public Path getConfigPath() {
        return this.configPath;
    }

    public void setConfigPath(String path) {
        this.configPath = Paths.get(path, new String[0]);
    }

    public int getDigestMarkLimit() {
        return this.digestMarkLimit;
    }

    public void setDigestMarkLimit(int digestMarkLimit) {
        this.digestMarkLimit = digestMarkLimit;
    }

    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String digest) {
        LOG.info("As of Tika 2.5.0, you can set the digester via the AutoDetectParserConfig in tika-config.xml. We plan to remove this commandline option in 2.8.0");
        this.digest = digest;
    }

    public long getMaxFiles() {
        return this.maxFiles;
    }

    public void setMaxFiles(long maxFiles) {
        this.maxFiles = maxFiles;
    }

    public boolean isReturnStackTrace() {
        return this.returnStackTrace;
    }

    public void setReturnStackTrace(boolean returnStackTrace) {
        this.returnStackTrace = returnStackTrace;
    }

    public TlsConfig getTlsConfig() {
        return this.tlsConfig;
    }

    public void setTlsConfig(TlsConfig tlsConfig) {
        this.tlsConfig = tlsConfig;
    }

    public List<String> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List<String> endpoints) {
        this.endpoints = new ArrayList<String>(endpoints);
    }

    public String getId() {
        return this.idBase;
    }

    public void setId(String id) {
        this.idBase = id;
    }

    private void addEndPoints(List<String> endPoints) {
        this.endpoints.addAll(endPoints);
    }

    private void addJVMArgs(List<String> args) {
        this.forkedJvmArgs.addAll(args);
    }

    public int getNumRestarts() {
        return this.numRestarts;
    }

    private void setNumRestarts(int numRestarts) {
        this.numRestarts = numRestarts;
    }

    public String getForkedStatusFile() {
        return this.forkedStatusFile;
    }

    private void setForkedStatusFile(String forkedStatusFile) {
        this.forkedStatusFile = forkedStatusFile;
    }

    public void setMaxforkedStartupMillis(long maxforkedStartupMillis) {
        this.maxforkedStartupMillis = maxforkedStartupMillis;
    }

    public boolean isPreventStopMethod() {
        return this.preventStopMethod;
    }

    public void setPreventStopMethod(boolean preventStopMethod) {
        this.preventStopMethod = preventStopMethod;
    }

    public int[] getPorts() {
        return this.getPorts(this.port);
    }

    private int[] getPorts(String portString) {
        Matcher rangeMatcher = Pattern.compile("^(\\d+)-(\\d+)\\Z").matcher("");
        String[] commaDelimited = portString.split(",");
        ArrayList<Integer> indivPorts = new ArrayList<Integer>();
        for (String val : commaDelimited) {
            rangeMatcher.reset(val);
            if (rangeMatcher.find()) {
                int min = Math.min(Integer.parseInt(rangeMatcher.group(1)), Integer.parseInt(rangeMatcher.group(2)));
                int max = Math.max(Integer.parseInt(rangeMatcher.group(1)), Integer.parseInt(rangeMatcher.group(2)));
                for (int i = min; i <= max; ++i) {
                    indivPorts.add(i);
                }
                continue;
            }
            indivPorts.add(Integer.parseInt(val));
        }
        return indivPorts.stream().mapToInt(Integer::intValue).toArray();
    }

    public Set<String> getSupportedFetchers() {
        return this.supportedFetchers;
    }

    public Set<String> getSupportedEmitters() {
        return this.supportedEmitters;
    }
}

