/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.tika.server.core.TikaServerConfig;
import org.apache.tika.server.core.TikaServerProcess;
import org.apache.tika.server.core.TikaServerWatchDog;
import org.apache.tika.server.core.WatchDogResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TikaServerCli {
    private static final Logger LOG = LoggerFactory.getLogger(TikaServerCli.class);
    public static String TIKA_SERVER_ID_ENV = "tika.server.id";
    private static List<TikaServerWatchDog> WATCHERS = new ArrayList<TikaServerWatchDog>();
    private static boolean PREVENT_STOP = false;

    private static Options getOptions() {
        Options options = new Options();
        options.addOption("h", "host", true, "host name (default = localhost, use * for all)");
        options.addOption("p", "port", true, "listen port(s) (default = 9998)\nCan specify multiple ports with inclusive ranges (e.g. 9990-9999)\nor with comma delimited list (e.g. 9996,9998,9995)");
        options.addOption("?", "help", false, "this help message");
        options.addOption("c", "config", true, "tika-config file");
        options.addOption("i", "id", true, "id to use for server in the server status endpoint and logging");
        options.addOption("noFork", "noFork", false, "runs in legacy 1.x mode -- server runs in process and is not safely isolated in a forked process");
        return options;
    }

    public static void main(String[] args) {
        try {
            Options options = TikaServerCli.getOptions();
            DefaultParser cliParser = new DefaultParser();
            CommandLine line = cliParser.parse(options, args);
            if (line.hasOption("help")) {
                TikaServerCli.usage(options);
            }
            TikaServerConfig tikaServerConfig = TikaServerConfig.load(line);
            PREVENT_STOP = tikaServerConfig.isPreventStopMethod();
            TikaServerCli.execute(tikaServerConfig);
        }
        catch (Exception e) {
            LOG.error("Can't start: ", e);
            System.exit(-1);
        }
    }

    private static void execute(TikaServerConfig tikaServerConfig) throws Exception {
        if (tikaServerConfig.isNoFork()) {
            TikaServerCli.noFork(tikaServerConfig);
        } else {
            try {
                TikaServerCli.mainLoop(tikaServerConfig);
            }
            catch (InterruptedException e) {
                LOG.debug("interrupted", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mainLoop(TikaServerConfig tikaServerConfig) throws Exception {
        List<PortIdPair> portIdPairs = TikaServerCli.getPortIdPairs(tikaServerConfig);
        ExecutorService executorService = Executors.newFixedThreadPool(portIdPairs.size());
        ExecutorCompletionService<WatchDogResult> executorCompletionService = new ExecutorCompletionService<WatchDogResult>(executorService);
        for (PortIdPair p : portIdPairs) {
            TikaServerWatchDog watcher = new TikaServerWatchDog(p.port, p.id, tikaServerConfig);
            executorCompletionService.submit(watcher);
            WATCHERS.add(watcher);
        }
        int finished = 0;
        try {
            while (finished < portIdPairs.size()) {
                Future future = executorCompletionService.poll(1L, TimeUnit.MINUTES);
                if (future == null) continue;
                LOG.debug("main loop future is available");
                WatchDogResult result = (WatchDogResult)future.get();
                LOG.debug("main loop future: ({}); finished", (Object)result);
                ++finished;
            }
        }
        catch (InterruptedException e) {
            for (TikaServerWatchDog w : WATCHERS) {
                w.shutDown();
            }
            LOG.debug("thread interrupted", e);
        }
        finally {
            executorService.shutdownNow();
        }
    }

    public static void stop(String[] args) {
        if (PREVENT_STOP) {
            LOG.info("preventStopMethod was set to true in the server config. I'm not stopping.");
        }
        try {
            Options options = TikaServerCli.getStopOptions();
            DefaultParser cliParser = new DefaultParser();
            CommandLine line = cliParser.parse(options, args);
            LOG.debug("Seeing 'preventSystemExit' on stop's commandline; not exiting");
            if (line.hasOption("preventSystemExit")) {
                return;
            }
        }
        catch (ParseException e) {
            LOG.error("Can't parse stop arguments: ", e);
            System.exit(-1);
        }
        for (TikaServerWatchDog watcher : WATCHERS) {
            try {
                watcher.close();
            }
            catch (Exception e) {
                LOG.warn("Exception trying to close watcher", e);
            }
        }
        System.exit(0);
    }

    private static Options getStopOptions() {
        Options options = new Options();
        options.addOption("preventSystemExit", false, "Prevent the stop method from calling system.exit, which would terminate the JVM. This is useful for integration tests.");
        return options;
    }

    private static String[] stripForkedArgs(String[] args) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("-J")) continue;
            ret.add(arg);
        }
        return ret.toArray(new String[0]);
    }

    public static void noFork(TikaServerConfig tikaServerConfig) throws Exception {
        List<String> args = tikaServerConfig.getForkedProcessArgs(tikaServerConfig.getPort(), tikaServerConfig.getIdBase());
        args.add("--noFork");
        TikaServerProcess.main(args.toArray(new String[0]));
    }

    private static void usage(Options options) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("tikaserver", options);
        System.exit(-1);
    }

    private static List<PortIdPair> getPortIdPairs(TikaServerConfig tikaServerConfig) {
        ArrayList<PortIdPair> pairs = new ArrayList<PortIdPair>();
        int[] ports = tikaServerConfig.getPorts();
        if (ports.length == 0) {
            throw new IllegalArgumentException("Couldn't find any ports in: " + tikaServerConfig.getPort());
        }
        if (ports.length == 1) {
            pairs.add(new PortIdPair(ports[0], tikaServerConfig.getIdBase()));
        } else {
            for (int p : ports) {
                pairs.add(new PortIdPair(p, tikaServerConfig.getIdBase() + "-" + p));
            }
        }
        return pairs;
    }

    private static class NonForkedValues {
        String portString;
        String id;
        int maxRestarts = -1;

        private NonForkedValues() {
        }
    }

    private static class PortIdPair {
        int port;
        String id;

        public PortIdPair(int port, String id) {
            this.port = port;
            this.id = id;
        }
    }
}

