/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core;

import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.time.Instant;
import org.apache.tika.server.core.ServerStatus;
import org.apache.tika.server.core.TaskStatus;
import org.apache.tika.server.core.TikaServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerStatusWatcher
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ServerStatusWatcher.class);
    private final ServerStatus serverStatus;
    private final InputStream fromParent;
    private final TikaServerConfig tikaServerConfig;
    private final Path forkedStatusPath;
    private final ByteBuffer statusBuffer = ByteBuffer.allocate(16);
    private volatile boolean shuttingDown = false;

    public ServerStatusWatcher(ServerStatus serverStatus, InputStream inputStream, Path forkedStatusPath, TikaServerConfig tikaServerConfig) throws InterruptedException {
        this.serverStatus = serverStatus;
        this.tikaServerConfig = tikaServerConfig;
        this.forkedStatusPath = forkedStatusPath;
        serverStatus.setStatus(ServerStatus.STATUS.OPERATING);
        this.fromParent = inputStream;
        Thread statusWatcher = new Thread(new StatusWatcher());
        statusWatcher.setDaemon(true);
        statusWatcher.start();
        this.writeStatus(false);
    }

    @Override
    public void run() {
        try {
            int directive = this.fromParent.read();
            if (directive != -1) {
                LOG.debug("Read byte ({}) from forking process. Shouldn't have received anything", (Object)directive);
            }
        }
        catch (Exception e) {
            LOG.debug("Exception reading from parent", e);
        }
        finally {
            LOG.info("Forking process signalled I should shutdown.");
            this.serverStatus.setStatus(ServerStatus.STATUS.PARENT_EXCEPTION);
            this.shutdown(ServerStatus.STATUS.PARENT_EXCEPTION);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void writeStatus(boolean shuttingDown) throws InterruptedException {
        if (this.shuttingDown) {
            return;
        }
        if (shuttingDown) {
            this.shuttingDown = true;
        }
        Instant started = Instant.now();
        long elapsed = Duration.between(started, Instant.now()).toMillis();
        try (FileChannel channel = FileChannel.open(this.forkedStatusPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            while (elapsed < this.tikaServerConfig.getTaskTimeoutMillis()) {
                try {
                    FileLock lock;
                    block20: {
                        lock = channel.tryLock();
                        try {
                            if (lock == null) break block20;
                            ((Buffer)this.statusBuffer).position(0);
                            this.statusBuffer.putLong(0, Instant.now().toEpochMilli());
                            this.statusBuffer.putInt(8, this.serverStatus.getStatus().getInt());
                            this.statusBuffer.putInt(12, this.serverStatus.getTasks().size());
                            channel.write(this.statusBuffer);
                            channel.force(true);
                            if (lock == null) return;
                        }
                        catch (Throwable throwable) {
                            if (lock == null) throw throwable;
                            try {
                                lock.close();
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        lock.close();
                        return;
                    }
                    if (lock != null) {
                        lock.close();
                    }
                }
                catch (IOException e) {
                    LOG.warn("Problem writing to status file", e);
                }
                Thread.sleep(100L);
                elapsed = Duration.between(started, Instant.now()).toMillis();
            }
            throw new FatalException("Couldn't write to status file after trying for " + elapsed + " millis.");
        }
        catch (IOException e) {
            LOG.warn("Couldn't open forked status file for writing", e);
        }
        throw new FatalException("Couldn't write to status file after trying for " + elapsed + " millis.");
    }

    private void checkForHitMaxFiles() {
        if (this.tikaServerConfig.getMaxFiles() < 0L) {
            return;
        }
        long filesProcessed = this.serverStatus.getFilesProcessed();
        if (filesProcessed >= this.tikaServerConfig.getMaxFiles()) {
            this.serverStatus.setStatus(ServerStatus.STATUS.HIT_MAX_FILES);
        }
    }

    private void checkForTaskTimeouts() {
        Instant now = Instant.now();
        for (TaskStatus status : this.serverStatus.getTasks().values()) {
            long millisElapsed = Duration.between(status.started, now).toMillis();
            if (millisElapsed <= status.timeoutMillis) continue;
            this.serverStatus.setStatus(ServerStatus.STATUS.TIMEOUT);
            if (status.fileName.isPresent()) {
                LOG.error("Timeout task {}, millis elapsed {}, timeoutMillis {}, file id {}consider increasing the allowable time with the <taskTimeoutMillis/> parameter or the {} header", status.task.toString(), millisElapsed, status.timeoutMillis, status.fileName.get(), "X-Tika-Timeout-Millis");
                continue;
            }
            LOG.error("Timeout task {}, millis elapsed {}; consider increasing the allowable time with the <taskTimeoutMillis/> parameter or the {} header", status.task.toString(), millisElapsed, "X-Tika-Timeout-Millis");
        }
    }

    private void shutdown(ServerStatus.STATUS status) {
        if (status == ServerStatus.STATUS.PARENT_EXCEPTION) {
            try {
                Files.delete(this.forkedStatusPath);
            }
            catch (IOException iOException) {}
        } else {
            try {
                this.writeStatus(true);
            }
            catch (Exception e) {
                LOG.debug("problem writing status before shutdown", e);
            }
        }
        LOG.info("Shutting down forked process with status: {}", (Object)status.name());
        System.exit(status.getShutdownCode());
    }

    private class StatusWatcher
    implements Runnable {
        private StatusWatcher() {
        }

        @Override
        public void run() {
            Instant lastWrite = Instant.now();
            while (true) {
                ServerStatusWatcher.this.checkForHitMaxFiles();
                ServerStatusWatcher.this.checkForTaskTimeouts();
                ServerStatus.STATUS currStatus = ServerStatusWatcher.this.serverStatus.getStatus();
                if (currStatus != ServerStatus.STATUS.OPERATING) {
                    LOG.warn("forked process observed " + currStatus.name() + " and is shutting down.");
                    ServerStatusWatcher.this.shutdown(currStatus);
                } else {
                    long elapsed = Duration.between(lastWrite, Instant.now()).toMillis();
                    if (elapsed > ServerStatusWatcher.this.tikaServerConfig.getTaskPulseMillis()) {
                        try {
                            ServerStatusWatcher.this.writeStatus(false);
                            lastWrite = Instant.now();
                        }
                        catch (InterruptedException e) {
                            LOG.debug("interrupted", e);
                        }
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    LOG.warn("status watcher sees interrupted exception");
                    return;
                }
            }
        }
    }

    private static class FatalException
    extends RuntimeException {
        public FatalException() {
        }

        public FatalException(String msg) {
            super(msg);
        }
    }
}

