/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.tika.server.core.TaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerStatus {
    private static final Logger LOG = LoggerFactory.getLogger(ServerStatus.class);
    private final String serverId;
    private final int numRestarts;
    private final boolean isLegacy;
    private AtomicLong counter = new AtomicLong(0L);
    private Map<Long, TaskStatus> tasks = new HashMap<Long, TaskStatus>();
    private STATUS status = STATUS.OPERATING;
    private volatile long lastStarted = Instant.now().toEpochMilli();

    public ServerStatus(String serverId, int numRestarts) {
        this(serverId, numRestarts, false);
    }

    public ServerStatus(String serverId, int numRestarts, boolean isLegacy) {
        this.serverId = serverId;
        this.numRestarts = numRestarts;
        this.isLegacy = isLegacy;
    }

    public synchronized long start(TASK task, String fileName, long timeoutMillis) {
        long taskId = this.counter.incrementAndGet();
        Instant now = Instant.now();
        this.lastStarted = now.toEpochMilli();
        this.tasks.put(taskId, new TaskStatus(task, now, fileName, timeoutMillis));
        return taskId;
    }

    public synchronized void complete(long taskId) throws IllegalArgumentException {
        TaskStatus status = this.tasks.remove(taskId);
        if (status == null) {
            throw new IllegalArgumentException("TaskId is not in map:" + taskId);
        }
    }

    public synchronized STATUS getStatus() {
        return this.status;
    }

    public synchronized void setStatus(STATUS status) {
        this.status = status;
    }

    public synchronized Map<Long, TaskStatus> getTasks() {
        return new HashMap<Long, TaskStatus>(this.tasks);
    }

    public synchronized long getFilesProcessed() {
        return this.counter.get();
    }

    public long getMillisSinceLastParseStarted() {
        return Instant.now().toEpochMilli() - this.lastStarted;
    }

    public synchronized boolean isOperating() {
        if (this.isLegacy) {
            return true;
        }
        return this.status == STATUS.OPERATING;
    }

    public String getServerId() {
        return this.serverId;
    }

    public int getNumRestarts() {
        return this.numRestarts;
    }

    public static enum TASK {
        PARSE,
        DETECT,
        TRANSLATE;

    }

    public static enum STATUS {
        INITIALIZING(0),
        OPERATING(1),
        HIT_MAX_FILES(2),
        TIMEOUT(3),
        ERROR(4),
        PARENT_REQUESTED_SHUTDOWN(5),
        PARENT_EXCEPTION(6),
        OFF(7);

        private final int shutdownCode;

        private STATUS(int shutdownCode) {
            this.shutdownCode = shutdownCode;
        }

        static STATUS lookup(int i) {
            STATUS[] values = STATUS.values();
            if (i < 0 || i >= values.length) {
                throw new ArrayIndexOutOfBoundsException(i + " is not acceptable for an array of length " + values.length);
            }
            return STATUS.values()[i];
        }

        int getShutdownCode() {
            return this.shutdownCode;
        }

        int getInt() {
            return this.shutdownCode;
        }
    }

    static enum DIRECTIVES {
        PING(0),
        PING_ACTIVE_SERVER_TASKS(1),
        SHUTDOWN(2);

        private final byte b;

        private DIRECTIVES(byte b) {
            this.b = b;
        }

        byte getByte() {
            return this.b;
        }
    }
}

