/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core;

import jakarta.ws.rs.core.MediaType;
import java.util.Arrays;
import java.util.List;
import org.apache.cxf.jaxrs.ext.ResourceComparator;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProduceTypeResourceComparator
implements ResourceComparator {
    public static final List<MediaType> PRIORITIZED_MEDIA_LIST = Arrays.asList(MediaType.TEXT_PLAIN_TYPE, MediaType.APPLICATION_JSON_TYPE, MediaType.TEXT_HTML_TYPE, MediaType.TEXT_XML_TYPE);
    private static final Logger LOG = LoggerFactory.getLogger(ProduceTypeResourceComparator.class);

    @Override
    public int compare(ClassResourceInfo cri1, ClassResourceInfo cri2, Message message) {
        return 0;
    }

    @Override
    public int compare(OperationResourceInfo oper1, OperationResourceInfo oper2, Message message) {
        String httpMethod = (String)message.get("org.apache.cxf.request.method");
        MediaType contentType = JAXRSUtils.toMediaType((String)message.get("Content-Type"));
        List<MediaType> acceptTypes = JAXRSUtils.parseMediaTypes((String)message.get("Accept"));
        LOG.debug("Message Method : " + httpMethod + ", ContentType : " + String.valueOf(contentType) + ", Accept Types : " + String.valueOf(acceptTypes));
        int result = this.compareProduceTypes(oper1, oper2, acceptTypes);
        String m1Name = oper1.getClassResourceInfo().getServiceClass().getName() + "#" + oper1.getMethodToInvoke().getName();
        String m2Name = oper2.getClassResourceInfo().getServiceClass().getName() + "#" + oper2.getMethodToInvoke().getName();
        if (result != 0) {
            String chosen = result == -1 ? m1Name : m2Name;
            LOG.debug("Between " + m1Name + " and " + m2Name + ", " + chosen + " is chosen for handling the current request");
        }
        return result;
    }

    private int compareProduceTypes(OperationResourceInfo oper1, OperationResourceInfo oper2, List<MediaType> acceptTypes) {
        List<MediaType> op1Matched = JAXRSUtils.intersectMimeTypes(acceptTypes, oper1.getProduceTypes(), true);
        List<MediaType> op2Matched = JAXRSUtils.intersectMimeTypes(acceptTypes, oper2.getProduceTypes(), true);
        int oper1Priority = op1Matched.stream().mapToInt(PRIORITIZED_MEDIA_LIST::indexOf).max().getAsInt();
        int oper2Priority = op2Matched.stream().mapToInt(PRIORITIZED_MEDIA_LIST::indexOf).max().getAsInt();
        return oper1Priority == oper2Priority ? 0 : (oper1Priority > oper2Priority ? -1 : 1);
    }
}

