/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;

public class HTMLHelper {
    private static final String PATH = "/tikaserver-template.html";
    private static final String TITLE_VAR = "[[TITLE]]";
    private static final String BODY_VAR = "[[BODY]]";
    private String PRE_BODY;
    private String POST_BODY;

    public HTMLHelper() {
        try (InputStream htmlStr = this.getClass().getResourceAsStream(PATH);){
            if (htmlStr == null) {
                throw new IllegalArgumentException("Template Not Found - /tikaserver-template.html");
            }
            String html = IOUtils.toString(htmlStr, StandardCharsets.UTF_8);
            int bodyAt = html.indexOf(BODY_VAR);
            this.PRE_BODY = html.substring(0, bodyAt);
            this.POST_BODY = html.substring(bodyAt + BODY_VAR.length());
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read template");
        }
    }

    public void generateHeader(StringBuffer html, String title) {
        html.append(this.PRE_BODY.replace(TITLE_VAR, title));
    }

    public void generateFooter(StringBuffer html) {
        html.append(this.POST_BODY);
    }
}

