/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core;

import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.pipes.fetcher.Fetcher;
import org.apache.tika.pipes.fetcher.FetcherManager;
import org.apache.tika.pipes.fetcher.RangeFetcher;
import org.apache.tika.server.core.InputStreamFactory;
import org.apache.tika.server.core.resource.TikaResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetcherStreamFactory
implements InputStreamFactory {
    private static final Logger LOG = LoggerFactory.getLogger(FetcherStreamFactory.class);
    private final FetcherManager fetcherManager;

    public FetcherStreamFactory(FetcherManager fetcherManager) {
        this.fetcherManager = fetcherManager;
    }

    private static long getLong(String val) {
        if (StringUtils.isBlank(val)) {
            return -1L;
        }
        return Long.parseLong(val);
    }

    @Override
    public InputStream getInputStream(InputStream is, Metadata metadata, HttpHeaders httpHeaders, UriInfo uriInfo) throws IOException {
        MultivaluedMap<String, String> params = uriInfo == null ? null : uriInfo.getQueryParameters();
        String fetcherName = this.getParam("fetcherName", httpHeaders, params);
        String fetchKey = this.getParam("fetchKey", httpHeaders, params);
        if (StringUtils.isBlank(fetchKey = this.urlDecode(fetchKey))) {
            fetchKey = this.getParam("fetchKeyLiteral", httpHeaders, params);
        }
        ParseContext parseContext = new ParseContext();
        TikaResource.fillParseContext(httpHeaders.getRequestHeaders(), metadata, parseContext);
        long fetchRangeStart = FetcherStreamFactory.getLong(this.getParam("fetchRangeStart", httpHeaders, params));
        long fetchRangeEnd = FetcherStreamFactory.getLong(this.getParam("fetchRangeEnd", httpHeaders, params));
        if (StringUtils.isBlank(fetcherName) != StringUtils.isBlank(fetchKey)) {
            throw new IOException("Must specify both a 'fetcherName' and a 'fetchKey'. I see:  fetcherName:" + fetcherName + " and fetchKey:" + fetchKey);
        }
        if (fetchRangeStart < 0L && fetchRangeEnd > -1L) {
            throw new IllegalArgumentException("fetchRangeStart must be > -1 if a fetchRangeEnd is specified");
        }
        if (fetchRangeStart > -1L && fetchRangeEnd < 0L) {
            throw new IllegalArgumentException("fetchRangeEnd must be > -1 if a fetchRangeStart is specified");
        }
        if (!StringUtils.isBlank(fetcherName)) {
            try {
                LOG.debug("going to fetch '{}' from fetcher: {}", (Object)fetchKey, (Object)fetcherName);
                Fetcher fetcher = this.fetcherManager.getFetcher(fetcherName);
                if (fetchRangeStart > -1L && fetchRangeEnd > -1L && !(fetcher instanceof RangeFetcher)) {
                    throw new IllegalArgumentException("Can't call a fetch with a range on a fetcher that is not a RangeFetcher: name=" + fetcher.getName() + " class=" + String.valueOf(fetcher.getClass()));
                }
                return fetcher.fetch(fetchKey, metadata, parseContext);
            }
            catch (TikaException e) {
                throw new IOException(e);
            }
        }
        return is;
    }

    private String urlDecode(String fetchKey) {
        if (fetchKey == null) {
            return fetchKey;
        }
        try {
            return URLDecoder.decode(fetchKey, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException | IllegalArgumentException e) {
            LOG.warn("couldn't decode fetch key {}", (Object)fetchKey);
            return fetchKey;
        }
    }

    private String getParam(String paramName, HttpHeaders httpHeaders, MultivaluedMap uriParams) {
        if (uriParams == null || !uriParams.containsKey(paramName)) {
            return httpHeaders.getHeaderString(paramName);
        }
        return (String)uriParams.getFirst(paramName);
    }
}

