/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.tika.server.core.CXFTestBase;
import org.apache.tika.server.core.ServerStatus;
import org.apache.tika.server.core.resource.TikaServerStatus;
import org.apache.tika.server.core.writer.JSONObjWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TikaServerStatusTest
extends CXFTestBase {
    private static final String STATUS_PATH = "/status";
    private static final String SERVER_ID = UUID.randomUUID().toString();

    @Override
    protected void setUpResources(JAXRSServerFactoryBean sf) {
        sf.setResourceClasses(new Class[]{TikaServerStatus.class});
        sf.setResourceProvider(TikaServerStatus.class, (ResourceProvider)new SingletonResourceProvider((Object)new TikaServerStatus(new ServerStatus(SERVER_ID, 0))));
    }

    @Override
    protected void setUpProviders(JAXRSServerFactoryBean sf) {
        ArrayList<JSONObjWriter> providers = new ArrayList<JSONObjWriter>();
        providers.add(new JSONObjWriter());
        sf.setProviders(providers);
    }

    @Test
    public void testBasic() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/status").get();
        String jsonString = TikaServerStatusTest.getStringFromInputStream((InputStream)response.getEntity());
        JsonNode root = new ObjectMapper().readTree(jsonString);
        Assertions.assertTrue((boolean)root.has("server_id"));
        Assertions.assertTrue((boolean)root.has("status"));
        Assertions.assertTrue((boolean)root.has("millis_since_last_parse_started"));
        Assertions.assertTrue((boolean)root.has("files_processed"));
        Assertions.assertEquals((Object)"OPERATING", (Object)root.get("status").asText());
        Assertions.assertEquals((int)0, (int)root.get("files_processed").intValue());
        long millis = root.get("millis_since_last_parse_started").longValue();
        Assertions.assertTrue((millis >= 0L && millis < 360000L ? 1 : 0) != 0);
        Assertions.assertEquals((Object)SERVER_ID, (Object)root.get("server_id").asText());
    }
}

