/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.jsse.TLSParameterJaxBUtils;
import org.apache.cxf.configuration.security.KeyManagersType;
import org.apache.cxf.configuration.security.KeyStoreType;
import org.apache.cxf.configuration.security.TrustManagersType;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.serialization.JsonMetadataList;
import org.apache.tika.server.core.CXFTestBase;
import org.apache.tika.server.core.IntegrationTestBase;
import org.apache.tika.server.core.TikaServerCli;
import org.apache.tika.utils.ProcessUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TikaServerIntegrationTest
extends IntegrationTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(TikaServerIntegrationTest.class);
    private static Path TLS_KEYS;
    @TempDir
    private static Path TLS_CONFIG;
    private static Path TIKA_TLS_ONE_WAY_CONFIG;
    private static Path TIKA_TLS_TWO_WAY_CONFIG;

    @BeforeAll
    public static void setUpSSL() throws Exception {
        TLS_KEYS = Paths.get(TikaServerIntegrationTest.class.getResource("/ssl-keys").toURI());
        String xml = IOUtils.resourceToString((String)"/configs/tika-config-server-tls-two-way-template.xml", (Charset)StandardCharsets.UTF_8);
        xml = xml.replace("{SSL_KEYS}", TLS_KEYS.toAbsolutePath().toString());
        TIKA_TLS_TWO_WAY_CONFIG = Files.createTempFile(TLS_CONFIG, "tika-config-tls-", ".xml", new FileAttribute[0]);
        Files.write(TIKA_TLS_TWO_WAY_CONFIG, xml.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        xml = IOUtils.resourceToString((String)"/configs/tika-config-server-tls-one-way-template.xml", (Charset)StandardCharsets.UTF_8);
        xml = xml.replace("{SSL_KEYS}", TLS_KEYS.toAbsolutePath().toString());
        TIKA_TLS_ONE_WAY_CONFIG = Files.createTempFile(TLS_CONFIG, "tika-config-tls-", ".xml", new FileAttribute[0]);
        Files.write(TIKA_TLS_ONE_WAY_CONFIG, xml.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    @Test
    public void testBasic() throws Exception {
        this.startProcess(new String[]{"-config", this.getConfig("tika-config-server-basic.xml")});
        this.testBaseline();
    }

    @Test
    public void testOOM() throws Exception {
        this.startProcess(new String[]{"-config", this.getConfig("tika-config-server-basic.xml")});
        this.awaitServerStartup();
        Response response = null;
        try {
            response = WebClient.create((String)"http://localhost:9999/rmeta").accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/mock/fake_oom.xml"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Thread.sleep(2000L);
        this.testBaseline();
    }

    @Test
    public void testSameServerIdAfterOOM() throws Exception {
        this.startProcess(new String[]{"-config", this.getConfig("tika-config-server-basic.xml")});
        this.awaitServerStartup();
        String serverId = this.getServerId();
        Response response = null;
        try {
            response = WebClient.create((String)"http://localhost:9999/rmeta").accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/mock/fake_oom.xml"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Thread.sleep(2000L);
        this.testBaseline();
        Assertions.assertEquals((Object)serverId, (Object)this.getServerId());
        Assertions.assertTrue((this.getNumRestarts() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.getNumRestarts() < 3 ? 1 : 0) != 0);
    }

    @Test
    public void testMinimumTimeoutInHeader() throws Exception {
        this.startProcess(new String[]{"-config", this.getConfig("tika-config-server-basic.xml")});
        this.awaitServerStartup();
        Response response = WebClient.create((String)"http://localhost:9999/rmeta").accept(new String[]{"application/json"}).header("X-Tika-Timeout-Millis", new Object[]{1}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/mock/heavy_hang_30000.xml"));
        Assertions.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatus());
    }

    @Test
    public void testTaskTimeoutHeader() throws Exception {
        this.startProcess(new String[]{"-config", this.getConfig("tika-config-server-basic.xml")});
        this.awaitServerStartup();
        String serverId = this.getServerId();
        Response response = null;
        try {
            response = WebClient.create((String)"http://localhost:9999/rmeta").accept(new String[]{"application/json"}).header("X-Tika-Timeout-Millis", new Object[]{100}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/mock/heavy_hang_30000.xml"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Thread.sleep(2000L);
        this.testBaseline();
        Assertions.assertEquals((Object)serverId, (Object)this.getServerId());
        Assertions.assertTrue((this.getNumRestarts() > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.getNumRestarts() < 3 ? 1 : 0) != 0);
    }

    @Test
    public void testSameDeclaredServerIdAfterOOM() throws Exception {
        String serverId = "qwertyuiop";
        this.startProcess(new String[]{"-config", this.getConfig("tika-config-server-basic.xml"), "-id", serverId});
        this.awaitServerStartup();
        Response response = null;
        try {
            response = WebClient.create((String)"http://localhost:9999/rmeta").accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/mock/fake_oom.xml"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Thread.sleep(2000L);
        this.testBaseline();
        Assertions.assertEquals((Object)serverId, (Object)this.getServerId());
    }

    private String getServerId() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9999/status").accept(new String[]{"application/json"}).get();
        String jsonString = CXFTestBase.getStringFromInputStream((InputStream)response.getEntity());
        JsonNode root = new ObjectMapper().readTree(jsonString);
        return root.get("server_id").asText();
    }

    private int getNumRestarts() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9999/status").accept(new String[]{"application/json"}).get();
        String jsonString = CXFTestBase.getStringFromInputStream((InputStream)response.getEntity());
        JsonNode root = new ObjectMapper().readTree(jsonString);
        return root.get("num_restarts").intValue();
    }

    @Test
    public void testSystemExit() throws Exception {
        this.startProcess(new String[]{"-config", this.getConfig("tika-config-server-basic.xml")});
        this.awaitServerStartup();
        Response response = null;
        try {
            response = WebClient.create((String)"http://localhost:9999/rmeta").accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/mock/system_exit.xml"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Thread.sleep(2000L);
        this.testBaseline();
    }

    @Test
    public void testTimeoutOk() throws Exception {
        this.startProcess(new String[]{"-config", this.getConfig("tika-config-server-timeout-10000.xml")});
        this.awaitServerStartup();
        Response response = null;
        try {
            response = WebClient.create((String)"http://localhost:9999/rmeta").accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/mock/heavy_hang_100.xml"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.testBaseline();
    }

    @Test
    @Timeout(value=60000L)
    public void testTimeout() throws Exception {
        this.startProcess(new String[]{"-config", this.getConfig("tika-config-server-timeout-10000.xml")});
        this.awaitServerStartup();
        Response response = null;
        try {
            response = WebClient.create((String)"http://localhost:9999/rmeta").accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/mock/heavy_hang_30000.xml"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.testBaseline();
    }

    @Test
    public void testBadJVMArgs() throws Exception {
        String os;
        this.startProcess(new String[]{"-config", this.getConfig("tika-config-server-badjvmargs.xml")});
        boolean finished = this.process.waitFor(10000L, TimeUnit.MILLISECONDS);
        if (!finished) {
            Assertions.fail((String)"should have completed by now");
        }
        if ((os = System.getProperty("os.name")).startsWith("Windows")) {
            Assertions.assertEquals((int)-1, (int)this.process.exitValue());
        } else {
            Assertions.assertEquals((int)255, (int)this.process.exitValue());
        }
    }

    private String getConfig(String configName) {
        try {
            return ProcessUtils.escapeCommandLine((String)Paths.get(TikaServerIntegrationTest.class.getResource("/configs/" + configName).toURI()).toAbsolutePath().toString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private String getSSL(String file) {
        try {
            return Paths.get(TikaServerIntegrationTest.class.getResource("/ssl-keys/" + file).toURI()).toAbsolutePath().toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testStdErrOutBasic() throws Exception {
        this.startProcess(new String[]{"-config", this.getConfig("tika-config-server-timeout-10000.xml")});
        this.awaitServerStartup();
        Response response = WebClient.create((String)"http://localhost:9999/rmeta").accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/mock/testStdOutErr.xml"));
        InputStreamReader reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        List metadataList = JsonMetadataList.fromJson((Reader)reader);
        Assertions.assertEquals((int)1, (int)metadataList.size());
        TikaServerIntegrationTest.assertContains((String)"quick brown fox", (String)((Metadata)metadataList.get(0)).get("X-TIKA:content"));
        this.testBaseline();
    }

    @Test
    public void test1WayTLS() throws Exception {
        this.startProcess(new String[]{"-config", ProcessUtils.escapeCommandLine((String)TIKA_TLS_ONE_WAY_CONFIG.toAbsolutePath().toString())});
        String httpsEndpoint = "https://localhost:9999";
        WebClient webClient = WebClient.create((String)httpsEndpoint);
        this.configure1WayTLS(webClient);
        this.awaitServerStartup(webClient);
        webClient.close();
        webClient = WebClient.create((String)(httpsEndpoint + "/rmeta"));
        this.configure1WayTLS(webClient);
        Response response = webClient.accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/mock/hello_world.xml"));
        InputStreamReader reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        List metadataList = JsonMetadataList.fromJson((Reader)reader);
        Assertions.assertEquals((int)1, (int)metadataList.size());
        Assertions.assertEquals((Object)"Nikolai Lobachevsky", (Object)((Metadata)metadataList.get(0)).get("author"));
        TikaServerIntegrationTest.assertContains((String)"hello world", (String)((Metadata)metadataList.get(0)).get("X-TIKA:content"));
        webClient = WebClient.create((String)(httpsEndpoint + "/rmeta"));
        try {
            response = webClient.accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/mock/hello_world.xml"));
            Assertions.fail((String)"bad, bad, bad. this should have failed!");
        }
        catch (Exception e) {
            TikaServerIntegrationTest.assertContains((String)"javax.net.ssl.SSLHandshakeException", (String)e.getMessage());
        }
    }

    @Test
    public void test2WayTLS() throws Exception {
        this.startProcess(new String[]{"-config", ProcessUtils.escapeCommandLine((String)TIKA_TLS_TWO_WAY_CONFIG.toAbsolutePath().toString())});
        String httpsEndpoint = "https://localhost:9999";
        WebClient webClient = WebClient.create((String)httpsEndpoint);
        this.configure2WayTLS(webClient);
        this.awaitServerStartup(webClient);
        webClient.close();
        webClient = WebClient.create((String)(httpsEndpoint + "/rmeta"));
        this.configure2WayTLS(webClient);
        Response response = webClient.accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/mock/hello_world.xml"));
        InputStreamReader reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        List metadataList = JsonMetadataList.fromJson((Reader)reader);
        Assertions.assertEquals((int)1, (int)metadataList.size());
        Assertions.assertEquals((Object)"Nikolai Lobachevsky", (Object)((Metadata)metadataList.get(0)).get("author"));
        TikaServerIntegrationTest.assertContains((String)"hello world", (String)((Metadata)metadataList.get(0)).get("X-TIKA:content"));
        webClient = WebClient.create((String)(httpsEndpoint + "/rmeta"));
        try {
            response = webClient.accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/mock/hello_world.xml"));
            Assertions.fail((String)"bad, bad, bad. this should have failed!");
        }
        catch (Exception e) {
            TikaServerIntegrationTest.assertContains((String)"javax.net.ssl.SSLHandshakeException", (String)e.getMessage());
        }
        webClient = WebClient.create((String)(httpsEndpoint + "/rmeta"));
        this.configure1WayTLS(webClient);
        try {
            response = webClient.accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/mock/hello_world.xml"));
            Assertions.fail((String)"bad, bad, bad. this should have failed!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void configure2WayTLS(WebClient webClient) throws GeneralSecurityException, IOException {
        HTTPConduit conduit = WebClient.getConfig((Object)webClient).getHttpConduit();
        KeyStoreType keystore = new KeyStoreType();
        keystore.setType("PKCS12");
        keystore.setPassword("tika-secret");
        keystore.setFile(this.getSSL("tika-client-keystore.p12"));
        KeyManagersType kmt = new KeyManagersType();
        kmt.setKeyStore(keystore);
        kmt.setKeyPassword("tika-secret");
        TLSClientParameters parameters = new TLSClientParameters();
        parameters.setKeyManagers(TLSParameterJaxBUtils.getKeyManagers((KeyManagersType)kmt));
        KeyStoreType trustKeyStore = new KeyStoreType();
        trustKeyStore.setType("PKCS12");
        trustKeyStore.setPassword("tika-secret");
        trustKeyStore.setFile(this.getSSL("tika-client-truststore.p12"));
        TrustManagersType tmt = new TrustManagersType();
        tmt.setKeyStore(trustKeyStore);
        parameters.setTrustManagers(TLSParameterJaxBUtils.getTrustManagers((TrustManagersType)tmt, (boolean)true));
        conduit.setTlsClientParameters(parameters);
    }

    private void configure1WayTLS(WebClient webClient) throws GeneralSecurityException, IOException {
        HTTPConduit conduit = WebClient.getConfig((Object)webClient).getHttpConduit();
        TLSClientParameters parameters = new TLSClientParameters();
        KeyStoreType trustKeyStore = new KeyStoreType();
        trustKeyStore.setType("PKCS12");
        trustKeyStore.setPassword("tika-secret");
        trustKeyStore.setFile(this.getSSL("tika-client-truststore.p12"));
        TrustManagersType tmt = new TrustManagersType();
        tmt.setKeyStore(trustKeyStore);
        parameters.setTrustManagers(TLSParameterJaxBUtils.getTrustManagers((TrustManagersType)tmt, (boolean)true));
        conduit.setTlsClientParameters(parameters);
    }

    @Test
    @Disabled(value="This works, but prints too much junk to the console.  Figure out how to gobble/redirect.")
    public void testStaticStdErrOutBasic() throws Exception {
        this.startProcess(new String[]{"-config", this.getConfig("tika-config-server-timeout-10000.xml")});
        this.awaitServerStartup();
        Response response = WebClient.create((String)"http://localhost:9999/rmeta").accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/mock/testStaticStdOutErr.xml"));
        InputStreamReader reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        List metadataList = JsonMetadataList.fromJson((Reader)reader);
        Assertions.assertEquals((int)1, (int)metadataList.size());
        TikaServerIntegrationTest.assertContains((String)"quick brown fox", (String)((Metadata)metadataList.get(0)).get("X-TIKA:content"));
        this.testBaseline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Disabled(value="TODO needs to write dynamic config file w logfile location")
    @Test
    public void testStdErrOutLogging() throws Exception {
        AtomicInteger i = new AtomicInteger();
        Thread serverThread = new Thread(() -> TikaServerCli.main((String[])new String[]{"-p", "9999", "-taskTimeoutMillis", "10000", "-taskPulseMillis", "500", "-pingPulseMillis", "100", "-maxRestarts", "0", "-JDlog4j.configuration=file:" + String.valueOf(LOG_FILE.toAbsolutePath()), "-tmpFilePrefix", "tika-server-stderrlogging"}));
        serverThread.start();
        this.awaitServerStartup();
        Response response = WebClient.create((String)"http://localhost:9999/rmeta").accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/mock/testStdOutErr.xml"));
        InputStreamReader reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        List metadataList = JsonMetadataList.fromJson((Reader)reader);
        Assertions.assertEquals((int)1, (int)metadataList.size());
        TikaServerIntegrationTest.assertContains((String)"quick brown fox", (String)((Metadata)metadataList.get(0)).get("X-TIKA:content"));
        try {
            this.testBaseline();
        }
        finally {
            serverThread.interrupt();
        }
    }

    @Test
    @Disabled(value="figure out how to test this with the forked process")
    public void testSystemExitViaStopMethod() throws Exception {
        Thread serverThread = new Thread(){

            @Override
            public void run() {
                TikaServerCli.main((String[])new String[]{"-p", "9999"});
            }

            @Override
            public void interrupt() {
                TikaServerCli.stop((String[])new String[]{"-preventSystemExit"});
            }
        };
        serverThread.start();
        this.awaitServerStartup();
        serverThread.interrupt();
        Thread.sleep(2000L);
        try {
            this.testBaseline();
        }
        finally {
            serverThread.interrupt();
        }
    }

    @Test
    @Disabled(value="turn this into a real test")
    public void testMaxFiles() throws Exception {
        this.startProcess(new String[]{"-config", this.getConfig("tika-config-server-timeout-10000.xml")});
        this.awaitServerStartup();
        Random r = new Random();
        for (int i = 0; i < 100; ++i) {
            boolean ex = false;
            Response response = null;
            String file = "test-documents/mock/hello_world.xml";
            try {
                if ((double)r.nextFloat() < 0.01) {
                    file = "test-documents/mock/system_exit.xml";
                } else if ((double)r.nextFloat() < 0.015) {
                    file = "test-documents/mock/fake_oom.xml";
                } else if ((double)r.nextFloat() < 0.02) {
                    file = "test-documents/mock/heavy_hang_30000.xml";
                }
                response = WebClient.create((String)"http://localhost:9999/rmeta").accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream(file));
            }
            catch (Exception e) {
                ex = true;
            }
            if (ex || response.getStatus() != 200) {
                --i;
                this.awaitServerStartup();
                continue;
            }
            if (!file.equals("test-documents/mock/hello_world.xml")) continue;
            InputStreamReader reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
            List metadataList = JsonMetadataList.fromJson((Reader)reader);
            Assertions.assertEquals((int)1, (int)metadataList.size());
            Assertions.assertEquals((Object)"Nikolai Lobachevsky", (Object)((Metadata)metadataList.get(0)).get("author"));
            TikaServerIntegrationTest.assertContains((String)"hello world", (String)((Metadata)metadataList.get(0)).get("X-TIKA:content"));
        }
    }

    private void testBaseline() throws Exception {
        int maxTries = 3;
        int tries = 0;
        while (++tries < maxTries) {
            this.awaitServerStartup();
            Response response = null;
            try {
                response = WebClient.create((String)"http://localhost:9999/rmeta").accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/mock/hello_world.xml"));
            }
            catch (ProcessingException e) {
                continue;
            }
            if (response.getStatus() == 503) continue;
            InputStreamReader reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
            List metadataList = JsonMetadataList.fromJson((Reader)reader);
            Assertions.assertEquals((int)1, (int)metadataList.size());
            Assertions.assertEquals((Object)"Nikolai Lobachevsky", (Object)((Metadata)metadataList.get(0)).get("author"));
            TikaServerIntegrationTest.assertContains((String)"hello world", (String)((Metadata)metadataList.get(0)).get("X-TIKA:content"));
            return;
        }
        Assertions.fail((String)"should have completed within 3 tries");
    }
}

