/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.tika.config.TikaConfigTest;
import org.apache.tika.server.core.TikaServerConfig;
import org.apache.tika.server.core.TlsConfig;
import org.apache.tika.utils.ProcessUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TikaServerConfigTest {
    @Test
    public void testBasic() throws Exception {
        HashSet settings = new HashSet();
        DefaultParser parser = new DefaultParser();
        CommandLine emptyCommandLine = parser.parse(new Options(), new String[0]);
        Path path = Paths.get(TikaConfigTest.class.getResource("/configs/tika-config-server.xml").toURI());
        TikaServerConfig config = TikaServerConfig.load((Path)path, (CommandLine)emptyCommandLine, settings);
        Assertions.assertEquals((int)-1, (int)config.getMaxRestarts());
        Assertions.assertEquals((long)54321L, (long)config.getTaskTimeoutMillis());
        Assertions.assertEquals((Object)true, (Object)config.isEnableUnsecureFeatures());
        Assertions.assertTrue((boolean)settings.contains("taskTimeoutMillis"));
        Assertions.assertTrue((boolean)settings.contains("enableUnsecureFeatures"));
    }

    @Test
    public void testSupportedFetchersEmitters() throws Exception {
        HashSet settings = new HashSet();
        DefaultParser parser = new DefaultParser();
        CommandLine emptyCommandLine = parser.parse(new Options(), new String[0]);
        Path path = Paths.get(TikaConfigTest.class.getResource("/configs/tika-config-server-fetchers-emitters.xml").toURI());
        TikaServerConfig config = TikaServerConfig.load((Path)path, (CommandLine)emptyCommandLine, settings);
        Assertions.assertEquals((int)-1, (int)config.getMaxRestarts());
        Assertions.assertEquals((long)54321L, (long)config.getTaskTimeoutMillis());
        Assertions.assertEquals((Object)true, (Object)config.isEnableUnsecureFeatures());
        Assertions.assertEquals((int)1, (int)config.getSupportedFetchers().size());
        Assertions.assertEquals((int)1, (int)config.getSupportedEmitters().size());
        Assertions.assertTrue((boolean)config.getSupportedFetchers().contains("fsf"));
        Assertions.assertTrue((boolean)config.getSupportedEmitters().contains("fse"));
    }

    @Test
    public void testPorts() throws Exception {
        DefaultParser parser = new DefaultParser();
        Path path = Paths.get(TikaConfigTest.class.getResource("/configs/tika-config-server.xml").toURI());
        CommandLine commandLine = parser.parse(new Options().addOption(Option.builder((String)"p").longOpt("port").hasArg().build()).addOption(Option.builder((String)"c").longOpt("config").hasArg().build()), new String[]{"-p", "9994-9999", "-c", ProcessUtils.escapeCommandLine((String)path.toAbsolutePath().toString())});
        TikaServerConfig config = TikaServerConfig.load((CommandLine)commandLine);
        int[] ports = config.getPorts();
        Assertions.assertEquals((int)6, (int)ports.length);
        Assertions.assertEquals((int)9994, (int)ports[0]);
        Assertions.assertEquals((int)9999, (int)ports[5]);
    }

    @Test
    public void testTlsConfig() throws Exception {
        HashSet settings = new HashSet();
        DefaultParser parser = new DefaultParser();
        CommandLine emptyCommandLine = parser.parse(new Options(), new String[0]);
        Path path = Paths.get(TikaConfigTest.class.getResource("/configs/tika-config-server-tls.xml").toURI());
        TikaServerConfig config = TikaServerConfig.load((Path)path, (CommandLine)emptyCommandLine, settings);
        TlsConfig tlsConfig = config.getTlsConfig();
        Assertions.assertTrue((boolean)tlsConfig.isActive());
        Assertions.assertFalse((boolean)tlsConfig.isClientAuthenticationWanted());
        Assertions.assertFalse((boolean)tlsConfig.isClientAuthenticationRequired());
        Assertions.assertEquals((Object)"myType", (Object)tlsConfig.getKeyStoreType());
        Assertions.assertEquals((Object)"pass", (Object)tlsConfig.getKeyStorePassword());
        Assertions.assertEquals((Object)"/something/or/other", (Object)tlsConfig.getKeyStoreFile());
        Assertions.assertEquals((Object)"myType2", (Object)tlsConfig.getTrustStoreType());
        Assertions.assertEquals((Object)"pass2", (Object)tlsConfig.getTrustStorePassword());
        Assertions.assertEquals((Object)"/something/or/other2", (Object)tlsConfig.getTrustStoreFile());
    }

    @Test
    public void testInterpolation() throws Exception {
        ArrayList<String> input = new ArrayList<String>();
        System.setProperty("logpath", "qwertyuiop");
        System.setProperty("logslash", "qwerty\\uiop");
        try {
            input.add("-Dlogpath=\"${sys:logpath}\"");
            input.add("-Dlogpath=no-interpolation");
            input.add("-Xlogpath=\"${sys:logpath}\"");
            input.add("-Dlogpath=\"${sys:logslash}\"");
            List output = TikaServerConfig.interpolateSysProps(input);
            Assertions.assertEquals((Object)"-Dlogpath=\"qwertyuiop\"", output.get(0));
            Assertions.assertEquals((Object)"-Dlogpath=no-interpolation", output.get(1));
            Assertions.assertEquals((Object)"-Xlogpath=\"${sys:logpath}\"", output.get(2));
            Assertions.assertEquals((Object)"-Dlogpath=\"qwerty\\uiop\"", output.get(3));
        }
        finally {
            System.clearProperty("logpath");
            System.clearProperty("logslash");
        }
    }
}

