/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core;

import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.cxf.attachment.AttachmentUtil;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.serialization.JsonMetadata;
import org.apache.tika.server.core.CXFTestBase;
import org.apache.tika.server.core.TikaServerParseExceptionMapper;
import org.apache.tika.server.core.resource.TikaResource;
import org.apache.tika.server.core.writer.JSONMessageBodyWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TikaResourceTest
extends CXFTestBase {
    public static final String TEST_HELLO_WORLD = "test-documents/mock/hello_world.xml";
    public static final String TEST_HELLO_WORLD_LONG = "test-documents/mock/hello_world_long.xml";
    public static final String TEST_NULL_POINTER = "test-documents/mock/null_pointer.xml";
    public static final String TEST_OOM = "test-documents/mock/fake_oom.xml";
    private static final String STREAM_CLOSED_FAULT = "java.io.IOException: Stream Closed";
    private static final String TIKA_PATH = "/tika";
    private static final int UNPROCESSEABLE = 422;

    @Override
    protected void setUpResources(JAXRSServerFactoryBean sf) {
        sf.setResourceClasses(new Class[]{TikaResource.class});
        sf.setResourceProvider(TikaResource.class, (ResourceProvider)new SingletonResourceProvider((Object)new TikaResource()));
    }

    @Override
    protected void setUpProviders(JAXRSServerFactoryBean sf) {
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new TikaServerParseExceptionMapper(false));
        providers.add(new JSONMessageBodyWriter());
        sf.setProviders(providers);
    }

    @Test
    public void testHelloWorld() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/tika").type("text/plain").accept(new String[]{"text/plain"}).get();
        Assertions.assertEquals((Object)TikaResource.GREETING, (Object)TikaResourceTest.getStringFromInputStream((InputStream)response.getEntity()));
    }

    @Test
    public void testHeaders() throws Exception {
        MultivaluedHashMap map = new MultivaluedHashMap();
        map.addAll((Object)"meta_mymeta", (Object[])new String[]{"first", "second", "third"});
        Response response = WebClient.create((String)"http://localhost:9998/tika").headers((MultivaluedMap)map).accept(new String[]{"text/xml"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_HELLO_WORLD));
        String xml = TikaResourceTest.getStringFromInputStream((InputStream)response.getEntity());
        TikaResourceTest.assertContains("<meta name=\"mymeta\" content=\"first,second,third\"/>", xml);
    }

    @Test
    public void testJAXBAndActivationDependency() {
        AttachmentUtil.getCommandMap();
    }

    @Test
    public void testOOMInLegacyMode() throws Exception {
        Response response = null;
        try {
            response = WebClient.create((String)"http://localhost:9998/tika").accept(new String[]{"text/plain"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_OOM));
        }
        catch (Exception exception) {
            // empty catch block
        }
        response = WebClient.create((String)"http://localhost:9998/tika").accept(new String[]{"text/plain"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_HELLO_WORLD));
        String responseMsg = TikaResourceTest.getStringFromInputStream((InputStream)response.getEntity());
        TikaResourceTest.assertContains("hello world", responseMsg);
    }

    @Test
    public void testApplicationWadl() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/tika?_wadl").accept(new String[]{"text/plain"}).get();
        String resp = TikaResourceTest.getStringFromInputStream((InputStream)response.getEntity());
        Assertions.assertTrue((boolean)resp.startsWith("<application"));
    }

    @Test
    public void testJson() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/tika").accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_HELLO_WORLD));
        Metadata metadata = JsonMetadata.fromJson((Reader)new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"Nikolai Lobachevsky", (Object)metadata.get("author"));
        Assertions.assertEquals((Object)"application/mock+xml", (Object)metadata.get("Content-Type"));
        TikaResourceTest.assertContains("hello world", metadata.get(TikaCoreProperties.TIKA_CONTENT));
    }

    @Test
    public void testJsonNPE() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/tika").accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_NULL_POINTER));
        Metadata metadata = JsonMetadata.fromJson((Reader)new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"Nikolai Lobachevsky", (Object)metadata.get("author"));
        Assertions.assertEquals((Object)"application/mock+xml", (Object)metadata.get("Content-Type"));
        TikaResourceTest.assertContains("some content", metadata.get(TikaCoreProperties.TIKA_CONTENT));
        TikaResourceTest.assertContains("null pointer message", metadata.get(TikaCoreProperties.CONTAINER_EXCEPTION));
    }

    @Test
    public void testJsonWriteLimit() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/tika").header("writeLimit", new Object[]{"100"}).accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_HELLO_WORLD_LONG));
        Metadata metadata = JsonMetadata.fromJson((Reader)new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"Nikolai Lobachevsky", (Object)metadata.get("author"));
        Assertions.assertEquals((Object)"application/mock+xml", (Object)metadata.get("Content-Type"));
        TikaResourceTest.assertContains("Hello world", metadata.get(TikaCoreProperties.TIKA_CONTENT));
        TikaResourceTest.assertNotFound("dissolve", metadata.get(TikaCoreProperties.TIKA_CONTENT));
        Assertions.assertTrue((boolean)metadata.get(TikaCoreProperties.CONTAINER_EXCEPTION).startsWith("org.apache.tika.exception.WriteLimitReachedException"));
        Assertions.assertEquals((Object)"true", (Object)metadata.get(TikaCoreProperties.WRITE_LIMIT_REACHED));
    }

    @Test
    public void testNoWriteLimitOnStreamingWrite() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/tika").header("writeLimit", new Object[]{"100"}).accept(new String[]{"text/plain"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_HELLO_WORLD_LONG));
        String content = TikaResourceTest.getStringFromInputStream((InputStream)response.getEntity());
        TikaResourceTest.assertContains("separation.", content);
        response = WebClient.create((String)"http://localhost:9998/tika").header("writeLimit", new Object[]{"100"}).accept(new String[]{"text/html"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_HELLO_WORLD_LONG));
        content = TikaResourceTest.getStringFromInputStream((InputStream)response.getEntity());
        TikaResourceTest.assertContains("separation.</p>", content);
    }

    @Test
    public void testJsonHandlerType() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/tika").accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_HELLO_WORLD_LONG));
        Metadata metadata = JsonMetadata.fromJson((Reader)new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"Nikolai Lobachevsky", (Object)metadata.get("author"));
        Assertions.assertEquals((Object)"application/mock+xml", (Object)metadata.get("Content-Type"));
        TikaResourceTest.assertContains("Hello world", metadata.get(TikaCoreProperties.TIKA_CONTENT));
        TikaResourceTest.assertContains("<p>", metadata.get(TikaCoreProperties.TIKA_CONTENT));
        response = WebClient.create((String)"http://localhost:9998/tika/text").accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_HELLO_WORLD_LONG));
        metadata = JsonMetadata.fromJson((Reader)new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"Nikolai Lobachevsky", (Object)metadata.get("author"));
        Assertions.assertEquals((Object)"application/mock+xml", (Object)metadata.get("Content-Type"));
        TikaResourceTest.assertContains("Hello world", metadata.get(TikaCoreProperties.TIKA_CONTENT));
        TikaResourceTest.assertNotFound("<p>", metadata.get(TikaCoreProperties.TIKA_CONTENT));
    }
}

