/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.Response;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.pipes.FetchEmitTuple;
import org.apache.tika.pipes.HandlerConfig;
import org.apache.tika.pipes.emitter.EmitKey;
import org.apache.tika.pipes.fetcher.FetchKey;
import org.apache.tika.pipes.fetcher.FetcherManager;
import org.apache.tika.sax.BasicContentHandlerFactory;
import org.apache.tika.serialization.JsonMetadataList;
import org.apache.tika.serialization.pipes.JsonFetchEmitTuple;
import org.apache.tika.server.core.CXFTestBase;
import org.apache.tika.server.core.FetcherStreamFactory;
import org.apache.tika.server.core.InputStreamFactory;
import org.apache.tika.server.core.TikaServerParseExceptionMapper;
import org.apache.tika.server.core.resource.PipesResource;
import org.apache.tika.server.core.writer.JSONObjWriter;
import org.apache.tika.utils.ProcessUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TikaPipesTest
extends CXFTestBase {
    private static final String PIPES_PATH = "/pipes";
    private static Path TMP_DIR;
    private static Path TMP_OUTPUT_DIR;
    private static Path TMP_OUTPUT_FILE;
    private static Path TIKA_PIPES_LOG4j2_PATH;
    private static Path TMP_NPE_OUTPUT_FILE;
    private static Path TIKA_CONFIG_PATH;
    private static String TIKA_CONFIG_XML;
    private static FetcherManager FETCHER_MANAGER;
    private static String HELLO_WORLD;
    private static String HELLO_WORLD_JSON;
    private static String NPE_JSON;
    private static String[] VALUE_ARRAY;

    @BeforeAll
    public static void setUpBeforeClass() throws Exception {
        TMP_DIR = Files.createTempDirectory("tika-pipes-test-", new FileAttribute[0]);
        Path inputDir = TMP_DIR.resolve("input");
        TMP_OUTPUT_DIR = TMP_DIR.resolve("output");
        TMP_OUTPUT_FILE = TMP_OUTPUT_DIR.resolve(HELLO_WORLD_JSON);
        TMP_NPE_OUTPUT_FILE = TMP_OUTPUT_DIR.resolve("null_pointer.xml.json");
        Files.createDirectories(inputDir, new FileAttribute[0]);
        Files.createDirectories(TMP_OUTPUT_DIR, new FileAttribute[0]);
        for (String mockFile : new String[]{"hello_world.xml", "null_pointer.xml"}) {
            Files.copy(TikaPipesTest.class.getResourceAsStream("/test-documents/mock/" + mockFile), inputDir.resolve(mockFile), new CopyOption[0]);
        }
        TIKA_CONFIG_PATH = Files.createTempFile(TMP_DIR, "tika-pipes-", ".xml", new FileAttribute[0]);
        TIKA_PIPES_LOG4j2_PATH = Files.createTempFile(TMP_DIR, "log4j2-", ".xml", new FileAttribute[0]);
        Files.copy(TikaPipesTest.class.getResourceAsStream("/log4j2.xml"), TIKA_PIPES_LOG4j2_PATH, StandardCopyOption.REPLACE_EXISTING);
        TIKA_CONFIG_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><properties><fetchers><fetcher class=\"org.apache.tika.pipes.fetcher.fs.FileSystemFetcher\"><name>fsf</name><basePath>" + String.valueOf(inputDir.toAbsolutePath()) + "</basePath></fetcher></fetchers><emitters><emitter class=\"org.apache.tika.pipes.emitter.fs.FileSystemEmitter\"><name>fse</name><basePath>" + String.valueOf(TMP_OUTPUT_DIR.toAbsolutePath()) + "</basePath></emitter></emitters><pipes><tikaConfig>" + ProcessUtils.escapeCommandLine((String)TIKA_CONFIG_PATH.toAbsolutePath().toString()) + "</tikaConfig><numClients>10</numClients><forkedJvmArgs><arg>-Xmx256m</arg><arg>-Dlog4j.configurationFile=file:" + ProcessUtils.escapeCommandLine((String)TIKA_PIPES_LOG4j2_PATH.toAbsolutePath().toString()) + "</arg></forkedJvmArgs></pipes></properties>";
        Files.write(TIKA_CONFIG_PATH, TIKA_CONFIG_XML.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    @AfterAll
    public static void tearDownAfterClass() throws Exception {
        FileUtils.deleteDirectory((File)TMP_DIR.toFile());
    }

    @BeforeEach
    public void setUpEachTest() throws Exception {
        if (Files.exists(TMP_OUTPUT_FILE, new LinkOption[0])) {
            Files.delete(TMP_OUTPUT_FILE);
        }
        if (Files.exists(TMP_NPE_OUTPUT_FILE, new LinkOption[0])) {
            Files.delete(TMP_NPE_OUTPUT_FILE);
        }
        Assertions.assertFalse((boolean)Files.isRegularFile(TMP_OUTPUT_FILE, new LinkOption[0]));
    }

    @Override
    protected void setUpResources(JAXRSServerFactoryBean sf) {
        ArrayList<SingletonResourceProvider> rCoreProviders = new ArrayList<SingletonResourceProvider>();
        try {
            rCoreProviders.add(new SingletonResourceProvider((Object)new PipesResource(TIKA_CONFIG_PATH)));
        }
        catch (IOException | TikaConfigException e) {
            throw new RuntimeException(e);
        }
        sf.setResourceProviders(rCoreProviders);
    }

    @Override
    protected void setUpProviders(JAXRSServerFactoryBean sf) {
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new TikaServerParseExceptionMapper(true));
        providers.add(new JSONObjWriter());
        sf.setProviders(providers);
    }

    @Override
    protected InputStream getTikaConfigInputStream() {
        return new ByteArrayInputStream(TIKA_CONFIG_XML.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    protected InputStreamFactory getInputStreamFactory(InputStream tikaConfigInputStream) {
        return new FetcherStreamFactory(FETCHER_MANAGER);
    }

    @Test
    public void testPost() throws Exception {
        Metadata userMetadata = new Metadata();
        userMetadata.set("my-key", "my-value");
        for (String s : VALUE_ARRAY) {
            userMetadata.add("my-key-multi", s);
        }
        FetchEmitTuple t = new FetchEmitTuple("myId", new FetchKey("fsf", "hello_world.xml"), new EmitKey("fse", ""), userMetadata);
        StringWriter writer = new StringWriter();
        JsonFetchEmitTuple.toJson((FetchEmitTuple)t, (Writer)writer);
        String getUrl = "http://localhost:9998/pipes";
        Response response = WebClient.create((String)getUrl).accept(new String[]{"application/json"}).post((Object)writer.toString());
        Assertions.assertEquals((int)200, (int)response.getStatus());
        List metadataList = null;
        try (BufferedReader reader = Files.newBufferedReader(TMP_OUTPUT_FILE);){
            metadataList = JsonMetadataList.fromJson((Reader)reader);
        }
        Assertions.assertEquals((int)1, (int)metadataList.size());
        Metadata metadata = (Metadata)metadataList.get(0);
        Assertions.assertEquals((Object)"hello world", (Object)metadata.get(TikaCoreProperties.TIKA_CONTENT).trim());
        Assertions.assertEquals((Object)"Nikolai Lobachevsky", (Object)metadata.get("author"));
        Assertions.assertEquals((Object)"\u4f60\u597d\uff0c\u4e16\u754c", (Object)metadata.get("title"));
        Assertions.assertEquals((Object)"application/mock+xml", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"my-value", (Object)metadata.get("my-key"));
        Assertions.assertArrayEquals((Object[])VALUE_ARRAY, (Object[])metadata.getValues("my-key-multi"));
    }

    @Test
    public void testPostXML() throws Exception {
        Metadata userMetadata = new Metadata();
        userMetadata.set("my-key", "my-value");
        for (String s : VALUE_ARRAY) {
            userMetadata.add("my-key-multi", s);
        }
        ParseContext parseContext = new ParseContext();
        HandlerConfig handlerConfig = new HandlerConfig(BasicContentHandlerFactory.HANDLER_TYPE.XML, HandlerConfig.PARSE_MODE.RMETA, -1, -1, true);
        parseContext.set(HandlerConfig.class, (Object)handlerConfig);
        FetchEmitTuple t = new FetchEmitTuple("myId", new FetchKey("fsf", "hello_world.xml"), new EmitKey("fse", ""), userMetadata, parseContext, FetchEmitTuple.ON_PARSE_EXCEPTION.EMIT);
        StringWriter writer = new StringWriter();
        JsonFetchEmitTuple.toJson((FetchEmitTuple)t, (Writer)writer);
        String getUrl = "http://localhost:9998/pipes";
        Response response = WebClient.create((String)getUrl).accept(new String[]{"application/json"}).post((Object)writer.toString());
        Assertions.assertEquals((int)200, (int)response.getStatus());
        List metadataList = null;
        try (BufferedReader reader = Files.newBufferedReader(TMP_OUTPUT_FILE);){
            metadataList = JsonMetadataList.fromJson((Reader)reader);
        }
        Assertions.assertEquals((int)1, (int)metadataList.size());
        Metadata metadata = (Metadata)metadataList.get(0);
        TikaPipesTest.assertContains("<p>hello world</p>", metadata.get(TikaCoreProperties.TIKA_CONTENT).trim());
    }

    @Test
    public void testPostNPE() throws Exception {
        List metadataList;
        JsonNode jsonResponse;
        Metadata userMetadata = new Metadata();
        userMetadata.set("my-key", "my-value");
        for (String s : VALUE_ARRAY) {
            userMetadata.add("my-key-multi", s);
        }
        FetchEmitTuple t = new FetchEmitTuple("myId", new FetchKey("fsf", "null_pointer.xml"), new EmitKey("fse", ""), userMetadata);
        StringWriter writer = new StringWriter();
        JsonFetchEmitTuple.toJson((FetchEmitTuple)t, (Writer)writer);
        String getUrl = "http://localhost:9998/pipes";
        Response response = WebClient.create((String)getUrl).accept(new String[]{"application/json"}).post((Object)writer.toString());
        Assertions.assertEquals((int)200, (int)response.getStatus());
        try (InputStreamReader reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);){
            jsonResponse = new ObjectMapper().readTree((Reader)reader);
        }
        String parseException = jsonResponse.get("parse_exception").asText();
        Assertions.assertNotNull((Object)parseException);
        TikaPipesTest.assertContains("NullPointerException", parseException);
        Assertions.assertTrue((boolean)jsonResponse.get("emitted").asBoolean());
        try (BufferedReader reader = Files.newBufferedReader(TMP_OUTPUT_DIR.resolve("null_pointer.xml.json"));){
            metadataList = JsonMetadataList.fromJson((Reader)reader);
        }
        Assertions.assertEquals((int)1, (int)metadataList.size());
        Metadata metadata = (Metadata)metadataList.get(0);
        Assertions.assertEquals((Object)"application/mock+xml", (Object)metadata.get("Content-Type"));
        Assertions.assertEquals((Object)"my-value", (Object)metadata.get("my-key"));
        Assertions.assertArrayEquals((Object[])VALUE_ARRAY, (Object[])metadata.getValues("my-key-multi"));
        TikaPipesTest.assertContains("NullPointerException", metadata.get(TikaCoreProperties.CONTAINER_EXCEPTION));
    }

    @Test
    public void testPostNPENoEmit() throws Exception {
        JsonNode jsonResponse;
        FetchEmitTuple t = new FetchEmitTuple("myId", new FetchKey("fsf", "null_pointer.xml"), new EmitKey("fse", ""), new Metadata(), new ParseContext(), FetchEmitTuple.ON_PARSE_EXCEPTION.SKIP);
        StringWriter writer = new StringWriter();
        JsonFetchEmitTuple.toJson((FetchEmitTuple)t, (Writer)writer);
        String getUrl = "http://localhost:9998/pipes";
        Response response = WebClient.create((String)getUrl).accept(new String[]{"application/json"}).post((Object)writer.toString());
        Assertions.assertEquals((int)200, (int)response.getStatus());
        try (InputStreamReader reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);){
            jsonResponse = new ObjectMapper().readTree((Reader)reader);
        }
        String parseException = jsonResponse.get("parse_exception").asText();
        Assertions.assertNotNull((Object)parseException);
        TikaPipesTest.assertContains("NullPointerException", parseException);
        Assertions.assertFalse((boolean)jsonResponse.get("emitted").asBoolean());
        Assertions.assertFalse((boolean)Files.isRegularFile(TMP_NPE_OUTPUT_FILE, new LinkOption[0]));
    }

    static {
        HELLO_WORLD = "hello_world.xml";
        HELLO_WORLD_JSON = "hello_world.xml.json";
        NPE_JSON = "null_pointer.xml.json";
        VALUE_ARRAY = new String[]{"my-value-1", "my-value-2", "my-value-3"};
    }
}

