/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core;

import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.tika.server.core.CXFTestBase;
import org.apache.tika.server.core.ServerStatus;
import org.apache.tika.server.core.TikaServerParseExceptionMapper;
import org.apache.tika.server.core.resource.DetectorResource;
import org.apache.tika.server.core.resource.MetadataResource;
import org.apache.tika.server.core.resource.RecursiveMetadataResource;
import org.apache.tika.server.core.resource.TikaResource;
import org.apache.tika.server.core.resource.UnpackerResource;
import org.apache.tika.server.core.writer.CSVMessageBodyWriter;
import org.apache.tika.server.core.writer.JSONMessageBodyWriter;
import org.apache.tika.server.core.writer.MetadataListMessageBodyWriter;
import org.apache.tika.server.core.writer.TextMessageBodyWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StackTraceTest
extends CXFTestBase {
    private static final String TEST_HELLO_WORLD = "test-documents/mock/hello_world.xml";
    private static final String TEST_NULL = "test-documents/mock/null_pointer.xml";
    private static final String TEST_PASSWORD_PROTECTED = "test-documents/mock/encrypted_document_exception.xml";
    private static final String[] PATHS = new String[]{"/tika", "/rmeta", "/unpack", "/meta"};
    private static final int UNPROCESSEABLE = 422;

    @Override
    protected void setUpResources(JAXRSServerFactoryBean sf) {
        ArrayList<SingletonResourceProvider> rCoreProviders = new ArrayList<SingletonResourceProvider>();
        rCoreProviders.add(new SingletonResourceProvider((Object)new MetadataResource()));
        rCoreProviders.add(new SingletonResourceProvider((Object)new RecursiveMetadataResource()));
        rCoreProviders.add(new SingletonResourceProvider((Object)new DetectorResource(new ServerStatus("", 0))));
        rCoreProviders.add(new SingletonResourceProvider((Object)new TikaResource()));
        rCoreProviders.add(new SingletonResourceProvider((Object)new UnpackerResource()));
        sf.setResourceProviders(rCoreProviders);
    }

    @Override
    protected void setUpProviders(JAXRSServerFactoryBean sf) {
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new TikaServerParseExceptionMapper(true));
        providers.add(new JSONMessageBodyWriter());
        providers.add(new CSVMessageBodyWriter());
        providers.add(new TextMessageBodyWriter());
        providers.add(new MetadataListMessageBodyWriter());
        sf.setProviders(providers);
    }

    @Test
    public void testEncrypted() throws Exception {
        for (String path : PATHS) {
            if ("/rmeta".equals(path)) continue;
            String accept = "*/*";
            if ("/tika".equals(path)) {
                accept = "text/plain";
            }
            Response response = WebClient.create((String)("http://localhost:9998" + path)).accept(new String[]{accept}).header("Content-Disposition", new Object[]{"attachment; filename=test-documents/mock/encrypted_document_exception.xml"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_PASSWORD_PROTECTED));
            Assertions.assertNotNull((Object)response, (String)("null response: " + path));
            Assertions.assertEquals((int)422, (int)response.getStatus(), (String)("unprocessable: " + path));
            String msg = StackTraceTest.getStringFromInputStream((InputStream)response.getEntity());
            StackTraceTest.assertContains("org.apache.tika.exception.EncryptedDocumentException", msg);
        }
    }

    @Test
    public void testNullPointerOnTika() throws Exception {
        for (String path : PATHS) {
            if ("/rmeta".equals(path)) continue;
            String accept = "*/*";
            if ("/tika".equals(path)) {
                accept = "text/plain";
            }
            Response response = WebClient.create((String)("http://localhost:9998" + path)).accept(new String[]{accept}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_NULL));
            Assertions.assertNotNull((Object)response);
            Assertions.assertEquals((int)422, (int)response.getStatus(), (String)("unprocessable: " + path));
            String msg = StackTraceTest.getStringFromInputStream((InputStream)response.getEntity());
            StackTraceTest.assertContains("Caused by: java.lang.NullPointerException: null pointer message", msg);
        }
    }

    @Test
    public void testEmptyParser() throws Exception {
        for (String path : PATHS) {
            Response response = WebClient.create((String)("http://localhost:9998" + path)).accept(new String[]{"*:*"}).put((Object)ClassLoader.getSystemResourceAsStream("test-documents/testDigilite.fdf"));
            if (path.equals("/unpack")) {
                Assertions.assertEquals((int)204, (int)response.getStatus(), (String)("bad type: " + path));
                continue;
            }
            Assertions.assertEquals((int)200, (int)response.getStatus(), (String)("bad type: " + path));
            Assertions.assertNotNull((Object)response, (String)("null response: " + path));
        }
    }

    @Test
    public void testMeta() throws Exception {
        InputStream stream = ClassLoader.getSystemResourceAsStream(TEST_HELLO_WORLD);
        Response response = WebClient.create((String)"http://localhost:9998/meta/Author").type("application/mock+xml").accept(new String[]{"text/plain"}).put((Object)StackTraceTest.copy(stream, 100));
        Assertions.assertEquals((int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatus());
        String msg = StackTraceTest.getStringFromInputStream((InputStream)response.getEntity());
        Assertions.assertEquals((Object)"Failed to get metadata field Author", (Object)msg);
    }
}

