/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core;

import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.tika.server.core.ServerStatus;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class ServerStatusTest {
    @Test
    public void testBadId() throws Exception {
        ServerStatus status = new ServerStatus("", 0);
        Assertions.assertThrows(IllegalArgumentException.class, () -> status.complete(2L));
    }

    @Test
    @Timeout(value=60000L)
    public void testBasicMultiThreading() throws Exception {
        int numThreads = 10;
        int filesToProcess = 20;
        ExecutorService service = Executors.newFixedThreadPool(numThreads);
        ExecutorCompletionService<Integer> completionService = new ExecutorCompletionService<Integer>(service);
        ServerStatus serverStatus = new ServerStatus("", 0);
        for (int i = 0; i < numThreads; ++i) {
            completionService.submit(new MockTask(serverStatus, filesToProcess));
        }
        int finished = 0;
        int totalProcessed = 0;
        while (finished < numThreads) {
            Future future = completionService.take();
            if (future == null) continue;
            ++finished;
            Integer completed = (Integer)future.get();
            totalProcessed += completed.intValue();
        }
        Assertions.assertEquals((int)(numThreads * filesToProcess), (int)totalProcessed);
        Assertions.assertEquals((int)0, (int)serverStatus.getTasks().size());
        Assertions.assertEquals((long)totalProcessed, (long)serverStatus.getFilesProcessed());
    }

    private static class MockTask
    implements Callable<Integer> {
        private final ServerStatus serverStatus;
        private final int filesToProcess;
        Random r = new Random();

        public MockTask(ServerStatus serverStatus, int filesToProcess) {
            this.serverStatus = serverStatus;
            this.filesToProcess = filesToProcess;
        }

        @Override
        public Integer call() throws Exception {
            int processed = 0;
            for (int i = 0; i < this.filesToProcess; ++i) {
                this.sleepRandom(200);
                long taskId = this.serverStatus.start(ServerStatus.TASK.PARSE, null, 60000L);
                this.sleepRandom(100);
                this.serverStatus.complete(taskId);
                ++processed;
                this.serverStatus.getStatus();
                this.sleepRandom(10);
                this.serverStatus.setStatus(ServerStatus.STATUS.OPERATING);
                this.sleepRandom(20);
                Map tasks = this.serverStatus.getTasks();
                Assertions.assertNotNull((Object)tasks);
            }
            return processed;
        }

        private void sleepRandom(int millis) throws InterruptedException {
            int sleep = this.r.nextInt(millis);
            Thread.sleep(sleep);
        }
    }
}

