/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core;

import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.serialization.JsonMetadataList;
import org.apache.tika.server.core.CXFTestBase;
import org.apache.tika.server.core.resource.RecursiveMetadataResource;
import org.apache.tika.server.core.writer.MetadataListMessageBodyWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RecursiveMetadataResourceTest
extends CXFTestBase {
    public static final String TEST_NULL_POINTER = "test-documents/mock/null_pointer.xml";
    private static final String META_PATH = "/rmeta";

    @Override
    protected void setUpResources(JAXRSServerFactoryBean sf) {
        sf.setResourceClasses(new Class[]{RecursiveMetadataResource.class});
        sf.setResourceProvider(RecursiveMetadataResource.class, (ResourceProvider)new SingletonResourceProvider((Object)new RecursiveMetadataResource()));
    }

    @Override
    protected void setUpProviders(JAXRSServerFactoryBean sf) {
        ArrayList<MetadataListMessageBodyWriter> providers = new ArrayList<MetadataListMessageBodyWriter>();
        providers.add(new MetadataListMessageBodyWriter());
        sf.setProviders(providers);
    }

    @Test
    public void testNPE() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/rmeta").accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_NULL_POINTER));
        InputStreamReader reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        List metadataList = JsonMetadataList.fromJson((Reader)reader);
        Metadata metadata = (Metadata)metadataList.get(0);
        Assertions.assertEquals((Object)"Nikolai Lobachevsky", (Object)metadata.get("author"));
        Assertions.assertEquals((Object)"application/mock+xml", (Object)metadata.get("Content-Type"));
        RecursiveMetadataResourceTest.assertContains("some content", metadata.get(TikaCoreProperties.TIKA_CONTENT));
        RecursiveMetadataResourceTest.assertContains("null pointer message", metadata.get(TikaCoreProperties.CONTAINER_EXCEPTION));
    }
}

