/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.tika.TikaTest;
import org.apache.tika.server.core.NullWebClientLogger;
import org.apache.tika.server.core.TikaServerIntegrationTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegrationTestBase
extends TikaTest {
    static final String TEST_HELLO_WORLD = "test-documents/mock/hello_world.xml";
    static final String TEST_OOM = "test-documents/mock/fake_oom.xml";
    static final String TEST_SYSTEM_EXIT = "test-documents/mock/system_exit.xml";
    static final String TEST_HEAVY_HANG = "test-documents/mock/heavy_hang_30000.xml";
    static final String TEST_HEAVY_HANG_SHORT = "test-documents/mock/heavy_hang_100.xml";
    static final String TEST_STDOUT_STDERR = "test-documents/mock/testStdOutErr.xml";
    static final String TEST_STATIC_STDOUT_STDERR = "test-documents/mock/testStaticStdOutErr.xml";
    static final String RMETA_PATH = "/rmeta";
    static final String STATUS_PATH = "/status";
    static final long MAX_WAIT_MS = 60000L;
    static final String INTEGRATION_TEST_PORT = "9999";
    protected static final String endPoint = "http://localhost:9999";
    private static final Logger LOG = LoggerFactory.getLogger(IntegrationTestBase.class);
    @TempDir
    static Path TEMP_WORKING_DIR;
    static Path LOG_FILE;
    static Path STREAMS_DIR;
    protected Process process = null;

    @BeforeAll
    public static void staticSetup() throws Exception {
        LogUtils.setLoggerClass(NullWebClientLogger.class);
        LOG_FILE = Files.createTempFile(TEMP_WORKING_DIR, "tika-server-integration", ".xml", new FileAttribute[0]);
        Files.copy(TikaServerIntegrationTest.class.getResourceAsStream("/logging/log4j2_forked.xml"), LOG_FILE, StandardCopyOption.REPLACE_EXISTING);
        STREAMS_DIR = Files.createTempDirectory(TEMP_WORKING_DIR, "tika-server-integration", new FileAttribute[0]);
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.process != null) {
            this.process.destroyForcibly();
            this.process.waitFor(30L, TimeUnit.SECONDS);
            if (this.process.isAlive()) {
                throw new RuntimeException("process still alive!");
            }
        }
    }

    public void startProcess(String[] extraArgs) throws IOException {
        String[] base = new String[]{"java", "-cp", System.getProperty("java.class.path"), "org.apache.tika.server.core.TikaServerCli"};
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(base));
        args.addAll(Arrays.asList(extraArgs));
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.inheritIO();
        this.process = pb.start();
    }

    void awaitServerStartup() throws Exception {
        WebClient client = WebClient.create((String)"http://localhost:9999/").accept(new String[]{"text/html"});
        this.awaitServerStartup(client);
    }

    void awaitServerStartup(WebClient client) throws Exception {
        Instant started = Instant.now();
        long elapsed = Duration.between(started, Instant.now()).toMillis();
        while (elapsed < 60000L) {
            try {
                Response response = client.get();
                if (response.getStatus() == 200) {
                    elapsed = Duration.between(started, Instant.now()).toMillis();
                    LOG.info("client observes server successfully started after " + elapsed + " ms");
                    return;
                }
                LOG.debug("tika test client failed to connect to server with status: {}", (Object)response.getStatus());
            }
            catch (ProcessingException e) {
                LOG.debug("tika test client failed to connect to server", (Throwable)e);
            }
            Thread.sleep(1000L);
            elapsed = Duration.between(started, Instant.now()).toMillis();
        }
        throw new TimeoutException("couldn't connect to server after " + elapsed + " ms");
    }

    static class MyExitException
    extends RuntimeException {
        private final int status;

        MyExitException(int status) {
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }
    }
}

