/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core;

import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.tika.server.core.CXFTestBase;
import org.apache.tika.server.core.ServerStatus;
import org.apache.tika.server.core.TikaServerParseExceptionMapper;
import org.apache.tika.server.core.resource.TranslateResource;
import org.apache.tika.server.core.writer.TarWriter;
import org.apache.tika.server.core.writer.ZipWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TranslateResourceTest
extends CXFTestBase {
    private static final String TRANSLATE_PATH = "/translate";
    private static final String TRANSLATE_ALL_PATH = "/translate/all";
    private static final String TRANSLATE_TXT = "This won't translate";
    private static final String LINGO_PATH = "/org.apache.tika.language.translate.impl.Lingo24Translator";
    private static final String SRCDEST = "/es/en";
    private static final String DEST = "/en";

    @Override
    protected void setUpResources(JAXRSServerFactoryBean sf) {
        sf.setResourceClasses(new Class[]{TranslateResource.class});
        sf.setResourceProvider(TranslateResource.class, (ResourceProvider)new SingletonResourceProvider((Object)new TranslateResource(new ServerStatus("", 0), 60000L)));
    }

    @Override
    protected void setUpProviders(JAXRSServerFactoryBean sf) {
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new TarWriter());
        providers.add(new ZipWriter());
        providers.add(new TikaServerParseExceptionMapper(false));
        sf.setProviders(providers);
    }

    @Test
    public void testTranslateFull() throws Exception {
        String url = "http://localhost:9998/translate/all/org.apache.tika.language.translate.impl.Lingo24Translator/es/en";
        Response response = WebClient.create((String)url).type("text/plain").accept(new String[]{"*/*"}).put((Object)TRANSLATE_TXT);
        Assertions.assertNotNull((Object)response);
        String translated = TranslateResourceTest.getStringFromInputStream((InputStream)response.getEntity());
        Assertions.assertEquals((Object)TRANSLATE_TXT, (Object)translated);
    }

    @Test
    public void testTranslateAutoLang() throws Exception {
        String url = "http://localhost:9998/translate/all/org.apache.tika.language.translate.impl.Lingo24Translator/en";
        Response response = WebClient.create((String)url).type("text/plain").accept(new String[]{"*/*"}).put((Object)TRANSLATE_TXT);
        Assertions.assertNotNull((Object)response);
        String translated = TranslateResourceTest.getStringFromInputStream((InputStream)response.getEntity());
        Assertions.assertEquals((Object)TRANSLATE_TXT, (Object)translated);
    }
}

