/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core;

import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.tika.Tika;
import org.apache.tika.server.core.CXFTestBase;
import org.apache.tika.server.core.ServerStatus;
import org.apache.tika.server.core.resource.DetectorResource;
import org.apache.tika.server.core.resource.MetadataResource;
import org.apache.tika.server.core.resource.TikaVersion;
import org.apache.tika.server.core.resource.TikaWelcome;
import org.junit.jupiter.api.Test;

public class TikaWelcomeTest
extends CXFTestBase {
    protected static final String WELCOME_PATH = "/";
    protected static final String PATH_RESOURCE = "/detect/stream";
    protected static final String PATH_RESOURCE_2 = "/meta/form";
    private static final String VERSION_PATH = "/version";

    @Override
    protected void setUpResources(JAXRSServerFactoryBean sf) {
        ArrayList<SingletonResourceProvider> rpsCore = new ArrayList<SingletonResourceProvider>();
        rpsCore.add(new SingletonResourceProvider((Object)new TikaVersion()));
        rpsCore.add(new SingletonResourceProvider((Object)new DetectorResource(new ServerStatus("", 0))));
        rpsCore.add(new SingletonResourceProvider((Object)new MetadataResource()));
        ArrayList<SingletonResourceProvider> all = new ArrayList<SingletonResourceProvider>(rpsCore);
        all.add(new SingletonResourceProvider((Object)new TikaWelcome(rpsCore)));
        sf.setResourceProviders(all);
    }

    @Override
    protected void setUpProviders(JAXRSServerFactoryBean sf) {
    }

    @Test
    public void testGetHTMLWelcome() throws Exception {
        String html = (String)WebClient.create((String)"http://localhost:9998/").type("text/html").accept(new String[]{"text/html"}).get(String.class);
        TikaWelcomeTest.assertContains(Tika.getString(), html);
        TikaWelcomeTest.assertContains("href=\"http", html);
        TikaWelcomeTest.assertContains("GET", html);
        TikaWelcomeTest.assertContains(WELCOME_PATH, html);
        TikaWelcomeTest.assertContains("text/plain", html);
        TikaWelcomeTest.assertContains(VERSION_PATH, html);
    }

    @Test
    public void testGetTextWelcome() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/").type("text/plain").accept(new String[]{"text/plain"}).get();
        String text = TikaWelcomeTest.getStringFromInputStream((InputStream)response.getEntity());
        TikaWelcomeTest.assertContains(Tika.getString(), text);
        TikaWelcomeTest.assertContains("GET /", text);
        TikaWelcomeTest.assertContains("=> text/plain", text);
        TikaWelcomeTest.assertContains("GET /version", text);
    }

    @Test
    public void testProperPathWelcome() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/").type("text/html").accept(new String[]{"text/html"}).get();
        String html = TikaWelcomeTest.getStringFromInputStream((InputStream)response.getEntity());
        TikaWelcomeTest.assertContains(PATH_RESOURCE, html);
        TikaWelcomeTest.assertContains(PATH_RESOURCE_2, html);
    }
}

