/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.pipes.FetchEmitTuple;
import org.apache.tika.pipes.HandlerConfig;
import org.apache.tika.pipes.emitter.EmitKey;
import org.apache.tika.pipes.fetcher.FetchKey;
import org.apache.tika.serialization.pipes.JsonFetchEmitTuple;
import org.apache.tika.server.core.IntegrationTestBase;
import org.apache.tika.server.core.TikaPipesTest;
import org.apache.tika.utils.ProcessUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TikaServerPipesIntegrationTest
extends IntegrationTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(TikaServerPipesIntegrationTest.class);
    private static final String EMITTER_NAME = "fse";
    private static final String FETCHER_NAME = "fsf";
    private static Path TEMP_OUTPUT_DIR;
    private static Path TIKA_CONFIG;
    private static Path TIKA_CONFIG_TIMEOUT;
    private static String[] FILES;

    @BeforeAll
    public static void setUpBeforeClass() throws Exception {
        Path inputDir = TEMP_WORKING_DIR.resolve("input");
        TEMP_OUTPUT_DIR = TEMP_WORKING_DIR.resolve("output");
        Files.createDirectories(inputDir, new FileAttribute[0]);
        Files.createDirectories(TEMP_OUTPUT_DIR, new FileAttribute[0]);
        for (String mockFile : FILES) {
            Files.copy(TikaPipesTest.class.getResourceAsStream("/test-documents/mock/" + mockFile), inputDir.resolve(mockFile), new CopyOption[0]);
        }
        TIKA_CONFIG = TEMP_WORKING_DIR.resolve("tika-config.xml");
        TIKA_CONFIG_TIMEOUT = TEMP_WORKING_DIR.resolve("tika-config-timeout.xml");
        String xml1 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><properties><fetchers><fetcher class=\"org.apache.tika.pipes.fetcher.fs.FileSystemFetcher\"><name>fsf</name><basePath>" + inputDir.toAbsolutePath() + "</basePath></fetcher></fetchers><emitters><emitter class=\"org.apache.tika.pipes.emitter.fs.FileSystemEmitter\"><name>fse</name><basePath>" + TEMP_OUTPUT_DIR.toAbsolutePath() + "</basePath></emitter></emitters><server><enableUnsecureFeatures>true</enableUnsecureFeatures><port>9999</port><endpoints><endpoint>pipes</endpoint><endpoint>status</endpoint></endpoints>";
        String xml2 = "</server><pipes><tikaConfig>" + ProcessUtils.escapeCommandLine((String)TIKA_CONFIG.toAbsolutePath().toString()) + "</tikaConfig><numClients>10</numClients><forkedJvmArgs><arg>-Xmx256m</arg></forkedJvmArgs><timeoutMillis>5000</timeoutMillis></pipes></properties>";
        String tikaConfigXML = xml1 + xml2;
        FileUtils.write((File)TIKA_CONFIG.toFile(), (CharSequence)tikaConfigXML, (Charset)StandardCharsets.UTF_8);
        String tikaConfigTimeoutXML = xml1 + "<taskPulseMillis>100</taskPulseMillis><taskTimeoutMillis>10000</taskTimeoutMillis>" + xml2;
        FileUtils.write((File)TIKA_CONFIG_TIMEOUT.toFile(), (CharSequence)tikaConfigTimeoutXML, (Charset)StandardCharsets.UTF_8);
    }

    @AfterEach
    public void tear() throws Exception {
        Thread.sleep(500L);
    }

    @BeforeEach
    public void setUpEachTest() throws Exception {
        for (String problemFile : FILES) {
            Path targ = TEMP_OUTPUT_DIR.resolve(problemFile + ".json");
            if (!Files.exists(targ, new LinkOption[0])) continue;
            Files.delete(targ);
            Assertions.assertFalse((boolean)Files.isRegularFile(targ, new LinkOption[0]));
        }
    }

    @Test
    public void testBasic() throws Exception {
        this.startProcess(new String[]{"-config", ProcessUtils.escapeCommandLine((String)TIKA_CONFIG.toAbsolutePath().toString())});
        JsonNode node = this.testOne("hello_world.xml", true);
        Assertions.assertEquals((Object)"ok", (Object)node.get("status").asText());
    }

    @Test
    public void testNPEDefault() throws Exception {
        this.startProcess(new String[]{"-config", ProcessUtils.escapeCommandLine((String)TIKA_CONFIG.toAbsolutePath().toString())});
        JsonNode node = this.testOne("null_pointer.xml", true);
        Assertions.assertEquals((Object)"ok", (Object)node.get("status").asText());
        TikaServerPipesIntegrationTest.assertContains((String)"java.lang.NullPointerException", (String)node.get("parse_exception").asText());
    }

    @Test
    public void testNPESkip() throws Exception {
        this.startProcess(new String[]{"-config", ProcessUtils.escapeCommandLine((String)TIKA_CONFIG.toAbsolutePath().toString())});
        JsonNode node = this.testOne("null_pointer.xml", false, FetchEmitTuple.ON_PARSE_EXCEPTION.SKIP);
        Assertions.assertEquals((Object)"ok", (Object)node.get("status").asText());
        TikaServerPipesIntegrationTest.assertContains((String)"java.lang.NullPointerException", (String)node.get("parse_exception").asText());
    }

    @Test
    public void testSystemExit() throws Exception {
        this.startProcess(new String[]{"-config", ProcessUtils.escapeCommandLine((String)TIKA_CONFIG.toAbsolutePath().toString())});
        JsonNode node = this.testOne("system_exit.xml", false);
        Assertions.assertEquals((Object)"parse_error", (Object)node.get("status").asText());
        TikaServerPipesIntegrationTest.assertContains((String)"unknown_crash", (String)node.get("parse_error").asText());
    }

    @Test
    public void testOOM() throws Exception {
        try {
            this.startProcess(new String[]{"-config", ProcessUtils.escapeCommandLine((String)TIKA_CONFIG.toAbsolutePath().toString())});
            JsonNode node = this.testOne("fake_oom.xml", false);
            Assertions.assertEquals((Object)"parse_error", (Object)node.get("status").asText());
            TikaServerPipesIntegrationTest.assertContains((String)"oom", (String)node.get("parse_error").asText());
        }
        catch (ProcessingException processingException) {
            // empty catch block
        }
    }

    @Test
    public void testTimeout() throws Exception {
        this.startProcess(new String[]{"-config", ProcessUtils.escapeCommandLine((String)TIKA_CONFIG_TIMEOUT.toAbsolutePath().toString())});
        JsonNode node = this.testOne("heavy_hang_30000.xml", false);
        Assertions.assertEquals((Object)"parse_error", (Object)node.get("status").asText());
        TikaServerPipesIntegrationTest.assertContains((String)"timeout", (String)node.get("parse_error").asText());
    }

    private JsonNode testOne(String fileName, boolean shouldFileExist) throws Exception {
        return this.testOne(fileName, shouldFileExist, FetchEmitTuple.ON_PARSE_EXCEPTION.EMIT);
    }

    private JsonNode testOne(String fileName, boolean shouldFileExist, FetchEmitTuple.ON_PARSE_EXCEPTION onParseException) throws Exception {
        this.awaitServerStartup();
        Response response = WebClient.create((String)"http://localhost:9999/pipes").accept(new String[]{"application/json"}).post((Object)this.getJsonString(fileName, onParseException));
        if (response.getStatus() == 200) {
            Path targFile = TEMP_OUTPUT_DIR.resolve(fileName + ".json");
            if (shouldFileExist) {
                Assertions.assertTrue((Files.size(targFile) > 1L ? 1 : 0) != 0);
            } else {
                Assertions.assertFalse((boolean)Files.isRegularFile(targFile, new LinkOption[0]));
            }
            InputStreamReader reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
            return new ObjectMapper().readTree((Reader)reader);
        }
        return null;
    }

    private String getJsonString(String fileName, FetchEmitTuple.ON_PARSE_EXCEPTION onParseException) throws IOException {
        ParseContext parseContext = new ParseContext();
        parseContext.set(HandlerConfig.class, (Object)HandlerConfig.DEFAULT_HANDLER_CONFIG);
        FetchEmitTuple t = new FetchEmitTuple(fileName, new FetchKey(FETCHER_NAME, fileName), new EmitKey(EMITTER_NAME, ""), new Metadata(), parseContext, onParseException);
        return JsonFetchEmitTuple.toJson((FetchEmitTuple)t);
    }

    static {
        FILES = new String[]{"hello_world.xml", "heavy_hang_30000.xml", "fake_oom.xml", "system_exit.xml", "null_pointer.xml"};
    }
}

