/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.pipes.FetchEmitTuple;
import org.apache.tika.pipes.HandlerConfig;
import org.apache.tika.pipes.emitter.EmitKey;
import org.apache.tika.pipes.fetcher.FetchKey;
import org.apache.tika.serialization.pipes.JsonFetchEmitTupleList;
import org.apache.tika.server.core.IntegrationTestBase;
import org.apache.tika.server.core.TikaPipesTest;
import org.apache.tika.server.core.TikaServerCli;
import org.apache.tika.utils.ProcessUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Disabled(value="useful for development...need to turn it into a real unit test")
public class TikaServerAsyncIntegrationTest
extends IntegrationTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(TikaServerAsyncIntegrationTest.class);
    private static final int NUM_FILES = 100;
    private static final String EMITTER_NAME = "fse";
    private static final String FETCHER_NAME = "fsf";
    private static FetchEmitTuple.ON_PARSE_EXCEPTION ON_PARSE_EXCEPTION = FetchEmitTuple.ON_PARSE_EXCEPTION.EMIT;
    @TempDir
    private static Path TMP_DIR;
    private static Path TMP_OUTPUT_DIR;
    private static String TIKA_CONFIG_XML;
    private static Path TIKA_CONFIG;
    private static List<String> FILE_LIST;
    private static String[] FILES;

    @BeforeAll
    public static void setUpBeforeClass() throws Exception {
        Path inputDir = TMP_DIR.resolve("input");
        TMP_OUTPUT_DIR = TMP_DIR.resolve("output");
        Files.createDirectories(inputDir, new FileAttribute[0]);
        Files.createDirectories(TMP_OUTPUT_DIR, new FileAttribute[0]);
        Random rand = new Random();
        for (int i = 0; i < 100; ++i) {
            for (String mockFile : FILES) {
                if (mockFile.equals("system_exit.xml") && (double)rand.nextFloat() > 0.1) continue;
                String targetName = i + "-" + mockFile;
                Path target = inputDir.resolve(targetName);
                FILE_LIST.add(targetName);
                Files.copy(TikaPipesTest.class.getResourceAsStream("/test-documents/mock/" + mockFile), target, new CopyOption[0]);
            }
        }
        TIKA_CONFIG = TMP_DIR.resolve("tika-config.xml");
        TIKA_CONFIG_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><properties><fetchers><fetcher class=\"org.apache.tika.pipes.fetcher.fs.FileSystemFetcher\"><name>fsf</name><basePath>" + inputDir.toAbsolutePath() + "</basePath></fetcher></fetchers><emitters><emitter class=\"org.apache.tika.pipes.emitter.fs.FileSystemEmitter\"><name>fse</name><basePath>" + TMP_OUTPUT_DIR.toAbsolutePath() + "</basePath></emitter></emitters><server><endpoints><endpoint>async</endpoint></endpoints><enableUnsecureFeatures>true</enableUnsecureFeatures></server><async><tikaConfig>" + ProcessUtils.escapeCommandLine((String)TIKA_CONFIG.toAbsolutePath().toString()) + "</tikaConfig><numClients>10</numClients><forkedJvmArgs><arg>-Xmx256m</arg></forkedJvmArgs><timeoutMillis>5000</timeoutMillis></async></properties>";
        FileUtils.write((File)TIKA_CONFIG.toFile(), (CharSequence)TIKA_CONFIG_XML, (Charset)StandardCharsets.UTF_8);
    }

    @BeforeEach
    public void setUpEachTest() throws Exception {
        for (String problemFile : FILES) {
            Path targ = TMP_OUTPUT_DIR.resolve(problemFile + ".json");
            if (!Files.exists(targ, new LinkOption[0])) continue;
            Files.delete(targ);
            Assertions.assertFalse((boolean)Files.isRegularFile(targ, new LinkOption[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasic() throws Exception {
        Thread serverThread = new Thread(() -> TikaServerCli.main((String[])new String[]{"-p", "9999", "-config", TIKA_CONFIG.toAbsolutePath().toString()}));
        serverThread.start();
        try {
            long start = System.currentTimeMillis();
            JsonNode response = this.sendAsync(FILE_LIST);
            String status = response.get("status").asText();
            if (!"ok".equals(status)) {
                Assertions.fail((String)("bad status: '" + status + "' -> " + response.toPrettyString()));
            }
            int expected = ON_PARSE_EXCEPTION == FetchEmitTuple.ON_PARSE_EXCEPTION.EMIT ? FILE_LIST.size() : FILE_LIST.size() / 3;
            int targets = 0;
            while (targets < 200) {
                targets = this.countTargets();
                Thread.sleep(100L);
            }
        }
        finally {
            serverThread.interrupt();
        }
    }

    private int countTargets() {
        return TMP_OUTPUT_DIR.toFile().listFiles().length;
    }

    private JsonNode sendAsync(List<String> fileNames) throws Exception {
        this.awaitServerStartup();
        ArrayList<FetchEmitTuple> tuples = new ArrayList<FetchEmitTuple>();
        for (String f : fileNames) {
            tuples.add(this.getFetchEmitTuple(f));
        }
        String json = JsonFetchEmitTupleList.toJson(tuples);
        Response response = WebClient.create((String)"http://localhost:9999/async").accept(new String[]{"application/json"}).post((Object)json);
        InputStreamReader reader = new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8);
        return new ObjectMapper().readTree((Reader)reader);
    }

    private FetchEmitTuple getFetchEmitTuple(String fileName) throws IOException {
        ParseContext parseContext = new ParseContext();
        parseContext.set(HandlerConfig.class, (Object)HandlerConfig.DEFAULT_HANDLER_CONFIG);
        return new FetchEmitTuple(fileName, new FetchKey(FETCHER_NAME, fileName), new EmitKey(EMITTER_NAME, ""), new Metadata(), parseContext, ON_PARSE_EXCEPTION);
    }

    static {
        FILE_LIST = new ArrayList<String>();
        FILES = new String[]{"hello_world.xml", "null_pointer.xml", "system_exit.xml"};
    }
}

