/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core;

import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.tika.TikaTest;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.serialization.JsonMetadata;
import org.apache.tika.server.core.CXFTestBase;
import org.apache.tika.server.core.TikaServerConfig;
import org.apache.tika.server.core.TikaServerParseExceptionMapper;
import org.apache.tika.server.core.resource.TikaResource;
import org.apache.tika.server.core.writer.JSONMessageBodyWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TikaResourceNoStackTest
extends CXFTestBase {
    public static final String TEST_HELLO_WORLD = "test-documents/mock/hello_world.xml";
    public static final String TEST_HELLO_WORLD_LONG = "test-documents/mock/hello_world_long.xml";
    public static final String TEST_NULL_POINTER = "test-documents/mock/null_pointer.xml";
    public static final String TEST_OOM = "test-documents/mock/fake_oom.xml";
    private static final String STREAM_CLOSED_FAULT = "java.io.IOException: Stream Closed";
    private static final String TIKA_PATH = "/tika";
    private static final int UNPROCESSEABLE = 422;

    @Override
    public TikaServerConfig getTikaServerConfig() {
        TikaServerConfig tikaServerConfig = new TikaServerConfig();
        tikaServerConfig.setReturnStackTrace(false);
        return tikaServerConfig;
    }

    @Override
    protected void setUpResources(JAXRSServerFactoryBean sf) {
        sf.setResourceClasses(new Class[]{TikaResource.class});
        sf.setResourceProvider(TikaResource.class, (ResourceProvider)new SingletonResourceProvider((Object)new TikaResource()));
    }

    @Override
    protected void setUpProviders(JAXRSServerFactoryBean sf) {
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new TikaServerParseExceptionMapper(false));
        providers.add(new JSONMessageBodyWriter());
        sf.setProviders(providers);
    }

    @Test
    public void testJsonNPE() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/tika").accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_NULL_POINTER));
        Assertions.assertEquals((int)422, (int)response.getStatus());
        String content = TikaResourceNoStackTest.getStringFromInputStream((InputStream)response.getEntity());
        Assertions.assertEquals((int)0, (int)content.length());
    }

    @Test
    public void testJsonWriteLimit() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/tika").header("writeLimit", new Object[]{"100"}).accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_HELLO_WORLD_LONG));
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Metadata metadata = JsonMetadata.fromJson((Reader)new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"true", (Object)metadata.get(TikaCoreProperties.WRITE_LIMIT_REACHED));
        TikaResourceNoStackTest.assertContains("When in the Course of human events", metadata.get(TikaCoreProperties.TIKA_CONTENT));
        TikaTest.assertNotContained((String)"political bands", (String)metadata.get(TikaCoreProperties.TIKA_CONTENT));
    }
}

