/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core;

import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.serialization.JsonMetadata;
import org.apache.tika.server.core.CXFTestBase;
import org.apache.tika.server.core.TikaServerParseExceptionMapper;
import org.apache.tika.server.core.resource.TikaResource;
import org.apache.tika.server.core.writer.JSONMessageBodyWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TikaResourceMetadataFilterTest
extends CXFTestBase {
    public static final String TEST_HELLO_WORLD = "test-documents/mock/hello_world.xml";
    private static final String TIKA_PATH = "/tika";

    @Override
    protected InputStream getTikaConfigInputStream() {
        return this.getClass().getResourceAsStream("/configs/metadata-filter-include.xml");
    }

    @Override
    protected void setUpResources(JAXRSServerFactoryBean sf) {
        sf.setResourceClasses(new Class[]{TikaResource.class});
        sf.setResourceProvider(TikaResource.class, (ResourceProvider)new SingletonResourceProvider((Object)new TikaResource()));
    }

    @Override
    protected void setUpProviders(JAXRSServerFactoryBean sf) {
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new TikaServerParseExceptionMapper(false));
        providers.add(new JSONMessageBodyWriter());
        sf.setProviders(providers);
    }

    @Test
    public void testBasic() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/tika").accept(new String[]{"application/json"}).put((Object)ClassLoader.getSystemResourceAsStream(TEST_HELLO_WORLD));
        Metadata metadata = JsonMetadata.fromJson((Reader)new InputStreamReader((InputStream)response.getEntity(), StandardCharsets.UTF_8));
        Assertions.assertEquals((int)2, (int)metadata.names().length);
        Assertions.assertNull((Object)metadata.get("author"));
        Assertions.assertEquals((Object)"application/mock+xml", (Object)metadata.get("Content-Type"));
        TikaResourceMetadataFilterTest.assertContains("hello world", metadata.get(TikaCoreProperties.TIKA_CONTENT));
    }
}

