/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core;

import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.pipes.fetcher.FetcherManager;
import org.apache.tika.server.core.CXFTestBase;
import org.apache.tika.server.core.FetcherStreamFactory;
import org.apache.tika.server.core.InputStreamFactory;
import org.apache.tika.server.core.TikaServerParseExceptionMapper;
import org.apache.tika.server.core.resource.TikaResource;
import org.apache.tika.server.core.writer.JSONMessageBodyWriter;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class TikaResourceFetcherTest
extends CXFTestBase {
    private static final String TIKA_PATH = "/tika";

    @Override
    protected void setUpResources(JAXRSServerFactoryBean sf) {
        sf.setResourceClasses(new Class[]{TikaResource.class});
        sf.setResourceProvider(TikaResource.class, (ResourceProvider)new SingletonResourceProvider((Object)new TikaResource()));
    }

    @Override
    protected void setUpProviders(JAXRSServerFactoryBean sf) {
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new TikaServerParseExceptionMapper(false));
        providers.add(new JSONMessageBodyWriter());
        sf.setProviders(providers);
    }

    @Override
    protected InputStream getTikaConfigInputStream() throws IOException {
        Path inputDir = null;
        try {
            inputDir = Paths.get(TikaResourceFetcherTest.class.getResource("/test-documents/").toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        String configXML = TikaResourceFetcherTest.getStringFromInputStream(TikaResourceFetcherTest.class.getResourceAsStream("/configs/tika-config-server-fetcher-template.xml"));
        configXML = configXML.replace("{FETCHER_BASE_PATH}", inputDir.toAbsolutePath().toString());
        configXML = configXML.replace("{PORT}", "9998");
        return new ByteArrayInputStream(configXML.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    protected InputStreamFactory getInputStreamFactory(InputStream is) {
        FetcherStreamFactory fetcherStreamFactory;
        block8: {
            TikaInputStream tis = TikaInputStream.get((InputStream)is);
            try {
                FetcherManager fetcherManager = FetcherManager.load((Path)tis.getPath());
                fetcherStreamFactory = new FetcherStreamFactory(fetcherManager);
                if (tis == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (tis != null) {
                        try {
                            tis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | TikaConfigException e) {
                    throw new RuntimeException(e);
                }
            }
            tis.close();
        }
        return fetcherStreamFactory;
    }

    @Test
    public void testHeader() throws Exception {
        MultivaluedHashMap map = new MultivaluedHashMap();
        map.putSingle((Object)"fetcherName", (Object)"fsf");
        map.putSingle((Object)"fetchKey", (Object)"mock/hello_world.xml");
        Response response = WebClient.create((String)"http://localhost:9998/tika").headers((MultivaluedMap)map).accept(new String[]{"text/xml"}).put(null);
        String xml = TikaResourceFetcherTest.getStringFromInputStream((InputStream)response.getEntity());
        TikaResourceFetcherTest.assertContains("hello world", xml);
    }

    @Test
    public void testQueryPart() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/tika").query("fetcherName", new Object[]{"fsf"}).query("fetchKey", new Object[]{"mock/hello_world.xml"}).accept(new String[]{"text/xml"}).put(null);
        String xml = TikaResourceFetcherTest.getStringFromInputStream((InputStream)response.getEntity());
        TikaResourceFetcherTest.assertContains("hello world", xml);
    }

    @Test
    @Disabled(value="Apache's Hudson does not like the test file or the utf-8 in this source file")
    public void testNonAsciiInQueryParameters() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/tika").query("fetcherName", new Object[]{"fsf"}).query("fetchKey", new Object[]{"mock/\u4e2d\u6587.xml"}).accept(new String[]{"text/xml"}).put(null);
        String xml = TikaResourceFetcherTest.getStringFromInputStream((InputStream)response.getEntity());
        TikaResourceFetcherTest.assertContains("\u4f60\u597d\u4e16\u754c", xml);
    }

    @Test
    @Disabled(value="Apache's Hudson does not like the test file or the utf-8 in this source file")
    public void testNonAsciiUrlEncodedInQueryParameters() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/tika").query("fetcherName", new Object[]{"fsf"}).query("fetchKey", new Object[]{"mock/%E4%B8%AD%E6%96%87.xml"}).accept(new String[]{"text/xml"}).put(null);
        String xml = TikaResourceFetcherTest.getStringFromInputStream((InputStream)response.getEntity());
        TikaResourceFetcherTest.assertContains("\u4f60\u597d\u4e16\u754c", xml);
    }
}

