/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core;

import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.tika.server.core.CXFTestBase;
import org.apache.tika.server.core.resource.TikaMimeTypes;
import org.junit.jupiter.api.Test;

public class TikaMimeTypesTest
extends CXFTestBase {
    private static final String MIMETYPES_PATH = "/mime-types";

    @Override
    protected void setUpResources(JAXRSServerFactoryBean sf) {
        sf.setResourceClasses(new Class[]{TikaMimeTypes.class});
        sf.setResourceProvider(TikaMimeTypes.class, (ResourceProvider)new SingletonResourceProvider((Object)new TikaMimeTypes()));
    }

    @Override
    protected void setUpProviders(JAXRSServerFactoryBean sf) {
    }

    @Test
    public void testGetPlainText() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/mime-types").type("text/plain").accept(new String[]{"text/plain"}).get();
        String text = TikaMimeTypesTest.getStringFromInputStream((InputStream)response.getEntity());
        TikaMimeTypesTest.assertContains("text/plain", text);
        TikaMimeTypesTest.assertContains("application/xml", text);
        TikaMimeTypesTest.assertContains("video/x-ogm", text);
        TikaMimeTypesTest.assertContains("supertype: video/ogg", text);
        TikaMimeTypesTest.assertContains("alias:     image/x-ms-bmp", text);
    }

    @Test
    public void testGetHTML() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/mime-types").type("text/html").accept(new String[]{"text/html"}).get();
        String text = TikaMimeTypesTest.getStringFromInputStream((InputStream)response.getEntity());
        TikaMimeTypesTest.assertContains("text/plain", text);
        TikaMimeTypesTest.assertContains("application/xml", text);
        TikaMimeTypesTest.assertContains("video/x-ogm", text);
        TikaMimeTypesTest.assertContains("<h2>", text);
        TikaMimeTypesTest.assertContains("/text/plain\">", text);
        TikaMimeTypesTest.assertContains("name=\"text/plain", text);
        TikaMimeTypesTest.assertContains("Super Type: <a href=\"#video/ogg\">video/ogg", text);
        TikaMimeTypesTest.assertContains("Alias: image/x-ms-bmp", text);
        TikaMimeTypesTest.assertContains("Description: Ogg Vorbis", text);
        TikaMimeTypesTest.assertContains("Extension: .ogg", text);
    }

    @Test
    public void testGetHTMLDetails() throws Exception {
        Response response = WebClient.create((String)"http://localhost:9998/mime-types/application/cbor").type("text/html").accept(new String[]{"text/html"}).get();
        String text = TikaMimeTypesTest.getStringFromInputStream((InputStream)response.getEntity());
        TikaMimeTypesTest.assertNotFound("text/plain", text);
        TikaMimeTypesTest.assertContains("application/cbor", text);
        TikaMimeTypesTest.assertContains("Acronym: CBOR", text);
        TikaMimeTypesTest.assertContains("Link: http://tools.ietf.org/html/rfc7049", text);
        TikaMimeTypesTest.assertContains("Extension: .cbor", text);
    }
}

