/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core;

import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.tika.server.core.CXFTestBase;
import org.apache.tika.server.core.TikaServerParseExceptionMapper;
import org.apache.tika.server.core.resource.LanguageResource;
import org.apache.tika.server.core.writer.TarWriter;
import org.apache.tika.server.core.writer.ZipWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LanguageResourceTest
extends CXFTestBase {
    private static final String LANG_PATH = "/language";
    private static final String LANG_STREAM_PATH = "/language/stream";
    private static final String LANG_STRING_PATH = "/language/string";
    private static final String ENGLISH_STRING = "This is English!";
    private static final String FRENCH_STRING = "c\u2019est comme ci comme \u00e7a";

    @Override
    protected void setUpResources(JAXRSServerFactoryBean sf) {
        sf.setResourceClasses(new Class[]{LanguageResource.class});
        sf.setResourceProvider(LanguageResource.class, (ResourceProvider)new SingletonResourceProvider((Object)new LanguageResource()));
    }

    @Override
    protected void setUpProviders(JAXRSServerFactoryBean sf) {
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new TarWriter());
        providers.add(new ZipWriter());
        providers.add(new TikaServerParseExceptionMapper(false));
        sf.setProviders(providers);
    }

    @Test
    public void testDetectEnglishString() throws Exception {
        String url = "http://localhost:9998/language/string";
        Response response = WebClient.create((String)url).type("text/plain").accept(new String[]{"text/plain"}).put((Object)ENGLISH_STRING);
        Assertions.assertNotNull((Object)response);
        String readLang = LanguageResourceTest.getStringFromInputStream((InputStream)response.getEntity());
        Assertions.assertEquals((Object)"en", (Object)readLang);
    }

    @Test
    public void testDetectFrenchString() throws Exception {
        String url = "http://localhost:9998/language/string";
        Response response = WebClient.create((String)url).type("text/plain").accept(new String[]{"text/plain"}).put((Object)FRENCH_STRING);
        Assertions.assertNotNull((Object)response);
        String readLang = LanguageResourceTest.getStringFromInputStream((InputStream)response.getEntity());
        Assertions.assertEquals((Object)"fr", (Object)readLang);
    }

    @Test
    public void testDetectEnglishFile() throws Exception {
        String url = "http://localhost:9998/language/stream";
        Response response = WebClient.create((String)url).type("text/plain").accept(new String[]{"text/plain"}).put((Object)this.getClass().getResourceAsStream("/test-documents/english.txt"));
        Assertions.assertNotNull((Object)response);
        String readLang = LanguageResourceTest.getStringFromInputStream((InputStream)response.getEntity());
        Assertions.assertEquals((Object)"en", (Object)readLang);
    }

    @Test
    public void testDetectFrenchFile() throws Exception {
        String url = "http://localhost:9998/language/stream";
        Response response = WebClient.create((String)url).type("text/plain").accept(new String[]{"text/plain"}).put((Object)this.getClass().getResourceAsStream("/test-documents/french.txt"));
        Assertions.assertNotNull((Object)response);
        String readLang = LanguageResourceTest.getStringFromInputStream((InputStream)response.getEntity());
        Assertions.assertEquals((Object)"fr", (Object)readLang);
    }
}

