/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.core;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSBindingFactory;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.ext.ResourceComparator;
import org.apache.cxf.transport.common.gzip.GZIPInInterceptor;
import org.apache.cxf.transport.common.gzip.GZIPOutInterceptor;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.parser.DigestingParser;
import org.apache.tika.parser.digestutils.CommonsDigester;
import org.apache.tika.server.core.DefaultInputStreamFactory;
import org.apache.tika.server.core.InputStreamFactory;
import org.apache.tika.server.core.ProduceTypeResourceComparator;
import org.apache.tika.server.core.ServerStatus;
import org.apache.tika.server.core.TikaServerConfig;
import org.apache.tika.server.core.resource.TikaResource;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

public abstract class CXFTestBase {
    protected static final String endPoint = "http://localhost:9998";
    protected static final int DIGESTER_READ_LIMIT = 0x1400000;
    protected Server server;
    protected TikaConfig tika;

    public static void assertContains(String needle, String haystack) {
        Assertions.assertTrue((boolean)haystack.contains(needle), (String)(needle + " not found in:\n" + haystack));
    }

    public static void assertNotFound(String needle, String haystack) {
        Assertions.assertFalse((boolean)haystack.contains(needle), (String)(needle + " unexpectedly found in:\n" + haystack));
    }

    protected static InputStream copy(InputStream in, int remaining) throws IOException {
        byte[] bytes;
        int n;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while (remaining > 0 && (n = in.read(bytes = new byte[remaining])) > 0) {
            out.write(bytes, 0, n);
            remaining -= n;
        }
        return new ByteArrayInputStream(out.toByteArray());
    }

    protected static String getStringFromInputStream(InputStream in) throws IOException {
        return IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
    }

    public static InputStream gzip(InputStream is) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GzipCompressorOutputStream gz = new GzipCompressorOutputStream((OutputStream)bos);
        IOUtils.copy((InputStream)is, (OutputStream)gz);
        gz.flush();
        gz.close();
        return new ByteArrayInputStream(bos.toByteArray());
    }

    protected static AverageColor getAverageColor(BufferedImage image, int minX, int maxX, int minY, int maxY) {
        long totalRed = 0L;
        long totalGreen = 0L;
        long totalBlue = 0L;
        int pixels = 0;
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                int clr = image.getRGB(x, y);
                int red = (clr & 0xFF0000) >> 16;
                int green = (clr & 0xFF00) >> 8;
                int blue = clr & 0xFF;
                totalRed += (long)red;
                totalGreen += (long)green;
                totalBlue += (long)blue;
                ++pixels;
            }
        }
        return new AverageColor((double)totalRed / (double)pixels, (double)totalGreen / (double)pixels, (double)totalBlue / (double)pixels);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.tika = new TikaConfig(this.getTikaConfigInputStream());
        TikaServerConfig tikaServerConfig = this.getTikaServerConfig();
        TikaResource.init((TikaConfig)this.tika, (TikaServerConfig)tikaServerConfig, (DigestingParser.Digester)new CommonsDigester(0x1400000, "md5,sha1:32"), (InputStreamFactory)this.getInputStreamFactory(this.getTikaConfigInputStream()), (ServerStatus)new ServerStatus("", 0, true));
        JAXRSServerFactoryBean sf = new JAXRSServerFactoryBean();
        sf.setOutInterceptors(Collections.singletonList(new GZIPOutInterceptor()));
        sf.setInInterceptors(Collections.singletonList(new GZIPInInterceptor()));
        this.setUpResources(sf);
        this.setUpProviders(sf);
        sf.setAddress("http://localhost:9998/");
        sf.setResourceComparator((ResourceComparator)new ProduceTypeResourceComparator());
        BindingFactoryManager manager = (BindingFactoryManager)sf.getBus().getExtension(BindingFactoryManager.class);
        JAXRSBindingFactory factory = new JAXRSBindingFactory();
        factory.setBus(sf.getBus());
        manager.registerBindingFactory("http://apache.org/cxf/binding/jaxrs", (BindingFactory)factory);
        this.server = sf.create();
    }

    protected TikaServerConfig getTikaServerConfig() {
        TikaServerConfig tikaServerConfig = new TikaServerConfig();
        tikaServerConfig.setReturnStackTrace(true);
        return tikaServerConfig;
    }

    protected InputStreamFactory getInputStreamFactory(InputStream tikaConfig) {
        return new DefaultInputStreamFactory();
    }

    protected InputStream getTikaConfigInputStream() throws IOException {
        return new ByteArrayInputStream(new String("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<properties>\n    <parsers>\n        <parser class=\"org.apache.tika.parser.DefaultParser\"/>\n    </parsers>\n</properties>").getBytes(StandardCharsets.UTF_8));
    }

    protected abstract void setUpResources(JAXRSServerFactoryBean var1);

    protected abstract void setUpProviders(JAXRSServerFactoryBean var1);

    @AfterEach
    public void tearDown() throws Exception {
        this.server.stop();
        this.server.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, String> readZipArchive(InputStream inputStream) throws IOException {
        HashMap<String, String> data = new HashMap<String, String>();
        Path tempFile = null;
        try {
            tempFile = this.writeTemporaryArchiveFile(inputStream, "zip");
            ZipFile zip = new ZipFile(tempFile.toFile());
            Enumeration entries = zip.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)zip.getInputStream(entry), (OutputStream)bos);
                data.put(entry.getName(), DigestUtils.md5Hex((byte[])bos.toByteArray()));
            }
            zip.close();
        }
        finally {
            if (tempFile != null) {
                Files.delete(tempFile);
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, byte[]> readZipArchiveBytes(InputStream inputStream) throws IOException {
        HashMap<String, byte[]> data = new HashMap<String, byte[]>();
        Path tempFile = null;
        try {
            tempFile = this.writeTemporaryArchiveFile(inputStream, "zip");
            ZipFile zip = new ZipFile(tempFile.toFile());
            Enumeration entries = zip.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)zip.getInputStream(entry), (OutputStream)bos);
                data.put(entry.getName(), bos.toByteArray());
            }
            zip.close();
        }
        finally {
            if (tempFile != null) {
                Files.delete(tempFile);
            }
        }
        return data;
    }

    protected String readArchiveText(InputStream inputStream) throws IOException {
        Path tempFile = this.writeTemporaryArchiveFile(inputStream, "zip");
        ZipFile zip = new ZipFile(tempFile.toFile());
        zip.getEntry("__TEXT__");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)zip.getInputStream(zip.getEntry("__TEXT__")), (OutputStream)bos);
        zip.close();
        Files.delete(tempFile);
        return bos.toString(StandardCharsets.UTF_8.name());
    }

    protected String readArchiveMetadataAndText(InputStream inputStream) throws IOException {
        Path tempFile = this.writeTemporaryArchiveFile(inputStream, "zip");
        ZipFile zip = new ZipFile(tempFile.toFile());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        zip.getEntry("__METADATA__");
        IOUtils.copy((InputStream)zip.getInputStream(zip.getEntry("__METADATA__")), (OutputStream)bos);
        String metadata = new String(bos.toByteArray(), StandardCharsets.UTF_8);
        bos = new ByteArrayOutputStream();
        zip.getEntry("__TEXT__");
        IOUtils.copy((InputStream)zip.getInputStream(zip.getEntry("__TEXT__")), (OutputStream)bos);
        String txt = new String(bos.toByteArray(), StandardCharsets.UTF_8);
        zip.close();
        Files.delete(tempFile);
        return metadata + "\n\n" + txt;
    }

    protected Map<String, String> readArchiveFromStream(ArchiveInputStream zip) throws IOException {
        ArchiveEntry entry;
        HashMap<String, String> data = new HashMap<String, String>();
        while ((entry = zip.getNextEntry()) != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)zip, (OutputStream)bos);
            data.put(entry.getName(), DigestUtils.md5Hex((byte[])bos.toByteArray()));
        }
        return data;
    }

    private Path writeTemporaryArchiveFile(InputStream inputStream, String archiveType) throws IOException {
        Path tmp = Files.createTempFile("apache-tika-server-test-tmp-", "." + archiveType, new FileAttribute[0]);
        Files.copy(inputStream, tmp, StandardCopyOption.REPLACE_EXISTING);
        return tmp;
    }

    public static class AverageColor {
        double red;
        double green;
        double blue;

        public AverageColor(double averageRed, double averageGreen, double averageBlue) {
            this.red = averageRed;
            this.green = averageGreen;
            this.blue = averageBlue;
        }

        public double getRed() {
            return this.red;
        }

        public double getGreen() {
            return this.green;
        }

        public double getBlue() {
            return this.blue;
        }

        public String toString() {
            return "AverageColor{red=" + this.red + ", green=" + this.green + ", blue=" + this.blue + "}";
        }
    }
}

