/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.client;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.tika.server.client.TikaClientCLI;
import org.apache.tika.server.client.TikaServerClientConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class TestBasic {
    @Test
    public void testConfig() throws Exception {
        Path p = Paths.get(TestBasic.class.getResource("/tika-config-simple-fs-emitter.xml").toURI());
        Assertions.assertTrue((boolean)Files.isRegularFile(p, new LinkOption[0]));
        TikaServerClientConfig clientConfig = TikaServerClientConfig.build((Path)p);
        Assertions.assertEquals((int)6, (int)clientConfig.getNumThreads());
        Assertions.assertEquals((int)5, (int)clientConfig.getHttpClientFactory().getMaxConnections());
    }

    @Test
    @Disabled(value="turn this into an actual test in tika-integration-tests?")
    public void testBasic() throws Exception {
        Path p = Paths.get(TestBasic.class.getResource("/tika-config-simple-fs-emitter.xml").toURI());
        Assertions.assertTrue((boolean)Files.isRegularFile(p, new LinkOption[0]));
        String[] args = new String[]{p.toAbsolutePath().toString()};
        long start = System.currentTimeMillis();
        TikaClientCLI.main((String[])args);
        long elapsed = System.currentTimeMillis() - start;
        System.out.println("elapsed " + elapsed);
    }
}

