/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.reporters.opensearch;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tika.client.HttpClientFactory;
import org.apache.tika.client.TikaClientException;
import org.apache.tika.config.Field;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.metadata.ExternalProcess;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.pipes.FetchEmitTuple;
import org.apache.tika.pipes.PipesReporter;
import org.apache.tika.pipes.PipesResult;
import org.apache.tika.pipes.reporters.opensearch.OpenSearchClient;
import org.apache.tika.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSearchPipesReporter
extends PipesReporter
implements Initializable {
    private static final Logger LOG = LoggerFactory.getLogger(OpenSearchPipesReporter.class);
    public static String DEFAULT_PARSE_TIME_KEY = "parse_time_ms";
    public static String DEFAULT_PARSE_STATUS_KEY = "parse_status";
    public static String DEFAULT_EXIT_VALUE_KEY = "exit_value";
    private OpenSearchClient openSearchClient;
    private String openSearchUrl;
    private HttpClientFactory httpClientFactory = new HttpClientFactory();
    private Set<String> includeStatus = new HashSet<String>();
    private Set<String> excludeStatus = new HashSet<String>();
    private String parseTimeKey = DEFAULT_PARSE_TIME_KEY;
    private String parseStatusKey = DEFAULT_PARSE_STATUS_KEY;
    private String exitValueKey = DEFAULT_EXIT_VALUE_KEY;
    private boolean includeRouting = false;

    public void report(FetchEmitTuple t, PipesResult result, long elapsed) {
        Metadata m;
        if (!this.shouldReport(result)) {
            return;
        }
        Metadata metadata = new Metadata();
        metadata.set(this.parseStatusKey, result.getStatus().name());
        metadata.set(this.parseTimeKey, Long.toString(elapsed));
        if (result.getEmitData() != null && result.getEmitData().getMetadataList() != null && result.getEmitData().getMetadataList().size() > 0 && (m = (Metadata)result.getEmitData().getMetadataList().get(0)).get(ExternalProcess.EXIT_VALUE) != null) {
            metadata.set(this.exitValueKey, m.get(ExternalProcess.EXIT_VALUE));
        }
        try {
            if (this.includeRouting) {
                this.openSearchClient.emitDocument(t.getEmitKey().getEmitKey(), t.getEmitKey().getEmitKey(), metadata);
            } else {
                this.openSearchClient.emitDocument(t.getEmitKey().getEmitKey(), null, metadata);
            }
        }
        catch (IOException | TikaClientException e) {
            LOG.warn("failed to report status for '" + t.getId() + "'", (Throwable)e);
        }
    }

    public void error(Throwable t) {
        LOG.error("crashed", t);
    }

    public void error(String msg) {
        LOG.error("crashed {}", (Object)msg);
    }

    private boolean shouldReport(PipesResult result) {
        if (this.includeStatus.size() > 0) {
            return this.includeStatus.contains(result.getStatus().name());
        }
        return this.excludeStatus.size() <= 0 || !this.excludeStatus.contains(result.getStatus().name());
    }

    @Field
    public void setConnectionTimeout(int connectionTimeout) {
        this.httpClientFactory.setConnectTimeout(connectionTimeout);
    }

    @Field
    public void setSocketTimeout(int socketTimeout) {
        this.httpClientFactory.setSocketTimeout(socketTimeout);
    }

    @Field
    public void setOpenSearchUrl(String openSearchUrl) {
        this.openSearchUrl = openSearchUrl;
    }

    @Field
    public void setUserName(String userName) {
        this.httpClientFactory.setUserName(userName);
    }

    @Field
    public void setPassword(String password) {
        this.httpClientFactory.setPassword(password);
    }

    @Field
    public void setAuthScheme(String authScheme) {
        this.httpClientFactory.setAuthScheme(authScheme);
    }

    @Field
    public void setProxyHost(String proxyHost) {
        this.httpClientFactory.setProxyHost(proxyHost);
    }

    @Field
    public void setProxyPort(int proxyPort) {
        this.httpClientFactory.setProxyPort(proxyPort);
    }

    @Field
    public void setIncludeStatuses(List<String> statusList) {
        this.includeStatus.addAll(statusList);
    }

    @Field
    public void setExcludeStatuses(List<String> statusList) {
        this.excludeStatus.addAll(statusList);
    }

    @Field
    public void setIncludeRouting(boolean includeRouting) {
        this.includeRouting = includeRouting;
    }

    @Field
    public void setKeyPrefix(String keyPrefix) {
        this.parseStatusKey = keyPrefix + DEFAULT_PARSE_STATUS_KEY;
        this.parseTimeKey = keyPrefix + DEFAULT_PARSE_TIME_KEY;
        this.exitValueKey = keyPrefix + DEFAULT_EXIT_VALUE_KEY;
    }

    public void initialize(Map<String, Param> params) throws TikaConfigException {
        if (StringUtils.isBlank((String)this.openSearchUrl)) {
            throw new TikaConfigException("Must specify an open search url!");
        }
        this.openSearchClient = new OpenSearchClient(this.openSearchUrl, this.httpClientFactory.build());
    }

    public void checkInitialization(InitializableProblemHandler problemHandler) throws TikaConfigException {
        TikaConfig.mustNotBeEmpty((String)"openSearchUrl", (String)this.openSearchUrl);
        for (String status : this.includeStatus) {
            if (!this.excludeStatus.contains(status)) continue;
            throw new TikaConfigException("Can't have a status in both include and exclude: " + status);
        }
        HashSet<String> statuses = new HashSet<String>();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (PipesResult.STATUS status : PipesResult.STATUS.values()) {
            statuses.add(status.name());
            if (++i > 1) {
                sb.append(", ");
            }
            sb.append(status.name());
        }
        for (String include : this.includeStatus) {
            if (statuses.contains(include)) continue;
            throw new TikaConfigException("I regret I don't recognize '" + include + "' in the include list. I recognize: " + sb.toString());
        }
        for (String exclude : this.excludeStatus) {
            if (statuses.contains(exclude)) continue;
            throw new TikaConfigException("I regret I don't recognize '" + exclude + "' in the exclude list. I recognize: " + sb.toString());
        }
    }
}

