/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.reporters.opensearch;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.tika.client.TikaClientException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.pipes.reporters.opensearch.JsonResponse;
import org.apache.tika.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSearchClient {
    private static final Logger LOG = LoggerFactory.getLogger(OpenSearchClient.class);
    protected final String openSearchUrl;
    protected final HttpClient httpClient;

    protected OpenSearchClient(String openSearchUrl, HttpClient httpClient) {
        this.openSearchUrl = openSearchUrl;
        this.httpClient = httpClient;
    }

    public void emitDocument(String emitKey, String routing, Metadata metadata) throws IOException, TikaClientException {
        StringWriter writer = new StringWriter();
        this.writeBulkRequest(emitKey, routing, writer);
        writer.append("\n");
        this.writeDoc(metadata, writer);
        writer.append("\n");
        this.emitJson(writer.toString());
    }

    private void emitJson(String json) throws IOException, TikaClientException {
        String requestUrl = this.openSearchUrl + "/_bulk";
        JsonResponse response = this.postJson(requestUrl, json);
        if (response.getStatus() != 200) {
            throw new TikaClientException(response.getMsg());
        }
        JsonNode errorNode = response.getJson().get("errors");
        if (errorNode.asText().equals("true")) {
            throw new TikaClientException(response.getJson().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonResponse postJson(String url, String json) throws IOException {
        HttpPost httpRequest = new HttpPost(url);
        StringEntity entity = new StringEntity(json, StandardCharsets.UTF_8);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Accept", "application/json");
        httpRequest.setHeader("Content-type", "application/json; charset=utf-8");
        HttpResponse response = null;
        try {
            response = this.httpClient.execute(httpRequest);
            int status = response.getStatusLine().getStatusCode();
            if (status == 200) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));){
                    ObjectMapper mapper = new ObjectMapper();
                    JsonNode node = mapper.readTree(reader);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("node:", (Object)node);
                    }
                    JsonResponse jsonResponse = new JsonResponse(200, node);
                    return jsonResponse;
                }
            }
            JsonResponse jsonResponse = new JsonResponse(status, new String(EntityUtils.toByteArray(response.getEntity()), StandardCharsets.UTF_8));
            return jsonResponse;
        }
        finally {
            if (response != null && response instanceof CloseableHttpResponse) {
                ((CloseableHttpResponse)response).close();
            }
            httpRequest.releaseConnection();
        }
    }

    public void writeDoc(Metadata metadata, StringWriter writer) throws IOException {
        try (JsonGenerator jsonGenerator = new JsonFactory().createGenerator(writer);){
            jsonGenerator.writeStartObject();
            jsonGenerator.writeObjectFieldStart("doc");
            OpenSearchClient.writeMetadata(metadata, jsonGenerator);
            jsonGenerator.writeEndObject();
            jsonGenerator.writeBooleanField("doc_as_upsert", true);
            jsonGenerator.writeEndObject();
        }
    }

    public void writeBulkRequest(String id, String routing, StringWriter writer) throws IOException {
        try (JsonGenerator jsonGenerator = new JsonFactory().createGenerator(writer);){
            jsonGenerator.writeStartObject();
            jsonGenerator.writeObjectFieldStart("update");
            jsonGenerator.writeStringField("_id", id);
            if (!StringUtils.isEmpty((CharSequence)routing)) {
                jsonGenerator.writeStringField("routing", routing);
            }
            jsonGenerator.writeNumberField("retry_on_conflict", 3);
            jsonGenerator.writeEndObject();
            jsonGenerator.writeEndObject();
        }
    }

    private static void writeMetadata(Metadata metadata, JsonGenerator jsonGenerator) throws IOException {
        for (String n : metadata.names()) {
            String[] vals = metadata.getValues(n);
            if (vals.length == 1) {
                jsonGenerator.writeStringField(n, vals[0]);
                continue;
            }
            jsonGenerator.writeArrayFieldStart(n);
            for (String v : vals) {
                jsonGenerator.writeString(v);
            }
            jsonGenerator.writeEndArray();
        }
    }
}

