/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.pipesiterator.s3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.tika.pipes.FetchEmitTuple;
import org.apache.tika.pipes.pipesiterator.PipesIterator;
import org.apache.tika.pipes.pipesiterator.s3.S3PipesIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@Disabled(value="turn into an actual unit test")
public class TestS3PipesIterator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimple() throws Exception {
        S3PipesIterator it = new S3PipesIterator();
        it.setFetcherName("s3");
        it.setBucket("");
        it.setProfile("");
        it.setRegion("");
        it.initialize(Collections.EMPTY_MAP);
        int numConsumers = 6;
        ArrayBlockingQueue<FetchEmitTuple> queue = new ArrayBlockingQueue<FetchEmitTuple>(10);
        ExecutorService es = Executors.newFixedThreadPool(numConsumers + 1);
        ExecutorCompletionService<Integer> c = new ExecutorCompletionService<Integer>(es);
        ArrayList<MockFetcher> fetchers = new ArrayList<MockFetcher>();
        for (int i = 0; i < numConsumers; ++i) {
            MockFetcher fetcher = new MockFetcher(queue);
            fetchers.add(fetcher);
            c.submit(fetcher);
        }
        for (FetchEmitTuple t : it) {
            queue.offer(t);
        }
        for (int i = 0; i < numConsumers; ++i) {
            queue.offer(PipesIterator.COMPLETED_SEMAPHORE);
        }
        int finished = 0;
        int completed = 0;
        try {
            while (finished++ < numConsumers + 1) {
                Future f = c.take();
                completed += ((Integer)f.get()).intValue();
            }
        }
        finally {
            es.shutdownNow();
        }
        Assertions.assertEquals((int)20000, (int)completed);
    }

    private static class MockFetcher
    implements Callable<Integer> {
        private final ArrayBlockingQueue<FetchEmitTuple> queue;
        private final List<FetchEmitTuple> pairs = new ArrayList<FetchEmitTuple>();

        private MockFetcher(ArrayBlockingQueue<FetchEmitTuple> queue) {
            this.queue = queue;
        }

        @Override
        public Integer call() throws Exception {
            FetchEmitTuple t;
            while ((t = this.queue.poll(1L, TimeUnit.HOURS)) != PipesIterator.COMPLETED_SEMAPHORE) {
                this.pairs.add(t);
            }
            return this.pairs.size();
        }
    }
}

