/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.pipesiterator.s3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.iterable.S3Objects;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tika.config.Field;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.io.FilenameUtils;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.pipes.FetchEmitTuple;
import org.apache.tika.pipes.HandlerConfig;
import org.apache.tika.pipes.emitter.EmitKey;
import org.apache.tika.pipes.fetcher.FetchKey;
import org.apache.tika.pipes.pipesiterator.PipesIterator;
import org.apache.tika.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3PipesIterator
extends PipesIterator
implements Initializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(S3PipesIterator.class);
    private String prefix = "";
    private String region;
    private String accessKey;
    private String secretKey;
    private String endpointConfigurationService;
    private String credentialsProvider;
    private String profile;
    private String bucket;
    private Pattern fileNamePattern = null;
    private int maxConnections = 50;
    private boolean pathStyleAccessEnabled = false;
    private AmazonS3 s3Client;

    @Field
    public void setEndpointConfigurationService(String endpointConfigurationService) {
        this.endpointConfigurationService = endpointConfigurationService;
    }

    @Field
    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    @Field
    public void setRegion(String region) {
        this.region = region;
    }

    @Field
    public void setProfile(String profile) {
        this.profile = profile;
    }

    @Field
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Field
    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    @Field
    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    @Field
    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    @Field
    public void setCredentialsProvider(String credentialsProvider) {
        if (!(credentialsProvider.equals("profile") || credentialsProvider.equals("instance") || credentialsProvider.equals("key_secret"))) {
            throw new IllegalArgumentException("credentialsProvider must be either 'profile', 'instance' or 'key_secret'");
        }
        this.credentialsProvider = credentialsProvider;
    }

    @Field
    public void setFileNamePattern(String fileNamePattern) {
        this.fileNamePattern = Pattern.compile(fileNamePattern);
    }

    @Field
    public void setFileNamePattern(Pattern fileNamePattern) {
        this.fileNamePattern = fileNamePattern;
    }

    @Field
    public void setPathStyleAccessEnabled(boolean pathStyleAccessEnabled) {
        this.pathStyleAccessEnabled = pathStyleAccessEnabled;
    }

    public void initialize(Map<String, Param> params) throws TikaConfigException {
        AWSCredentialsProvider provider;
        if (this.credentialsProvider.equals("instance")) {
            provider = InstanceProfileCredentialsProvider.getInstance();
        } else if (this.credentialsProvider.equals("profile")) {
            provider = new ProfileCredentialsProvider(this.profile);
        } else if (this.credentialsProvider.equals("key_secret")) {
            provider = new AWSStaticCredentialsProvider(new BasicAWSCredentials(this.accessKey, this.secretKey));
        } else {
            throw new TikaConfigException("credentialsProvider must be set and must be either 'instance', 'profile' or 'key_secret'");
        }
        ClientConfiguration clientConfig = new ClientConfiguration().withMaxConnections(this.maxConnections);
        try {
            AmazonS3ClientBuilder amazonS3ClientBuilder = (AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withClientConfiguration(clientConfig)).withCredentials(provider)).withPathStyleAccessEnabled(this.pathStyleAccessEnabled);
            if (!StringUtils.isBlank((String)this.endpointConfigurationService)) {
                amazonS3ClientBuilder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.endpointConfigurationService, this.region));
            } else {
                amazonS3ClientBuilder.withRegion(this.region);
            }
            this.s3Client = (AmazonS3)amazonS3ClientBuilder.build();
        }
        catch (AmazonClientException e) {
            throw new TikaConfigException("can't initialize s3 pipesiterator", (Throwable)e);
        }
    }

    public void checkInitialization(InitializableProblemHandler problemHandler) throws TikaConfigException {
        super.checkInitialization(problemHandler);
        TikaConfig.mustNotBeEmpty((String)"bucket", (String)this.bucket);
        TikaConfig.mustNotBeEmpty((String)"region", (String)this.region);
    }

    protected void enqueue() throws InterruptedException, IOException, TimeoutException {
        String fetcherName = this.getFetcherName();
        String emitterName = this.getEmitterName();
        long start = System.currentTimeMillis();
        int count = 0;
        HandlerConfig handlerConfig = this.getHandlerConfig();
        Matcher fileNameMatcher = null;
        if (this.fileNamePattern != null) {
            fileNameMatcher = this.fileNamePattern.matcher("");
        }
        for (S3ObjectSummary summary : S3Objects.withPrefix(this.s3Client, this.bucket, this.prefix)) {
            if (fileNameMatcher != null && !this.accept(fileNameMatcher, summary.getKey())) continue;
            long elapsed = System.currentTimeMillis() - start;
            LOGGER.debug("adding ({}) {} in {} ms", new Object[]{count, summary.getKey(), elapsed});
            ParseContext parseContext = new ParseContext();
            parseContext.set(HandlerConfig.class, (Object)handlerConfig);
            this.tryToAdd(new FetchEmitTuple(summary.getKey(), new FetchKey(fetcherName, summary.getKey()), new EmitKey(emitterName, summary.getKey()), new Metadata(), parseContext, this.getOnParseException()));
            ++count;
        }
        long elapsed = System.currentTimeMillis() - start;
        LOGGER.info("finished enqueuing {} files in {} ms", (Object)count, (Object)elapsed);
    }

    private boolean accept(Matcher fileNameMatcher, String key) {
        String fName = FilenameUtils.getName((String)key);
        return fileNameMatcher.reset(fName).find();
    }
}

