/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.pipesiterator.kafka;

import java.time.Duration;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.tika.config.Field;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.pipes.FetchEmitTuple;
import org.apache.tika.pipes.HandlerConfig;
import org.apache.tika.pipes.emitter.EmitKey;
import org.apache.tika.pipes.fetcher.FetchKey;
import org.apache.tika.pipes.pipesiterator.PipesIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaPipesIterator
extends PipesIterator
implements Initializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaPipesIterator.class);
    String topic;
    String bootstrapServers;
    String keySerializer;
    String valueSerializer;
    String groupId;
    String autoOffsetReset = "earliest";
    int pollDelayMs = 100;
    int emitMax = -1;
    int groupInitialRebalanceDelayMs = 3000;
    private Properties props;
    private KafkaConsumer<String, String> consumer;

    @Field
    public void setTopic(String topic) {
        this.topic = topic;
    }

    @Field
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Field
    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    @Field
    public void setKeySerializer(String keySerializer) {
        this.keySerializer = keySerializer;
    }

    @Field
    public void setAutoOffsetReset(String autoOffsetReset) {
        this.autoOffsetReset = autoOffsetReset;
    }

    @Field
    public void setValueSerializer(String valueSerializer) {
        this.valueSerializer = valueSerializer;
    }

    @Field
    public void setPollDelayMs(int pollDelayMs) {
        this.pollDelayMs = pollDelayMs;
    }

    @Field
    public void setGroupInitialRebalanceDelayMs(int groupInitialRebalanceDelayMs) {
        this.groupInitialRebalanceDelayMs = groupInitialRebalanceDelayMs;
    }

    @Field
    public void setEmitMax(int emitMax) {
        this.emitMax = emitMax;
    }

    private void safePut(Properties props, String key, Object val) {
        if (val != null) {
            props.put(key, val);
        }
    }

    public void initialize(Map<String, Param> params) {
        this.props = new Properties();
        this.safePut(this.props, "bootstrap.servers", this.bootstrapServers);
        this.safePut(this.props, "key.deserializer", this.serializerClass(this.keySerializer, StringDeserializer.class));
        this.safePut(this.props, "value.deserializer", this.serializerClass(this.valueSerializer, StringDeserializer.class));
        this.safePut(this.props, "group.id", this.groupId);
        this.safePut(this.props, "auto.offset.reset", this.autoOffsetReset);
        this.safePut(this.props, "group.inital.rebalance.delay.ms", this.groupInitialRebalanceDelayMs);
        this.consumer = new KafkaConsumer(this.props);
        this.consumer.subscribe(Arrays.asList(this.topic));
    }

    private Object serializerClass(String className, Class defaultClass) {
        try {
            return className == null ? defaultClass : Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Could not find key serializer class: {}", (Object)className);
            return null;
        }
    }

    public void checkInitialization(InitializableProblemHandler problemHandler) throws TikaConfigException {
        super.checkInitialization(problemHandler);
        TikaConfig.mustNotBeEmpty((String)"bootstrapServers", (String)this.bootstrapServers);
        TikaConfig.mustNotBeEmpty((String)"topic", (String)this.topic);
    }

    protected void enqueue() throws InterruptedException, TimeoutException {
        ConsumerRecords<String, String> records;
        String fetcherName = this.getFetcherName();
        String emitterName = this.getEmitterName();
        long start = System.currentTimeMillis();
        int count = 0;
        HandlerConfig handlerConfig = this.getHandlerConfig();
        do {
            records = this.consumer.poll(Duration.ofMillis(this.pollDelayMs));
            for (ConsumerRecord<String, String> consumerRecord : records) {
                long elapsed = System.currentTimeMillis() - start;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("adding ({}) {} in {} ms", count, consumerRecord.key(), elapsed);
                }
                ParseContext parseContext = new ParseContext();
                parseContext.set(HandlerConfig.class, (Object)handlerConfig);
                this.tryToAdd(new FetchEmitTuple(consumerRecord.key(), new FetchKey(fetcherName, consumerRecord.key()), new EmitKey(emitterName, consumerRecord.key()), new Metadata(), parseContext, this.getOnParseException()));
                ++count;
            }
        } while ((this.emitMax > 0 || count < this.emitMax) && !records.isEmpty());
        long elapsed = System.currentTimeMillis() - start;
        LOGGER.info("Finished enqueuing {} files in {} ms", (Object)count, (Object)elapsed);
    }
}

