/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.cloud.storage.IOAutoCloseable;
import com.google.cloud.storage.ObjectReadSession;
import com.google.cloud.storage.RangeSpec;
import com.google.cloud.storage.ReadAsChannel;
import com.google.cloud.storage.ReadAsSeekableChannel;
import com.google.cloud.storage.ReadProjectionConfigs;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ObjectReadSessionSeekableByteChannel
implements SeekableByteChannel,
IOAutoCloseable {
    private final ObjectReadSession session;
    private final ReadAsSeekableChannel config;
    private final long size;
    private final ReadAsChannel channelConfig;
    private final IOAutoCloseable closeAlongWithThis;
    private ReadableByteChannel rbc;
    private long position;
    private boolean open = true;
    private @Nullable RangeSpec lastRangeSpec;

    ObjectReadSessionSeekableByteChannel(ObjectReadSession session, ReadAsSeekableChannel config, IOAutoCloseable closeAlongWithThis) {
        this.session = session;
        this.config = config;
        this.closeAlongWithThis = closeAlongWithThis;
        this.size = session.getResource().getSize();
        this.position = 0L;
        this.channelConfig = ReadProjectionConfigs.asChannel().withCrc32cValidationEnabled(config.getCrc32cValidationEnabled());
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int read;
        if (!this.open) {
            throw new ClosedChannelException();
        }
        if (this.remaining() <= 0L) {
            return -1;
        }
        int totalRead = 0;
        if (this.rbc == null) {
            RangeSpec apply = this.config.getRangeSpecFunction().apply(this.position, this.lastRangeSpec);
            Preconditions.checkState(apply.begin() == this.position, "RangeSpec does not begin at provided position. expected = %s, actual = %s", this.position, apply.begin());
            this.rbc = this.session.readAs(this.channelConfig.withRangeSpec(apply));
            this.lastRangeSpec = apply;
        }
        if ((read = this.rbc.read(dst)) < 0) {
            this.rbc.close();
            this.rbc = null;
        } else {
            totalRead += read;
            this.position += (long)read;
        }
        return totalRead;
    }

    private long remaining() {
        return this.size - this.position;
    }

    @Override
    public long size() throws IOException {
        return this.size;
    }

    @Override
    public long position() throws IOException {
        return this.position;
    }

    @Override
    public SeekableByteChannel position(long newPosition) throws IOException {
        Preconditions.checkArgument(newPosition >= 0L, "newPosition >= 0 (%s >= 0)", newPosition);
        if (this.position == newPosition) {
            return this;
        }
        this.position = newPosition;
        try (ReadableByteChannel ignore = this.rbc;){
            this.rbc = null;
        }
        return this;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        throw new UnsupportedOperationException("write(ByteBuffer)");
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        throw new UnsupportedOperationException("truncate(long)");
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        if (!this.open) {
            return;
        }
        try (IOAutoCloseable ignore1 = this.closeAlongWithThis;
             ReadableByteChannel ignore2 = this.rbc;){
            this.open = false;
            this.rbc = null;
        }
    }
}

