/*
 * Decompiled with CFR 0.152.
 */
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.tika.pipes.FetchEmitTuple;
import org.apache.tika.pipes.pipesiterator.PipesIterator;
import org.apache.tika.pipes.pipesiterator.csv.CSVPipesIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCSVPipesIterator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimple() throws Exception {
        Path p = this.get("test-simple.csv");
        CSVPipesIterator it = new CSVPipesIterator();
        it.setFetcherName("fsf");
        it.setEmitterName("fse");
        it.setCsvPath(p);
        it.setFetchKeyColumn("fetchKey");
        int numConsumers = 2;
        ExecutorService es = Executors.newFixedThreadPool(numConsumers);
        ExecutorCompletionService<Integer> c = new ExecutorCompletionService<Integer>(es);
        ArrayBlockingQueue<FetchEmitTuple> queue = new ArrayBlockingQueue<FetchEmitTuple>(100);
        ArrayList<MockFetcher> fetchers = new ArrayList<MockFetcher>();
        for (int i = 0; i < numConsumers; ++i) {
            MockFetcher f = new MockFetcher(queue);
            fetchers.add(f);
            c.submit(f);
        }
        for (FetchEmitTuple t : it) {
            queue.offer(t);
        }
        for (int i = 0; i < numConsumers; ++i) {
            queue.offer(PipesIterator.COMPLETED_SEMAPHORE);
        }
        int finished = 0;
        int completed = 0;
        try {
            while (finished++ < numConsumers) {
                Future f = c.take();
                completed += ((Integer)f.get()).intValue();
            }
        }
        finally {
            es.shutdownNow();
        }
        Assertions.assertEquals((int)5, (int)completed);
        for (MockFetcher f : fetchers) {
            for (FetchEmitTuple t : f.pairs) {
                String id = t.getMetadata().get("id");
                Assertions.assertEquals((Object)("path/to/my/file" + id), (Object)t.getFetchKey().getFetchKey());
                Assertions.assertEquals((Object)("project" + (Integer.parseInt(id) % 2 == 1 ? "a" : "b")), (Object)t.getMetadata().get("project"));
            }
        }
    }

    @Test
    public void testBadFetchKeyCol() throws Exception {
        Path p = this.get("test-simple.csv");
        CSVPipesIterator it = new CSVPipesIterator();
        it.setFetcherName("fs");
        it.setCsvPath(p);
        Assertions.assertThrows(RuntimeException.class, () -> {
            it.setFetchKeyColumn("fetchKeyDoesntExist");
            for (FetchEmitTuple fetchEmitTuple : it) {
            }
        });
    }

    private Path get(String testFileName) throws Exception {
        return Paths.get(TestCSVPipesIterator.class.getResource("/" + testFileName).toURI());
    }

    private static class MockFetcher
    implements Callable<Integer> {
        private final ArrayBlockingQueue<FetchEmitTuple> queue;
        private final List<FetchEmitTuple> pairs = new ArrayList<FetchEmitTuple>();

        private MockFetcher(ArrayBlockingQueue<FetchEmitTuple> queue) {
            this.queue = queue;
        }

        @Override
        public Integer call() throws Exception {
            FetchEmitTuple t;
            while ((t = this.queue.poll(1L, TimeUnit.HOURS)) != PipesIterator.COMPLETED_SEMAPHORE) {
                this.pairs.add(t);
            }
            return this.pairs.size();
        }
    }
}

